	varying vec4 diffuse,ambientGlobal, ambient;
	
	varying vec3 normal,lightDir,halfVector;
	varying float dist;
	
	uniform int mymode;
	
	uniform sampler2DRect map_diffuse;
	
	uniform int use_map_opacity;
	uniform sampler2DRect map_opacity;
	
	uniform int use_map_environment;
	uniform sampler2DRect map_environment;
	float envMul=0.2;
	
	
	
	
	void main()
	{

			vec3 n,halfV,viewV,ldir;
			float NdotL,NdotHV;
			vec4 color = ambientGlobal; 
			vec4 lcolor = ambientGlobal; 
			float att;
			
			/* a fragment shader can't write a varying variable, hence we need
			a new variable to store the normalized interpolated normal */
			n = normalize(normal);
			
			/* compute the dot product between normal and normalized lightdir */
			NdotL = max(dot(n,normalize(lightDir)),0.0);
		
			if (NdotL > 0.0) { 
			
				att = 1.2 / (gl_LightSource[1].constantAttenuation +
						gl_LightSource[1].linearAttenuation * dist +
						gl_LightSource[1].quadraticAttenuation * dist * dist);
				lcolor += att * (diffuse * NdotL + ambient);
			
				
				halfV = normalize(halfVector);
				NdotHV = max(dot(n,halfV),0.0);
				
				//color += 0.1*(att * gl_FrontMaterial.specular * gl_LightSource[1].specular *	pow(NdotHV,gl_FrontMaterial.shininess));
				
				//deptharray[1]=gl_FragCoord.z;
				//deptharray[gl_FragCoord.x+gl_FragCoord.y*screenWidth]=gl_FragCoord.z*10.0;
				//gl_FragData[1]=color;//vec4(gl_FragCoord.z,0,0,0);
				color.a=1.0;
		}

		//lcolor=lcolor*10.0;
		color = lcolor*texture2DRect(map_diffuse, vec2(gl_TexCoord[0].s,gl_TexCoord[0].t));
		
		

//		if(use_map_environment==1)color = color+(lcolor*texRECT(map_environment, vec2(gl_TexCoord[1].s*1024,gl_TexCoord[1].t*1024)))*envMul;
		
		if(use_map_opacity==1)color.a= texture2DRect(map_opacity, vec2(gl_TexCoord[0].s,gl_TexCoord[0].t)).r;
		
		if(use_map_opacity==1)color=vec4(1,0,0,1);
		
		//if((color.r+color.g+color.b)/3.0>0.5)color.rgb*=2.0;
		//else color.rgb*=0.5;
		

		
		//color
		gl_FragColor=color;
	}

	
	
	
	
	