/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.mesh;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;
import sumo.v3d.material.Material;
import sumo.v3d.mesh.Mesh;

public class VBO {
    static ArrayList<VBO> vbos = new ArrayList();
    String hash = "";
    Material material;
    int vboID = -1;
    int vboID2 = -1;
    int tangentAttribId = -1;
    int type = 1;
    boolean rebuild = true;
    static final int TYPE_DYNAMIC = 2;
    static final int TYPE_STATIC = 1;
    static final int TYPE_STREAM = 3;
    public float lastRebuild = 0.0f;
    boolean rebuildIndices = true;
    boolean useTextCoords = true;
    boolean useTangents = false;
    int indlength = -1;
    int stride = 0;
    int offset = 0;

    public void draw(boolean bindMaterial) {
        if (this.indlength == -1) {
            System.out.println("index NULL!!!");
            return;
        }
        if (bindMaterial) {
            this.material.bind();
        }
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32885);
        if (this.useTextCoords) {
            GL11.glEnableClientState((int)32888);
        }
        ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.vboID);
        ARBVertexBufferObject.glBindBufferARB((int)34963, (int)this.vboID2);
        this.setupBufferFormat();
        if (this.material.settings.wireframe) {
            GL11.glDrawElements((int)3, (int)this.indlength, (int)5125, (long)0L);
        } else {
            GL11.glDrawElements((int)4, (int)this.indlength, (int)5125, (long)0L);
        }
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32885);
        if (this.useTextCoords) {
            GL11.glDisableClientState((int)32888);
        }
        if (bindMaterial) {
            this.material.unbind();
        }
    }

    void rebuildBuffer(Mesh mesh, Material meshMaterial, float time) {
        this.material = meshMaterial;
        if (mesh.vertices == null) {
            return;
        }
        int indi = 0;
        FloatBuffer myBuffer = null;
        IntBuffer indices = null;
        int mystride = 24;
        if (meshMaterial.settings.mapDiffuse == null || mesh.textureCoords == null) {
            mystride = 18;
            this.useTextCoords = false;
        }
        int facecount = 0;
        for (int i = 0; i < mesh.faces.length; ++i) {
            if (mesh.faces[i].m != meshMaterial.id) continue;
            ++facecount;
        }
        float[] data = new float[facecount * mystride];
        int[] ind = new int[facecount * 3];
        int foundfaces = 0;
        int i = 0;
        for (int l = 0; l < mesh.faces.length; ++l) {
            if (mesh.faces[l].m != meshMaterial.id) continue;
            ++foundfaces;
            indi = i * 3;
            int dataindex = i * mystride;
            ind[indi + 0] = indi + 0;
            ind[indi + 1] = indi + 1;
            ind[indi + 2] = indi + 2;
            data[dataindex++] = mesh.vertices[mesh.faces[l].x].x;
            data[dataindex++] = mesh.vertices[mesh.faces[l].x].y;
            data[dataindex++] = mesh.vertices[mesh.faces[l].x].z;
            if (mesh.normals == null) {
                System.out.println("normals null!");
            }
            data[dataindex++] = mesh.normals[l * 3 + 0].x;
            data[dataindex++] = mesh.normals[l * 3 + 0].y;
            data[dataindex++] = mesh.normals[l * 3 + 0].z;
            if (this.useTextCoords) {
                data[dataindex++] = mesh.textureCoords[mesh.textureFaces[l].x].x * (float)meshMaterial.settings.mapDiffuse.texture.width;
                data[dataindex++] = mesh.textureCoords[mesh.textureFaces[l].x].y * (float)meshMaterial.settings.mapDiffuse.texture.height;
            }
            data[dataindex++] = mesh.vertices[mesh.faces[l].y].x;
            data[dataindex++] = mesh.vertices[mesh.faces[l].y].y;
            data[dataindex++] = mesh.vertices[mesh.faces[l].y].z;
            data[dataindex++] = mesh.normals[l * 3 + 1].x;
            data[dataindex++] = mesh.normals[l * 3 + 1].y;
            data[dataindex++] = mesh.normals[l * 3 + 1].z;
            if (this.useTextCoords) {
                data[dataindex++] = mesh.textureCoords[mesh.textureFaces[l].y].x * (float)meshMaterial.settings.mapDiffuse.texture.width;
                data[dataindex++] = mesh.textureCoords[mesh.textureFaces[l].y].y * (float)meshMaterial.settings.mapDiffuse.texture.height;
            }
            data[dataindex++] = mesh.vertices[mesh.faces[l].z].x;
            data[dataindex++] = mesh.vertices[mesh.faces[l].z].y;
            data[dataindex++] = mesh.vertices[mesh.faces[l].z].z;
            data[dataindex++] = mesh.normals[l * 3 + 2].x;
            data[dataindex++] = mesh.normals[l * 3 + 2].y;
            data[dataindex++] = mesh.normals[l * 3 + 2].z;
            if (this.useTextCoords) {
                data[dataindex++] = mesh.textureCoords[mesh.textureFaces[i].z].x * (float)meshMaterial.settings.mapDiffuse.texture.width;
                data[dataindex++] = mesh.textureCoords[mesh.textureFaces[i].z].y * (float)meshMaterial.settings.mapDiffuse.texture.height;
            }
            ++i;
        }
        if (this.rebuildIndices) {
            if (indices == null) {
                indices = BufferUtils.createIntBuffer((int)ind.length);
            }
            indices.put(ind);
            indices.flip();
        }
        if (myBuffer == null) {
            myBuffer = BufferUtils.createFloatBuffer((int)data.length);
        }
        myBuffer.put(data);
        myBuffer.flip();
        boolean buildvbo = true;
        if (this.type == 1) {
            String checksum = "";
            ByteBuffer bb = ByteBuffer.allocate(data.length * 4);
            for (int ci = 0; ci < data.length; ++ci) {
                bb.putFloat(ci, data[i]);
            }
            try {
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(bb);
                byte[] digest = md.digest();
                for (int di = 0; di < digest.length; ++di) {
                    String hex = Integer.toHexString(digest[di]);
                    if (hex.length() == 1) {
                        hex = "0" + hex;
                    }
                    hex = hex.substring(hex.length() - 2);
                    this.hash = this.hash + hex;
                }
                checksum = "";
                checksum = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (buildvbo) {
            if (this.vboID == -1) {
                this.vboID = this.createVBOID();
            }
            if (this.vboID2 == -1) {
                this.vboID2 = this.createVBOID();
            }
            GL11.glEnableClientState((int)32884);
            GL11.glEnableClientState((int)32885);
            if (this.useTextCoords) {
                GL11.glEnableClientState((int)32888);
            }
            if (this.useTangents) {
                GL20.glEnableVertexAttribArray((int)this.tangentAttribId);
            }
            ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.vboID);
            this.setupBufferFormat();
            this.bufferData(this.vboID, myBuffer);
            if (this.rebuildIndices) {
                this.bufferElementData(this.vboID2, indices);
                this.rebuildIndices = false;
            }
            GL11.glDisableClientState((int)32884);
            GL11.glDisableClientState((int)32885);
            if (this.useTextCoords) {
                GL11.glDisableClientState((int)32888);
            }
            this.indlength = ind.length;
            vbos.add(this);
        }
        this.lastRebuild = time;
        this.rebuild = false;
    }

    private VBO getVBO(String hash2) {
        for (VBO v : vbos) {
            if (v.hash.equals("") || !v.hash.equals(hash2)) continue;
            return v;
        }
        return null;
    }

    void setupBufferFormat() {
        this.stride = 32;
        if (!this.useTextCoords) {
            this.stride = 24;
        }
        this.offset = 0;
        GL11.glVertexPointer((int)3, (int)5126, (int)this.stride, (long)this.offset);
        this.offset = 12;
        GL11.glNormalPointer((int)5126, (int)this.stride, (long)this.offset);
        if (this.useTextCoords) {
            this.offset = 24;
            GL11.glTexCoordPointer((int)2, (int)5126, (int)this.stride, (long)this.offset);
        }
    }

    public int createVBOID() {
        if (GLContext.getCapabilities().GL_ARB_vertex_buffer_object) {
            IntBuffer buffer = BufferUtils.createIntBuffer((int)1);
            ARBVertexBufferObject.glGenBuffersARB((IntBuffer)buffer);
            return buffer.get(0);
        }
        return 0;
    }

    void bufferData(int id, FloatBuffer buffer) {
        int mytype = 35044;
        if (this.type == 2) {
            mytype = 35048;
        }
        if (this.type == 3) {
            mytype = 35040;
        }
        ARBVertexBufferObject.glBindBufferARB((int)34962, (int)id);
        ARBVertexBufferObject.glBufferDataARB((int)34962, (FloatBuffer)buffer, (int)mytype);
    }

    void bufferElementData(int id, IntBuffer buffer) {
        int mytype = 35044;
        ARBVertexBufferObject.glBindBufferARB((int)34963, (int)id);
        ARBVertexBufferObject.glBufferDataARB((int)34963, (IntBuffer)buffer, (int)mytype);
    }
}

