/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.mesh;

import java.util.ArrayList;
import sumo.v3d.material.Material;
import sumo.v3d.math.Vec2f;
import sumo.v3d.math.Vec3f;
import sumo.v3d.math.Vec3s;
import sumo.v3d.math.Vec4s;
import sumo.v3d.mesh.Mesh;
import sumo.v3d.mesh.RendererIF;
import sumo.v3d.mesh.VBO;

public class RendererVBO
implements RendererIF {
    ArrayList<VBO> vbos = null;

    public void render(float time, Mesh m) {
        this.render(time, m, true);
    }

    public void render(float time, Mesh m, boolean bindMaterials) {
        if (this.vbos == null) {
            this.vbos = new ArrayList();
            for (Material mat : m.materials) {
                VBO v = new VBO();
                if (m.animVertices.size() > 0) {
                    v.type = 2;
                }
                v.rebuildBuffer(m, mat, time);
                this.vbos.add(v);
            }
        }
        if (m.animVertices.size() > 0) {
            for (Material mat : m.materials) {
                for (VBO v : this.vbos) {
                    float t = time - v.lastRebuild;
                    if (!(t > 0.033f) && !(t < -0.033f)) continue;
                    v.rebuildBuffer(m, mat, time);
                }
            }
        }
        if (m.animVertices.size() == 0 && m.vertices != null) {
            m.vertices = new Vec3f[0];
            m.faces = new Vec4s[0];
            m.normals = new Vec3f[0];
            m.textureCoords = new Vec2f[0];
            m.textureFaces = new Vec3s[0];
        }
        if (this.vbos == null) {
            System.out.println("no vbos");
            return;
        }
        boolean cycle = true;
        for (VBO v : this.vbos) {
            v.draw(bindMaterials);
        }
    }
}

