/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.math;

import sumo.keyframing.KeyframedFloat;
import sumo.v3d.math.Matrix4;
import sumo.v3d.math.Quaternion;

public class QuaterionKeyframed {
    public KeyframedFloat x = new KeyframedFloat();
    public KeyframedFloat y = new KeyframedFloat();
    public KeyframedFloat z = new KeyframedFloat();
    public KeyframedFloat w = new KeyframedFloat();
    private Quaternion tempQuat = new Quaternion();
    private Quaternion tempQuatTime = new Quaternion();
    private Matrix4 tempMatrix = new Matrix4();
    static float tempxx = 0.0f;
    static float tempyy = 0.0f;
    static float tempzz = 0.0f;
    static float tempww = 0.0f;
    static float tempx2 = 0.0f;
    static float tempy2 = 0.0f;
    static float tempz2 = 0.0f;
    static float tempxy = 0.0f;
    static float tempxz = 0.0f;
    static float tempyz = 0.0f;
    static float tempwx = 0.0f;
    static float tempwy = 0.0f;
    static float tempwz = 0.0f;
    Quaternion tempquad = new Quaternion();

    public QuaterionKeyframed() {
        this.x.setKeyframingEnabled(true);
        this.x.setDefaultInterpolationMode((short)1);
        this.y.setKeyframingEnabled(true);
        this.y.setDefaultInterpolationMode((short)1);
        this.z.setKeyframingEnabled(true);
        this.z.setDefaultInterpolationMode((short)1);
        this.w.setKeyframingEnabled(true);
        this.w.setDefaultInterpolationMode((short)1);
    }

    public Matrix4 getMatrix(float time) {
        tempxx = this.x.getValue(time);
        tempyy = this.y.getValue(time);
        tempzz = this.z.getValue(time);
        tempww = this.w.getValue(time);
        float percent = this.x.getPercent(time);
        if (percent != 0.0f) {
            this.tempQuatTime.w = tempww;
            this.tempQuatTime.x = tempxx;
            this.tempQuatTime.y = tempyy;
            this.tempQuatTime.z = tempzz;
            this.tempquad.x = this.x.getNextValue();
            this.tempquad.y = this.y.getNextValue();
            this.tempquad.z = this.z.getNextValue();
            this.tempquad.w = this.w.getNextValue();
            this.tempQuat = this.slerp(this.tempQuatTime, this.tempquad, percent);
            return this.tempQuat.getMatrix();
        }
        tempx2 = tempxx * tempxx;
        tempy2 = tempyy * tempyy;
        tempz2 = tempzz * tempzz;
        tempxy = tempxx * tempyy;
        tempxz = tempxx * tempzz;
        tempyz = tempyy * tempzz;
        tempwx = tempww * tempxx;
        tempwy = tempww * tempyy;
        tempwz = tempww * tempzz;
        this.tempMatrix.set(1.0f - 2.0f * (tempy2 + tempz2), 2.0f * (tempxy - tempwz), 2.0f * (tempxz + tempwy), 0.0f, 2.0f * (tempxy + tempwz), 1.0f - 2.0f * (tempx2 + tempz2), 2.0f * (tempyz - tempwx), 0.0f, 2.0f * (tempxz - tempwy), 2.0f * (tempyz + tempwx), 1.0f - 2.0f * (tempx2 + tempy2), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        return this.tempMatrix;
    }

    public Quaternion slerp(Quaternion qa, Quaternion qb, float t) {
        float cosHalfTheta = qa.w * qb.w + qa.x * qb.x + qa.y * qb.y + qa.z * qb.z;
        if (cosHalfTheta < 0.0f) {
            qb.w = -qb.w;
            qb.x = -qb.x;
            qb.y = -qb.y;
            qb.z = -qb.z;
            cosHalfTheta = -cosHalfTheta;
        }
        if ((double)Math.abs(cosHalfTheta) >= 1.0) {
            this.tempQuat.w = qa.w;
            this.tempQuat.x = qa.x;
            this.tempQuat.y = qa.y;
            this.tempQuat.z = qa.z;
            return this.tempQuat;
        }
        float halfTheta = (float)Math.acos(cosHalfTheta);
        float sinHalfTheta = (float)Math.sqrt(1.0 - (double)(cosHalfTheta * cosHalfTheta));
        if ((double)Math.abs(sinHalfTheta) < 0.001) {
            this.tempQuat.w = qa.w * 0.5f + qb.w * 0.5f;
            this.tempQuat.x = qa.x * 0.5f + qb.x * 0.5f;
            this.tempQuat.y = qa.y * 0.5f + qb.y * 0.5f;
            this.tempQuat.z = qa.z * 0.5f + qb.z * 0.5f;
            return this.tempQuat;
        }
        float ratioA = (float)Math.sin((1.0f - t) * halfTheta) / sinHalfTheta;
        float ratioB = (float)Math.sin(t * halfTheta) / sinHalfTheta;
        this.tempQuat.w = qa.w * ratioA + qb.w * ratioB;
        this.tempQuat.x = qa.x * ratioA + qb.x * ratioB;
        this.tempQuat.y = qa.y * ratioA + qb.y * ratioB;
        this.tempQuat.z = qa.z * ratioA + qb.z * ratioB;
        return this.tempQuat;
    }
}

