/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.loader;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import sumo.project.Project;
import sumo.v3d.math.Vec3f;

public class Binarystream {
    FileInputStream fstream = null;
    BufferedInputStream in;
    byte[] arr = new byte[2];

    Binarystream(String path, String filename) {
        this.in = Project.getProject().getBufferedInputStream(path, filename);
    }

    public String readString(int num) {
        try {
            byte[] b = new byte[num];
            this.in.read(b, 0, num);
            this.myReadByte();
            return new String(b);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public float[] readFloatArray(int num) {
        float[] arr = new float[num];
        for (int i = 0; i < num; ++i) {
            arr[i] = this.readFloat();
        }
        return arr;
    }

    public int[] readIntArray(int num) {
        int[] arr = new int[num];
        for (int i = 0; i < num; ++i) {
            arr[i] = this.readInt();
        }
        return arr;
    }

    public short[] readShortArray(int num) {
        short[] arr = new short[num];
        for (int i = 0; i < num; ++i) {
            arr[i] = this.readShort();
        }
        return arr;
    }

    public byte[] readByteArray(int numElements) {
        byte[] arr = new byte[numElements];
        for (int i = 0; i < numElements; ++i) {
            arr[i] = this.myReadByte();
        }
        return arr;
    }

    Vec3f readVec3f() {
        return new Vec3f(this.readFloat(), this.readFloat(), this.readFloat());
    }

    byte readByte() {
        try {
            return this.myReadByte();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public byte myReadByte() {
        byte[] b = new byte[1];
        try {
            this.in.read(b);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        return b[0];
    }

    int readInt() {
        int accum = 0;
        try {
            for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
                accum |= (this.myReadByte() & 0xFF) << shiftBy;
            }
        }
        catch (Exception e) {
            System.out.println("binarystream error...");
            e.printStackTrace();
            System.exit(0);
        }
        return accum;
    }

    public short readShort() {
        try {
            this.in.read(this.arr, 0, 2);
            int start = 0;
            int low = this.arr[start] & 0xFF;
            int high = this.arr[start + 1] & 0xFF;
            return (short)(high << 8 | low);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public float readFloat() {
        int accum = 0;
        try {
            for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
                accum |= (this.myReadByte() & 0xFF) << shiftBy;
            }
        }
        catch (Exception e) {
            System.out.println("binarystream error...");
            System.exit(0);
        }
        return Float.intBitsToFloat(accum);
    }
}

