/*
 * Decompiled with CFR 0.152.
 */
package sumo.util;

import java.io.File;
import java.util.ArrayList;
import sumo.util.FileChangeListener;

public class FileChangeWatcher
extends Thread {
    long lastchange = 0L;
    boolean stayAlive = true;
    String filename = "";
    ArrayList<FileChangeListener> listener = new ArrayList();

    public FileChangeWatcher(String filename) {
        this.filename = filename;
        System.out.println("watching:" + filename);
        this.start();
    }

    public void dispose() {
        this.stayAlive = false;
        System.out.println("filewatcher disposed");
    }

    public void run() {
        File f = new File(this.filename);
        this.lastchange = f.lastModified();
        try {
            while (this.stayAlive) {
                Thread.sleep(500L);
                if (this.lastchange == f.lastModified()) continue;
                System.out.println("file changed: " + this.filename);
                this.lastchange = f.lastModified();
                this.notifyListeners();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void notifyListeners() {
        for (FileChangeListener l : this.listener) {
            l.fileChanged();
        }
    }

    public void addFileChangeListener(FileChangeListener l) {
        this.listener.add(l);
    }
}

