/*
 * Decompiled with CFR 0.152.
 */
package sumo.resource.types;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import sumo.gui.Icons;
import sumo.project.Project;
import sumo.resource.resource;
import sumo.resource.resourceIF;
import sumo.util.DevilImage;
import sumo.util.Log;
import sumo.util.stopwatch;

public class textureFile
extends resource
implements resourceIF {
    public int id = -1;
    public static String typedescr = "texture";
    boolean loaded = false;
    public int width;
    public int height;

    public int getIcon() {
        return Icons.RESOURCE_IMAGE;
    }

    public String getTypeDescr() {
        return typedescr;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public static void enable() {
        GL11.glEnable((int)34037);
    }

    public static void disable() {
        GL11.glBindTexture((int)34037, (int)0);
        GL11.glDisable((int)34037);
    }

    public boolean isValid() {
        return this.id != -1;
    }

    public void bind() {
        if (this.id != -1) {
            GL11.glEnable((int)34037);
            GL11.glBindTexture((int)34037, (int)this.getID());
        }
    }

    public String getInfo() {
        return this.width + "x" + this.height + " glid:" + this.getID();
    }

    public void reload() {
        Project.getProject().getResourceManager().setAllLoaded(false);
        this.loaded = false;
    }

    public void load() {
        stopwatch stop = new stopwatch("loaded texture: " + this.filename + " ");
        Log.log("loading resource texture...: " + this.path + " -- " + this.filename);
        try {
            try {
                this.id = DevilImage.loadTexture(this.path, this.filename, true);
                this.width = DevilImage.width;
                this.height = DevilImage.height;
                System.out.println(this.width + "x" + this.height + "!!!!!!!");
            }
            catch (Exception e) {
                Log.log("loadtexture " + e);
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            Log.error(e);
        }
        this.loaded = true;
        stop.stop();
    }

    public int getID() {
        return this.id;
    }

    public void renderPreview() {
        float h;
        GL11.glClearColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glClear((int)16640);
        GL11.glLoadIdentity();
        float f1 = this.height;
        float f2 = 0.0f;
        float x = 0.0f;
        float y = 0.0f;
        float w = this.width;
        for (h = (float)this.height; w > 1.0f || h > 1.0f; w *= 0.9f, h *= 0.9f) {
        }
        w = 1.0f;
        h = 1.0f;
        GL11.glLoadIdentity();
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2903);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glClear((int)256);
        GL11.glEnable((int)34037);
        GL13.glActiveTexture((int)33984);
        this.bind();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glBegin((int)7);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTexCoord2f((float)0.0f, (float)f1);
        GL11.glVertex2f((float)(x - w / 2.0f), (float)(-1.0f * y + h / 2.0f));
        GL11.glTexCoord2f((float)0.0f, (float)f2);
        GL11.glVertex2f((float)(x - w / 2.0f), (float)(-1.0f * y - h / 2.0f));
        GL11.glTexCoord2f((float)(1.0f * (float)this.width), (float)f2);
        GL11.glVertex2f((float)(x + w / 2.0f), (float)(-1.0f * y - h / 2.0f));
        GL11.glTexCoord2f((float)(1.0f * (float)this.width), (float)f1);
        GL11.glVertex2f((float)(x + w / 2.0f), (float)(-1.0f * y + h / 2.0f));
        GL11.glEnd();
        GL13.glActiveTexture((int)33984);
        GL11.glDisable((int)34037);
    }
}

