/*
 * Decompiled with CFR 0.152.
 */
package sumo.resource.types;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.jar.JarFile;
import sumo.gui.Icons;
import sumo.project.Project;
import sumo.resource.resource;
import sumo.resource.resourceIF;
import sumo.util.Files;
import sumo.util.Log;

public class JARFile
extends resource
implements resourceIF {
    public static String typedescr = "jar";
    boolean loaded = false;
    JarFile jar;

    public String getTypeDescr() {
        return typedescr;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public String getInfo() {
        return this.path + this.filename + "";
    }

    public void reload() {
        Project.getProject().getResourceManager().setAllLoaded(false);
        this.loaded = false;
    }

    public void load() {
        try {
            this.jar = new JarFile(this.getPath() + this.getFilename());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public InputStream getInputStream(String filename) {
        InputStream in = null;
        try {
            in = Files.getJarInputStream(this.jar, filename);
        }
        catch (Exception e) {
            Log.error("JARFile getBufferedInputStream", e);
            e.printStackTrace();
        }
        return in;
    }

    public BufferedInputStream getBufferedInputStream(String filename) {
        BufferedInputStream in = null;
        try {
            InputStream inw = Files.getJarInputStream(this.jar, filename);
            in = new BufferedInputStream(inw);
        }
        catch (Exception e) {
            Log.error("JARFile getBufferedInputStream", e);
            e.printStackTrace();
        }
        return in;
    }

    public JarFile getJAR() {
        return this.jar;
    }

    public int getIcon() {
        return Icons.ICON_QUESTION;
    }

    public void renderPreview() {
    }
}

