/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.superrandom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;
import org.w3c.dom.Element;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyframedResource;
import sumo.plugin.Plugin;
import sumo.plugins.superrandom.RandomParticle;
import sumo.project.Project;
import sumo.resource.types.textureFile;
import sumo.resource.types.v3d;
import sumo.v3d.NodeIF;
import sumo.v3d.Scene;
import sumo.v3d.mesh.Object;
import sumoTween.Tweener;

public class SuperRandom
extends Plugin {
    Scene s;
    public Tweener size;
    public Tweener fov;
    public Tweener space;
    public KeyframedResource scene;
    public Tweener randomize;
    public Tweener num;
    public Tweener cam;
    private float scale = 1.0f;
    private textureFile currenTexture = null;
    ArrayList<RandomParticle> parts = new ArrayList();
    int lastvalue = 0;

    public void init() {
        this.scene.setResource(new v3d());
        this.scene.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                SuperRandom.this.randomize();
            }
        });
    }

    protected void randomize() {
        this.s = ((v3d)this.scene.getResource()).getScene();
        List<NodeIF> meshes = this.s.rootnode.getChilds(1);
        this.parts.clear();
        System.out.println(meshes.size());
        for (NodeIF nodeIF : meshes) {
            int num = (int)((float)Math.random() * this.num.getValue() * 2.0f);
            for (int i = 0; i < num; ++i) {
                Object m = (Object)nodeIF;
                RandomParticle p = new RandomParticle();
                this.parts.add(p);
                p.setObj(m);
                m.pos.set(0.0f, 0.0f, 0.0f);
            }
        }
        Collections.sort(this.parts, new Comparator<RandomParticle>(){

            @Override
            public int compare(RandomParticle o1, RandomParticle o2) {
                return o1.getObj().meshes.get((int)0).materialIDs.get((int)0).x - o2.getObj().meshes.get((int)0).materialIDs.get((int)0).x;
            }
        });
    }

    public void render() {
        if (this.randomize.getIntValue() != this.lastvalue) {
            this.lastvalue = this.randomize.getIntValue();
            this.randomize();
        }
        GL11.glLoadIdentity();
        GL11.glClear((int)256);
        if (this.fov.getValue() > 0.1f) {
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GLU.gluPerspective((float)(this.fov.getValue() * 220.0f), (float)1.7777778f, (float)0.02f, (float)2000.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            int camv = this.cam.getIntValue();
            if (camv == 0) {
                GLU.gluLookAt((float)0.0f, (float)-114.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (camv == 1) {
                GLU.gluLookAt((float)0.0f, (float)-114.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)51.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (camv == 2) {
                GLU.gluLookAt((float)-50.0f, (float)-114.0f, (float)0.0f, (float)31.0f, (float)31.0f, (float)51.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        } else {
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)-114.0f, (float)0.0f);
            GL11.glRotatef((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.scale = this.size.getValue() * 1.3f + 0.02f;
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        if (this.s == null) {
            return;
        }
        this.s.getLight().render(0.0f);
        this.s.getLight().setPos(0.0f, 0.0f, 100.0f);
        GL11.glRotatef((float)((float)Math.sin(Project.getProject().getTime())), (float)0.3f, (float)0.3f, (float)0.3f);
        GL11.glRotatef((float)(Project.getProject().getTime() * 15.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        float t = Project.getProject().getTime() % 10.0f;
        int count = 0;
        for (RandomParticle p : this.parts) {
            GL11.glPushMatrix();
            if ((double)(++count) % 3.0 == 0.0) {
                GL11.glRotatef((float)((float)(-Math.sin(Project.getProject().getTime()))), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            p.render(t, this.space.getValue());
            GL11.glPopMatrix();
        }
    }

    public String getAuthor() {
        return "tom";
    }

    public float getVersion() {
        return 0.0f;
    }

    public String getName() {
        return "cube";
    }

    public void saveXML(Element root) {
    }

    public void loadXML(Element root) {
    }
}

