/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.superrandom;

import org.lwjgl.opengl.GL11;
import sumo.v3d.math.Vec3f;
import sumo.v3d.math.Vec3fkeyframed;
import sumo.v3d.mesh.Mesh;
import sumo.v3d.mesh.Object;

public class RandomParticle {
    private Object obj;
    Vec3f pos = new Vec3f();
    float scale = 1.0f;
    Vec3fkeyframed animpos;
    int size = 5000;
    boolean rotate = false;
    float rotatef = 1.0f;

    RandomParticle() {
        this.pos.x = (float)Math.random() * (float)this.size - (float)(this.size / 2);
        this.pos.z = (float)Math.random() * (float)this.size - (float)(this.size / 2);
        this.scale = (float)Math.random() * 5.0f;
    }

    public Object getObj() {
        return this.obj;
    }

    public void setObj(Object obj) {
        this.obj = obj;
        if (obj.getName().contains("rotate")) {
            this.rotate = true;
        }
        if (Math.random() > 0.5) {
            this.animpos = new Vec3fkeyframed();
            float start = (float)(Math.random() * (double)this.size - (double)(this.size / 2));
            this.animpos.x.addKey(0.0f, Float.valueOf((float)Math.random() * (float)this.size - (float)(this.size / 2)));
            this.animpos.z.addKey(0.0f, Float.valueOf(start));
            this.animpos.z.addKey(10.0f, Float.valueOf(start + (float)(Math.random() * (double)this.size - (double)(this.size / 2))));
        }
        this.rotatef = (float)Math.random() + 0.5f;
    }

    public void render(float time, float space) {
        GL11.glPushMatrix();
        if (this.animpos == null) {
            this.pos.glTranslate();
        } else {
            GL11.glTranslatef((float)(this.animpos.x.getValue(time) * space), (float)(this.animpos.y.getValue(time) * space), (float)(this.animpos.z.getValue(time) * space));
        }
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        if (this.rotate) {
            GL11.glRotatef((float)(time * 100.0f), (float)0.0f, (float)this.rotatef, (float)0.0f);
        }
        GL11.glScalef((float)this.obj.scale.x, (float)this.obj.scale.y, (float)this.obj.scale.z);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        for (Mesh m : this.obj.meshes) {
            m.render(time);
        }
        GL11.glPopMatrix();
    }
}

