/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.evokebeam.data;

import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import sumo.opengl.common;
import sumo.plugins.evokebeam.CompoResults;
import sumo.plugins.evokebeam.data.Overlay;
import sumo.plugins.evokebeam.data.Text;
import sumo.plugins.evokebeam.evokebeam;
import sumo.resource.types.textureFile;

public class Screen {
    private ArrayList<Text> texte = new ArrayList();
    private ArrayList<Overlay> overlays = new ArrayList();
    private textureFile backgroundTexture = null;
    private int duration = 15000;
    public int type = 0;
    private CompoResults results = null;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_SPONSOR = 1;
    public static final int TYPE_COMPORELEASE = 2;
    public static final int TYPE_LINEWAITSCREEN = 3;
    public static final int TYPE_JINGLE_LONG = 4;
    public static final int TYPE_JINGLE_SHORT = 5;
    float fadeouttime = 0.0f;
    public static float fadelength = 1000.0f;
    public boolean finished = false;

    public void setType(int i) {
        this.type = i;
    }

    public int getType() {
        return this.type;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void addText(int x, int y, int maxwidth, int maxheight, String s, int r, int g, int b, boolean bold, int size) {
        Text t = new Text();
        t.size = size;
        t.setMaxHeight(maxheight);
        t.setMaxWidth(maxwidth);
        t.setX(x);
        t.setY(y);
        t.setText(s, r, g, b, bold);
        this.texte.add(t);
    }

    public textureFile getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public void setBackgroundTexture(textureFile backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
    }

    public void fadeOut(float time) {
        this.fadeouttime = time;
    }

    public void render(float time) {
        float fade = 1.0f;
        if (time < 2000.0f) {
            fade = time / 2000.0f;
        }
        if (this.type == 3 && evokebeam.lineAnimScene != null) {
            evokebeam.lineAnimScene.render(time % 9300.0f / 1000.0f);
        }
        if (this.type == 2) {
            fade = time < 2000.0f && time > 1000.0f ? (time - 1000.0f) / 1000.0f : (time > 2000.0f ? 1.0f : 0.0f);
            if (this.fadeouttime != 0.0f) {
                float f = (time - this.fadeouttime) / 1000.0f;
                System.out.println("f: " + f);
                evokebeam.compoAnimScene.render(1.65f + f);
                fade = 0.4f - f;
                if (fade < 0.0f) {
                    fade = 0.0f;
                }
                if (f > 0.7f) {
                    this.finished = true;
                }
            } else if (time < 1500.0f) {
                if (evokebeam.compoAnimScene != null) {
                    evokebeam.compoAnimScene.render(time / 1000.0f);
                }
            } else {
                evokebeam.compoAnimScene.render(1.65f);
            }
        }
        GL11.glLoadIdentity();
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)256);
        GL11.glDisable((int)2929);
        if (time > (float)this.duration - fadelength) {
            fade = ((float)this.duration - time) / fadelength;
        }
        fade = common.smoothStep(fade);
        common.switchTo2dd();
        if (this.backgroundTexture != null) {
            Screen.renderFullscreen(this.backgroundTexture, false, fade);
        }
        for (Overlay o : this.overlays) {
            o.draw(fade);
        }
        for (Text t : this.texte) {
            t.draw(fade);
        }
        if (this.results != null) {
            this.results.draw();
        }
        common.switchTo3d();
    }

    public static void renderFullscreen(textureFile t, boolean flip, float fade) {
        if (t == null) {
            return;
        }
        boolean scale = false;
        float stn = 1.7777778f;
        if ((float)t.width / (float)t.height != stn) {
            scale = true;
        }
        t.enable();
        t.bind();
        int h = evokebeam.res.getY();
        int w = evokebeam.res.getX();
        int x = 0;
        if (scale) {
            int nh = 0;
            int nw = 0;
            nh = h;
            if (t.height < h) {
                nw = (int)((float)h / (float)t.height) * t.width;
            } else {
                nw = w;
                nh = h;
            }
            h = nh;
            w = nw;
            x = (evokebeam.res.getX() - nw) / 2;
        }
        int y1 = h;
        int y2 = 0;
        if (flip) {
            y1 = 0;
            y2 = h;
        }
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)fade);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y1);
        GL11.glTexCoord2f((float)0.0f, (float)(1.0f * (float)t.height));
        GL11.glVertex2f((float)x, (float)y2);
        GL11.glTexCoord2f((float)(1.0f * (float)t.width), (float)(1.0f * (float)t.height));
        GL11.glVertex2f((float)(w + x), (float)y2);
        GL11.glTexCoord2f((float)(1.0f * (float)t.width), (float)0.0f);
        GL11.glVertex2f((float)(w + x), (float)y1);
        GL11.glEnd();
    }

    public CompoResults getResults() {
        return this.results;
    }

    public void setResults(CompoResults results) {
        this.results = results;
    }

    public void addOverlay(Overlay overlay) {
        this.overlays.add(overlay);
    }

    public Text getText(int i) {
        return this.texte.get(i);
    }
}

