/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.evokebeam;

import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.lwjgl.Sys;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.plugins.evokebeam.CompoResults;
import sumo.plugins.evokebeam.ScreenTemplates;
import sumo.plugins.evokebeam.Show;
import sumo.plugins.evokebeam.data.Result;
import sumo.plugins.evokebeam.data.Screen;
import sumo.plugins.evokebeam.helper;
import sumo.project.Project;
import sumo.resource.types.textureFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLParser {
    String lchange = "";
    static String templatesURL = "http://beam.orga.evoke.eu/beamer/templates/";
    static String XMLurl = "http://beam.orga.evoke.eu/beamer/view.php";
    long lastupdate = 0L;
    Show show;

    public XMLParser(Show s) {
        this.show = s;
    }

    public void update() {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            URL url = new URL(XMLurl);
            Document doc = docBuilder.parse(url.openStream());
            doc.getDocumentElement().normalize();
            String lchangeNew = doc.getDocumentElement().getAttribute("lchange");
            if (this.lchange.equals(lchangeNew)) {
                System.out.println("no change...");
                this.lastupdate = Sys.getTime();
                return;
            }
            this.lchange = lchangeNew;
            this.show.clear();
            String currenttype = doc.getDocumentElement().getAttribute("type");
            if (currenttype.equals("compo")) {
                this.readCompo(doc);
            }
            if (currenttype.equals("news")) {
                this.show.setWaitForKey(false);
            }
            if (currenttype.equals("ceremony")) {
                this.show.setWaitForKey(true);
            }
            NodeList listItems = doc.getElementsByTagName("item");
            if (currenttype.equals("news")) {
                this.show.addScreens(this.readNewsItems(listItems));
                this.show.addSponsorScreens(doc.getElementsByTagName("sponsorscreen"));
            }
            if (currenttype.equals("ceremony")) {
                this.show.addScreens(this.readCeremony(listItems));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Project.getProject().getResourceManager().printAllResources();
        System.gc();
        this.lastupdate = Sys.getTime();
        this.show.setCurrentScreen(0);
    }

    private ArrayList<Screen> readCeremony(NodeList listItems) {
        String[] sss = helper.downfile("resultbar2.png");
        textureFile resultbar = (textureFile)Project.getProject().getResourceManager().add(sss[0], sss[1]);
        String[] rc = helper.downfile("resultcircle1.png");
        textureFile tfcircle1 = (textureFile)Project.getProject().getResourceManager().add(rc[0], rc[1]);
        rc = helper.downfile("resultcircle2.png");
        textureFile tfcircle2 = (textureFile)Project.getProject().getResourceManager().add(rc[0], rc[1]);
        rc = helper.downfile("resultcircle3.png");
        textureFile tfcircle3 = (textureFile)Project.getProject().getResourceManager().add(rc[0], rc[1]);
        ArrayList<Screen> screens = new ArrayList<Screen>();
        screens.add(ScreenTemplates.getResultsTitleScreen());
        String tempTitle = "";
        boolean cycle = true;
        for (int i = 0; i < listItems.getLength(); ++i) {
            Element e = (Element)listItems.item(i);
            if (e.getAttribute("type").equals("text")) {
                Element etitle = (Element)e.getElementsByTagName("text").item(0);
                tempTitle = String.valueOf(etitle.getTextContent());
                screens.add(ScreenTemplates.getResultsCompoTitleScreen(tempTitle + ""));
            }
            if (!e.getAttribute("type").equals("result")) continue;
            CompoResults rs = new CompoResults();
            rs.setTitle(tempTitle);
            NodeList entries = e.getElementsByTagName("entry");
            for (int j = 0; j < entries.getLength(); ++j) {
                Element el = (Element)entries.item(j);
                System.out.println(el);
                rs.addResult(new Result(el));
            }
            rs.setBarTexture(resultbar);
            rs.setPlaceBackgroundTextures(tfcircle1, tfcircle2, tfcircle3);
            screens.add(ScreenTemplates.getResultsScreen(tempTitle, rs));
        }
        screens.add(ScreenTemplates.getResultsEndScreen());
        return screens;
    }

    private ArrayList<Screen> readNewsItems(NodeList listItems) {
        ArrayList<Screen> screens = new ArrayList<Screen>();
        for (int i = 0; i < listItems.getLength(); ++i) {
            Element e = (Element)listItems.item(i);
            NodeList texts = e.getElementsByTagName("text");
            String animtype = e.getAttribute("animtype");
            String title = "";
            String text = "";
            for (int j = 0; j < texts.getLength(); ++j) {
                Element et = (Element)texts.item(j);
                if (j == 0) {
                    title = et.getTextContent();
                }
                if (j != 1) continue;
                text = et.getTextContent();
            }
            Screen s = ScreenTemplates.getNewsScreen(title, text, animtype);
            screens.add(s);
        }
        return screens;
    }

    public void readCompo(Document doc) {
        NodeList compos = doc.getElementsByTagName("compo");
        Element compo = (Element)compos.item(0);
        String componame = compo.getAttribute("name");
        String comporeleases = compo.getAttribute("releases");
        this.show.addScreen(ScreenTemplates.getCompoTitleScreen(componame));
        this.show.setWaitForKey(true);
        NodeList releases = compo.getElementsByTagName("release");
        for (int i = 0; i < releases.getLength(); ++i) {
            Element r = (Element)releases.item(i);
            String artist = r.getAttribute("artist");
            String title = r.getAttribute("title");
            String comment = r.getAttribute("comment");
            String pos = r.getAttribute("pos");
            Screen s = ScreenTemplates.getCompoReleaseScreen(componame, artist, title, comment, pos);
            String templ = r.getAttribute("template");
            String[] sss = helper.downfile(templ);
            textureFile tf = (textureFile)Project.getProject().getResourceManager().add(sss[0], sss[1]);
            s.setDuration(999990000);
            this.show.addScreen(s);
        }
        this.show.addScreen(ScreenTemplates.getCompoEndScreen(componame, comporeleases));
        this.show.setWaitForKey(true);
    }
}

