/*
 * Decompiled with CFR 0.152.
 */
package sumo.opengl;

import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import sumo.opengl.FBO;
import sumo.project.Project;

public class FBOManager {
    static ArrayList<FBO> stack = new ArrayList();

    public static FBO getCurrentFBO() {
        if (stack.size() > 0) {
            return stack.get(stack.size() - 1);
        }
        return null;
    }

    public static void bind(FBO fbo) {
        if (FBOManager.getCurrentFBO() != fbo) {
            stack.add(fbo);
            fbo.bind();
        }
    }

    public static boolean isFBOBound() {
        return stack.size() != 0;
    }

    public static void unbind() {
        if (stack.size() > 0) {
            stack.remove(stack.size() - 1);
            if (stack.size() != 0) {
                FBO fbo = stack.get(stack.size() - 1);
                fbo.bind();
            } else {
                FBO.unbindAll();
            }
        }
        FBOManager.glViewport();
    }

    public static void glViewport() {
        if (FBOManager.isFBOBound()) {
            GL11.glViewport((int)0, (int)0, (int)FBOManager.getCurrentFBO().getWidth(), (int)FBOManager.getCurrentFBO().getHeight());
        } else {
            GL11.glViewport((int)0, (int)0, (int)Project.getProject().getOpenGLSsettings().getWidth(), (int)Project.getProject().getOpenGLSsettings().getHeight());
        }
    }
}

