/*
 * Decompiled with CFR 0.152.
 */
package sumo.input.midi;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import sumo.gui.Icons;
import sumo.gui.Settings;
import sumo.input.midi.MidiBindingIF;
import sumo.input.midi.MidiController;
import sumo.input.midi.MidiFloatBinding;
import sumo.input.midi.MidiListener;
import sumo.keyframing.KeyframedFloat;
import sumo.math.vec2i;

public class MidiMapGUI
extends JPanel {
    boolean blocked = false;
    int boxSize;
    int gridWidth = 12;
    int gridHeight = 12;
    vec2i active = new vec2i();
    MidiController midi;

    public MidiMapGUI(MidiController midi) {
        this.midi = midi;
        midi.bindings = midi.bindings;
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                MidiMapGUI.this.active.set(e.getX() / MidiMapGUI.this.boxSize, e.getY() / MidiMapGUI.this.boxSize);
                MidiMapGUI.this.repaint();
            }
        });
        midi.addMidiListener(new MidiListener(){

            public void signalReceived(int which, int value) {
                if (!MidiMapGUI.this.blocked) {
                    MidiMapGUI.this.blocked = true;
                    MidiMapGUI.this.setBindingToActivePos(which);
                    MidiMapGUI.this.repaint();
                    MidiMapGUI.this.blocked = false;
                }
            }
        });
    }

    protected void setBindingToActivePos(int which) {
        boolean found = false;
        for (MidiBindingIF binding : this.midi.bindings) {
            if (binding.getKey() != which) continue;
            binding.setMapPosition(new vec2i(this.active.getX(), this.active.getY()));
            found = true;
        }
        if (!found) {
            MidiFloatBinding mfb = new MidiFloatBinding(which, new KeyframedFloat());
            mfb.setMapPosition(new vec2i(this.active.getX(), this.active.getY()));
            this.midi.bindings.add(mfb);
        }
    }

    public void paint(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.boxSize = this.getWidth() / this.gridWidth;
        for (int x = 0; x < this.gridWidth; ++x) {
            for (int y = 0; y < this.gridHeight; ++y) {
                MidiBindingIF bi = this.getBindingAtPos(new vec2i(x, y));
                g.setColor(Settings.lineBackground);
                g.drawRect(x * this.boxSize, y * this.boxSize, this.boxSize, this.boxSize);
                if (this.active.getX() == x && this.active.getY() == y) {
                    g.setColor(Settings.mainColor1);
                    g.fillRect(x * this.boxSize + 1, y * this.boxSize + 1, this.boxSize - 1, this.boxSize - 1);
                }
                if (bi == null) continue;
                g.setColor(Settings.mainColor1);
                g.drawRect(x * this.boxSize + 1, y * this.boxSize + 1, this.boxSize - 2, this.boxSize - 2);
                g.setFont(Settings.smallfont);
                g.setColor(Color.black);
                if (bi instanceof MidiFloatBinding) {
                    Icons.drawIcon(g, Icons.ICON_MIDI_KNOB, x * this.boxSize + (this.boxSize - 16) / 2, y * this.boxSize + (this.boxSize - 16) / 2);
                } else {
                    Icons.drawIcon(g, Icons.ICON_MIDI_KNOB, x * this.boxSize + (this.boxSize - 16) / 2, y * this.boxSize + (this.boxSize - 16) / 2);
                }
                MidiFloatBinding bfi = (MidiFloatBinding)bi;
            }
        }
        System.out.println(this.midi.bindings.size() + " midi midi.bindings...");
    }

    private MidiBindingIF getBindingAtPos(vec2i pos) {
        for (MidiBindingIF binding : this.midi.bindings) {
            if (binding.getMapPosition().getX() != pos.getX() || binding.getMapPosition().getY() != pos.getY()) continue;
            return binding;
        }
        return null;
    }
}

