/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.timing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import sumo.app.guitest;
import sumo.gui.ScenePanel;
import sumo.gui.Settings;
import sumo.gui.debug.guiDebugData;
import sumo.gui.debug.guiStopWatch;
import sumo.project.Project;

public class TimingScrollPanel
extends JPanel {
    private ScenePanel scenePanel;
    private float value = 0.0f;
    private float startValue = 0.0f;
    private int mouseStartX = 0;
    private float oldvalue = 0.0f;
    private boolean mouseDragging = false;
    private boolean mouseOver = false;
    private float barWidth = 0.0f;
    public float scrollOffsetTime = 0.0f;
    guiStopWatch watch = null;

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
    }

    public TimingScrollPanel(ScenePanel sp) {
        this.scenePanel = sp;
        this.setLayout(null);
        this.setBounds(new Rectangle(103, 16));
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                TimingScrollPanel.this.mouseOver = true;
                TimingScrollPanel.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                TimingScrollPanel.this.mouseOver = false;
                TimingScrollPanel.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                TimingScrollPanel.this.mouseOver = false;
                TimingScrollPanel.this.mouseDragging = false;
                TimingScrollPanel.this.oldvalue = 0.0f;
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                TimingScrollPanel.this.mouseDragging = true;
                if (TimingScrollPanel.this.oldvalue == 0.0f) {
                    TimingScrollPanel.this.oldvalue = TimingScrollPanel.this.startValue;
                }
                TimingScrollPanel.this.startValue = TimingScrollPanel.this.oldvalue - ((float)TimingScrollPanel.this.mouseStartX - (float)e.getX()) / (float)TimingScrollPanel.this.getWidth();
                guitest.setStatus(String.valueOf(TimingScrollPanel.this.value) + "");
                TimingScrollPanel.this.scrollOffsetTime = TimingScrollPanel.this.startValue * (float)Project.getProject().getLength();
                TimingScrollPanel.this.scenePanel.repaintTimings(true);
                TimingScrollPanel.this.mouseOver = true;
                TimingScrollPanel.this.repaint();
            }

            public void mouseMoved(MouseEvent e) {
                TimingScrollPanel.this.mouseStartX = e.getX();
            }
        });
    }

    public void paint(Graphics g) {
        if (guiDebugData.debug) {
            this.watch = new guiStopWatch(guiDebugData.STOP_SCROLLPANEL);
        }
        this.value = this.barWidth = (float)this.scenePanel.getTimingWidth() / (float)this.scenePanel.getTimeInPixel(Project.getProject().getLength());
        g.setColor(Settings.windowBackground);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D gd = (Graphics2D)g;
        gd.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gd.setColor(Settings.pluginTitleBackground);
        gd.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 7, 7);
        int valuePixel = (int)((float)(this.getWidth() - 10) * this.value);
        int valueStartPixel = 2;
        valueStartPixel = 2 + (int)((float)(this.getWidth() - 5) * this.startValue);
        gd.setColor(Settings.mainColor1);
        gd.fillRoundRect(valueStartPixel, 2, valuePixel, this.getHeight() - 5, 5, 5);
        if (this.mouseOver) {
            gd.setColor(Settings.lineBackground);
        }
        gd.setColor(Settings.pluginTitleBackground);
        gd.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 2, 7, 7);
        if (Project.getProject().debugGUI) {
            gd.setColor(Color.blue);
            gd.drawString(this.getClass().getName(), 10, 12);
        }
        if (guiDebugData.debug) {
            this.watch.stop();
        }
    }

    public void centerCursor() {
        this.startValue = (Project.getProject().getTime() - this.scenePanel.getTimeFromPixel(this.scenePanel.getTimingWidth()).floatValue() / 2.0f) / (float)Project.getProject().getLength();
        this.scrollOffsetTime = this.startValue * (float)Project.getProject().getLength();
        this.repaint();
        this.scenePanel.repaintTimings();
        System.out.println("centercursor");
    }
}

