/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.lines;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import sumo.app.main;
import sumo.gui.AbstractLine;
import sumo.gui.Button;
import sumo.gui.Icons;
import sumo.gui.PluginPanel;
import sumo.gui.Settings;
import sumo.gui.debug.guiDebugData;
import sumo.gui.debug.guiStopWatch;
import sumo.gui.detail.PluginDetail;
import sumo.gui.lineTypeElements.guiLineTypeIF;
import sumo.gui.lines.LineIF;
import sumo.gui.timing.KeyFramePanel;
import sumo.gui.timing.KeyFramePanelIF;
import sumo.project.Project;
import sumo.util.Log;
import sumoTween.events.TweenEvent;

public class BasicLine
extends JPanel
implements LineIF {
    public static int POS_KEYFRAMEPANEL = 280;
    public static int POS_VALUECONTROLER = 170;
    private Button minimize;
    private Button visible;
    private Button buttonFrameBuffer;
    private Button btIsKeyFramed;
    private Button resize;
    private Button btKeyNext;
    private Button btKeyPrevious;
    private boolean marked = false;
    private boolean strikeThrough = false;
    AbstractLine abstractLine;
    KeyFramePanelIF keyFramePanel;
    guiLineTypeIF valueController;
    Color bg = Settings.lineBackground;
    guiStopWatch watch = null;
    private int lineHeight = 17;

    public KeyFramePanelIF getKeyFramePanel() {
        return this.keyFramePanel;
    }

    public BasicLine(AbstractLine a) {
        this.abstractLine = a;
        if (a.getType() == 1) {
            this.visible = new Button(Icons.ICON_BOX, "visible");
            this.visible.setBounds(22, 0, 16, 16);
            this.add(this.visible);
            this.buttonFrameBuffer = new Button(Icons.ICON_FRAMEBUFFER_NONE, "renderbuffer");
            this.buttonFrameBuffer.setBounds(6, 0, 16, 16);
            this.add(this.buttonFrameBuffer);
            this.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    Project.getProject().setDetailPanel(new PluginDetail(BasicLine.this.abstractLine));
                }
            });
        }
        if (this.keyFramePanel == null) {
            this.keyFramePanel = new KeyFramePanel(a.pluginPanel.getScenePanel());
        }
        this.add((JPanel)((Object)this.keyFramePanel));
        this.setLayout(null);
        this.minimize = new Button();
        this.minimize.setIcon(Icons.ICON_FOLDER_OPEN);
        this.minimize.setBounds(34, 0, 16, 16);
        this.add(this.minimize);
        if (this.visible != null) {
            this.visible.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    if (BasicLine.this.abstractLine.plugin == null) {
                        Log.logError("basicline plugin null!!");
                    }
                    BasicLine.this.abstractLine.plugin.setVisible(!BasicLine.this.abstractLine.plugin.isVisible());
                    if (BasicLine.this.abstractLine.plugin.isVisible()) {
                        BasicLine.this.visible.setIcon(Icons.ICON_BOX);
                    } else {
                        BasicLine.this.visible.setIcon(Icons.ICON_BOX_X);
                    }
                    BasicLine.this.visible.repaint();
                    BasicLine.this.repaint();
                }

                public void mouseReleased(MouseEvent e) {
                }
            });
        }
        if (this.buttonFrameBuffer != null) {
            this.buttonFrameBuffer.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    if (!PluginPanel.renderingPlugins) {
                        if (BasicLine.this.abstractLine.plugin == null) {
                            Log.logError("basicline plugin null!!");
                        }
                        int f = BasicLine.this.abstractLine.plugin.getFrameBuffer();
                        if (e.getButton() == 1) {
                            ++f;
                        }
                        if (e.getButton() == 3) {
                            --f;
                        }
                        if (f < -1) {
                            f = Project.getProject().getNumFrameBuffers() - 1;
                        }
                        if (f > Project.getProject().getNumFrameBuffers() - 1) {
                            f = -1;
                        }
                        BasicLine.this.buttonFrameBuffer.setIcon(Icons.ICON_FRAMEBUFFER_NONE + f + 1);
                        BasicLine.this.abstractLine.plugin.setFrameBuffer(f);
                        BasicLine.this.abstractLine.pluginPanel.repaint();
                        System.out.println("framebuffer:" + f);
                        BasicLine.this.repaint();
                    }
                }

                public void mouseReleased(MouseEvent e) {
                }
            });
        }
        this.btKeyNext = new Button(Icons.ICON_KEY_NEXT, "next");
        this.btKeyPrevious = new Button(Icons.ICON_KEY_PREVIOUS, "previous");
    }

    public void paint(Graphics g) {
        this.updateFrameBufferButton();
        if (this.valueController != null && this.valueController.getKeyframed() != null) {
            boolean bl = this.strikeThrough = !this.valueController.getKeyframed().isEnabled();
        }
        if (guiDebugData.debug) {
            this.watch = new guiStopWatch(1);
        }
        if (this.valueController != null) {
            this.valueController.getComponent().setBounds(POS_VALUECONTROLER, 1, this.valueController.getComponent().getWidth(), this.valueController.getComponent().getHeight());
        }
        this.keyFramePanel.setBounds(POS_KEYFRAMEPANEL, 0, this.getWidth() - POS_KEYFRAMEPANEL, this.getHeight());
        if (this.abstractLine.getType() == 0) {
            g.setFont(Settings.font);
            this.bg = Settings.lineBackground;
        }
        if (this.abstractLine.getType() == 1) {
            g.setFont(Settings.bigfont);
            this.bg = Settings.lineTitleBackground;
        }
        this.keyFramePanel.setBg(this.bg);
        if (!this.abstractLine.hasChilds()) {
            this.remove(this.minimize);
        } else {
            this.minimize.setBgColor(this.bg);
            this.minimize.setPosition(this.getLevelOffsetX(), 0);
            this.add(this.minimize);
        }
        if (this.visible != null) {
            this.visible.setBgColor(this.bg);
            this.buttonFrameBuffer.setBgColor(this.bg);
        }
        g.setColor(this.bg);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.abstractLine.getType() == 2) {
            g.setFont(Settings.bigfont);
            g.setColor(Settings.lineTitleBackground);
            g.fillRect(40, 0, this.getWidth(), this.getHeight());
            this.keyFramePanel.setBg(Settings.lineTitleBackground);
            this.minimize.setBgColor(Settings.lineTitleBackground);
        }
        if (this.abstractLine.plugin.getFrameBuffer() != -1) {
            if (this.buttonFrameBuffer != null) {
                this.buttonFrameBuffer.setBgColor(Settings.sceneColors[this.abstractLine.plugin.getFrameBuffer()]);
                this.buttonFrameBuffer.repaint();
            }
            g.setColor(Settings.sceneColors[this.abstractLine.plugin.getFrameBuffer()]);
            g.fillRect(0, 0, 22, this.getHeight());
        }
        this.paintComponents(g);
        g.setColor(Color.WHITE);
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        g.setColor(Settings.lineTitleColor);
        if (this.btIsKeyFramed != null) {
            this.btIsKeyFramed.setBounds(this.getLevelOffsetX(), 0, 16, 16);
        }
        if (this.resize != null) {
            this.resize.setBounds(this.getLevelOffsetX() - 16, 0, 16, 16);
        }
        if (this.marked) {
            g.setColor(Settings.mainColor1);
            g.fillRoundRect(this.getLevelOffsetX() - 4 + this.minimize.getWidth() + 3, 1, 100, 14, 4, 4);
            g.setColor(Color.white);
        }
        g.drawString(this.abstractLine.getTitle(), this.getLevelOffsetX() + this.minimize.getWidth() + 3, 13);
        if (this.strikeThrough) {
            g.drawLine(this.getLevelOffsetX() + this.minimize.getWidth() + 3, this.getHeight() - 8, this.getLevelOffsetX() + this.minimize.getWidth() + 60, this.getHeight() - 8);
        }
        if (guiDebugData.debug) {
            this.watch.stop();
        }
    }

    private int getLevelOffsetX() {
        return this.abstractLine.getLevel() * this.minimize.getWidth() + 38;
    }

    public JPanel getComponent() {
        return this;
    }

    public Button getButtonMinimize() {
        return this.minimize;
    }

    public Button getButtonVisible() {
        return this.visible;
    }

    public void setValueControler(guiLineTypeIF c) {
        this.valueController = c;
        if (c != null) {
            if (this.valueController.isKeyframeAble()) {
                this.btIsKeyFramed = new Button(Icons.ICON_BOX, "keyframed?");
                this.btIsKeyFramed.setBounds(this.getLevelOffsetX() + 16, 0, 16, 16);
                this.resize = new Button(Icons.ICON_GRAPH, "graph?");
                this.resize.setBounds(this.getLevelOffsetX(), 0, 16, 16);
                this.updateButtonIsKeyframed();
                if (c.getKeyframed() != null) {
                    c.getKeyframed().addTweenEventListener(new TweenEvent(){

                        public void keysChanged() {
                            BasicLine.this.strikeThrough = !BasicLine.this.valueController.getKeyframed().isEnabled();
                            BasicLine.this.repaint();
                            BasicLine.this.updateButtonIsKeyframed();
                        }

                        public void finished() {
                        }
                    });
                }
                this.resize.addMouseListener(new MouseListener(){

                    public void mouseClicked(MouseEvent arg0) {
                    }

                    public void mouseEntered(MouseEvent arg0) {
                    }

                    public void mouseExited(MouseEvent arg0) {
                    }

                    public void mouseReleased(MouseEvent arg0) {
                    }

                    public void mousePressed(MouseEvent arg0) {
                        BasicLine.this.resize();
                        main.gui.updateResize();
                    }
                });
                this.btIsKeyFramed.addMouseListener(new MouseListener(){

                    public void mouseClicked(MouseEvent arg0) {
                    }

                    public void mouseEntered(MouseEvent arg0) {
                    }

                    public void mouseExited(MouseEvent arg0) {
                    }

                    public void mouseReleased(MouseEvent arg0) {
                    }

                    public void mousePressed(MouseEvent arg0) {
                        BasicLine.this.valueController.setIsKeyFramed(!BasicLine.this.valueController.isKeyFramed());
                        BasicLine.this.updateButtonIsKeyframed();
                    }
                });
                this.add(this.btIsKeyFramed);
                this.add(this.resize);
            }
            this.add(c.getComponent());
        }
    }

    protected void updateButtonIsKeyframed() {
        if (this.valueController.isKeyFramed()) {
            this.btIsKeyFramed.setIcon(Icons.ICON_KEYFRAMED);
        } else {
            this.btIsKeyFramed.setIcon(Icons.ICON_KEYFRAMED_NOT);
        }
        this.btIsKeyFramed.repaint();
    }

    public guiLineTypeIF getValueControler() {
        return this.valueController;
    }

    public void repaintValueController() {
        if (this.valueController != null) {
            this.valueController.getComponent().repaint();
        }
    }

    public void setMarked(boolean b) {
        this.marked = b;
        this.repaint();
    }

    public KeyFramePanelIF setKeyFramePanel(KeyFramePanelIF panel) {
        this.remove((JPanel)((Object)this.keyFramePanel));
        this.keyFramePanel = panel;
        this.add((JPanel)((Object)this.keyFramePanel));
        return panel;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(int i) {
        this.lineHeight = i;
    }

    public void resize() {
        if (this.getLineHeight() == 100) {
            this.setLineHeight(17);
        } else if (this.getLineHeight() == 50) {
            this.setLineHeight(100);
        } else if (this.getLineHeight() == 17) {
            this.setLineHeight(50);
        }
    }

    public void refresh() {
        this.repaint();
    }

    void updateFrameBufferButton() {
        if (this.abstractLine != null && this.abstractLine.plugin != null && this.buttonFrameBuffer != null) {
            this.buttonFrameBuffer.setIcon(Icons.ICON_FRAMEBUFFER_NONE + this.abstractLine.plugin.getFrameBuffer() + 1);
        }
    }
}

