/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.detailMenu;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import sumo.app.main;
import sumo.gui.Icons;
import sumo.gui.detail.DetailEmpty;
import sumo.gui.detail.DetailIF;
import sumo.gui.detail.Elements.DetailButton;
import sumo.gui.dialogs.IntDialog;
import sumo.gui.dialogs.StringDialog;
import sumo.project.Project;
import sumo.resource.resourceIF;
import sumo.resource.types.FMODFile;
import sumo.timing.timerFMOD;
import sumo.timing.timerGUI;

public class ProjectDetail
extends DetailEmpty
implements DetailIF {
    DetailButton prjName;
    DetailButton prjLength;
    DetailButton prjTimer;

    public void dispose() {
    }

    private String getProjectButtonName() {
        return "name: " + Project.getProject().getProjectName();
    }

    public ProjectDetail() {
        this.setTitle(this, "settings project", true);
        this.prjName = new DetailButton(Icons.ICON_QUESTION, this.getProjectButtonName());
        this.prjName.setBounds(10, 60, 290, 17);
        this.add(this.prjName);
        this.prjLength = new DetailButton(Icons.ICON_QUESTION, this.getProjectLengthString());
        this.prjLength.setBounds(10, 90, 290, 17);
        this.add(this.prjLength);
        this.prjTimer = new DetailButton(Icons.ICON_QUESTION, this.getProjectTimerString());
        this.prjTimer.setBounds(10, 120, 290, 17);
        this.add(this.prjTimer);
        this.prjTimer.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (Project.getProject().getTimer() instanceof timerGUI) {
                    ArrayList<resourceIF> mp3s = Project.getProject().getResourceManager().getResources(FMODFile.class);
                    if (mp3s.size() > 0) {
                        timerFMOD timer = new timerFMOD();
                        timer.setMP3((FMODFile)mp3s.get(0));
                        Project.getProject().setTimer(timer);
                    }
                } else {
                    Project.getProject().setTimer(new timerGUI());
                }
                ProjectDetail.this.prjTimer.setTitle(ProjectDetail.this.getProjectTimerString());
            }
        });
        this.prjLength.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                IntDialog id = new IntDialog(main.gui, "enter length in seconds", Project.getProject().getLength());
                if (id.getValue() != -1) {
                    Project.getProject().setLength(id.getValue());
                }
                ProjectDetail.this.prjLength.setTitle(ProjectDetail.this.getProjectLengthString());
            }
        });
        this.prjName.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                StringDialog id = new StringDialog(main.gui, "enter name", Project.getProject().getProjectName());
                if (id.getValue() != null) {
                    Project.getProject().setProjectName(id.getValue());
                }
                ProjectDetail.this.prjName.setTitle(ProjectDetail.this.getProjectButtonName());
            }
        });
    }

    private String getProjectTimerString() {
        return "timing: " + Project.getProject().getTimer().getTitle();
    }

    private String getProjectLengthString() {
        return "length: " + Project.getProject().getLength() + "s";
    }
}

