/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.detail.keyframeable;

import javax.swing.JPanel;
import sumo.app.guitest;
import sumo.gui.AbstractLine;
import sumo.gui.Icons;
import sumo.gui.Settings;
import sumo.gui.detail.DetailButtonPressedListener;
import sumo.gui.detail.DetailEmpty;
import sumo.gui.detail.DetailIF;
import sumo.gui.detail.Elements.Area;
import sumo.gui.detail.Elements.DetailButton;
import sumo.gui.detail.Elements.SpectrumPanel;
import sumo.gui.lineTypeElements.ValueChangedListener;
import sumo.gui.lineTypeElements.ValueEvent;
import sumo.gui.lineTypeElements.guiFloat;
import sumo.input.midi.MidiBindingIF;
import sumo.project.Project;
import sumo.timing.timerFMOD;
import sumoTween.Tweener;

public class FloatDetail
extends DetailEmpty
implements DetailIF {
    public static SpectrumPanel spectrumPanel;
    int midikey = -1;
    Tweener tweener = null;
    DetailButton midi;
    DetailButton clear;
    DetailButton debug;
    DetailButton FFT;
    DetailButton FFTMode;
    DetailButton enabledisable;
    DetailButton FFTHitMode;
    AbstractLine abstractLine;
    final FloatDetail me = this;
    Tweener fftMinus = new Tweener();
    Tweener fftMulti = new Tweener();

    public void dispose() {
        if (!(Project.getProject().getDetailPanel() instanceof FloatDetail)) {
            timerFMOD.repaintSpectrum = false;
        }
    }

    void updateMidiButton() {
        String s = "bind midi ";
        this.midi.setIcon(Icons.ICON_BOX);
        if (this.midikey != -1) {
            s = s + "(" + this.midikey + ")";
            this.midi.setIcon(Icons.ICON_BOX_CHECK);
        }
        this.midi.setTitle(s);
    }

    public FloatDetail(Tweener kf, AbstractLine abstractLine) {
        MidiBindingIF binding;
        timerFMOD.repaintSpectrum = true;
        this.tweener = kf;
        this.setSize(270, 300);
        this.setLayout(null);
        if (Project.getProject().getMidiController() != null && (binding = Project.getProject().getMidiController().getBinding(this.tweener)) != null) {
            this.midikey = binding.getKey();
        }
        if (kf != null) {
            this.setTitle(this, "" + kf.getName());
        }
        this.abstractLine = abstractLine;
        this.midi = new DetailButton(Icons.ICON_BOX, "x ");
        this.clear = new DetailButton(Icons.ICON_BOX_X, "clear");
        this.debug = new DetailButton(Icons.ICON_BOX, "debug");
        this.enabledisable = new DetailButton(Icons.RESOURCE_MUSIC, "enabledisable");
        Area area = new Area("", this, Area.LAYOUT_ONE);
        area.addLine(this.midi);
        area.addLine(this.clear);
        area.addLine(this.debug);
        if (abstractLine != null && abstractLine.drawableLine.getValueControler().getEnableDisableSwitch()) {
            System.out.println("enabledisable");
            area.addLine(this.enabledisable);
            this.updateEnabledisable();
        }
        this.addArea(area);
        int posy = 180;
        this.FFT = new DetailButton(Icons.ICON_GRAPH, "fft:");
        this.FFT.setBounds(10, posy, 120, 20);
        this.add(this.FFT);
        this.FFTMode = new DetailButton(Icons.ICON_NONE, "mode:");
        this.FFTMode.setBounds(140, posy, 120, 20);
        this.add(this.FFTMode);
        JPanel specarea = new JPanel();
        this.createSpectrumArea(posy += 30, specarea);
        this.add(specarea);
        this.updateFFTModeButton();
        this.setBounds(10, 10, 300, 600);
        this.FFT.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                FloatDetail.this.tweener.useFFT = !FloatDetail.this.tweener.useFFT;
                FloatDetail.this.updateFFTButton();
            }
        });
        this.FFTMode.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                FloatDetail.this.tweener.FFTMode = FloatDetail.this.tweener.FFTMode == 0 ? 1 : 0;
                FloatDetail.this.updateFFTModeButton();
            }
        });
        this.debug.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                FloatDetail.this.tweener.printKeys();
            }
        });
        this.clear.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                FloatDetail.this.tweener.clear(0.0f);
            }
        });
        this.enabledisable.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                FloatDetail.this.tweener.setEnabled(!FloatDetail.this.tweener.isEnabled());
                guitest.scenePanel.repaintTimings();
                FloatDetail.this.updateEnabledisable();
            }
        });
    }

    private void updateFFTModeButton() {
        String s = "max";
        if (this.tweener.FFTMode == 0) {
            s = "average";
        }
        this.FFTMode.setTitle("mode: " + s);
        this.FFTMode.repaint();
    }

    private void updateFFTButton() {
        this.FFT.setTitle("fft: " + this.tweener.useFFT);
        this.FFT.repaint();
    }

    private void updateEnabledisable() {
        this.enabledisable.setTitle("enabled: " + this.tweener.isEnabled());
        this.enabledisable.repaint();
        this.abstractLine.drawableLine.refresh();
    }

    private void createSpectrumArea(int posy, JPanel area) {
        area.setLayout(null);
        this.updateFFTButton();
        this.updateMidiButton();
        int py = 10;
        spectrumPanel = new SpectrumPanel(this.tweener);
        spectrumPanel.setBounds(10, py, 255, 100);
        spectrumPanel.setTop(1.0f);
        area.add(spectrumPanel);
        py += FloatDetail.spectrumPanel.getBounds().height;
        this.fftMinus.setKeyframed(false);
        guiFloat spectrumtop = new guiFloat(this.fftMinus);
        spectrumtop.setFnColor(Settings.mainColor1);
        spectrumtop.setBgColor(Settings.windowBackground);
        spectrumtop.drawBottomBorder = false;
        spectrumtop.setBounds(10, py + 10, 200, 20);
        spectrumtop.addValueChangedListener(new ValueChangedListener(){

            public void valueChanged(ValueEvent e) {
                spectrumPanel.setTop(1.0f - e.getValue());
                FloatDetail.this.tweener.FFTMinus = e.getValue();
            }
        });
        area.add(spectrumtop);
        py += 20;
        this.fftMulti.setKeyframed(false);
        guiFloat spectrumHeight = new guiFloat(this.fftMulti);
        spectrumHeight.setFnColor(Settings.mainColor1);
        spectrumHeight.setBgColor(Settings.windowBackground);
        spectrumHeight.drawBottomBorder = false;
        spectrumHeight.setBounds(10, py + 10, 200, 20);
        spectrumHeight.addValueChangedListener(new ValueChangedListener(){

            public void valueChanged(ValueEvent e) {
                spectrumPanel.setYHeight(e.getValue());
                FloatDetail.this.tweener.FFTMulti = e.getValue();
            }
        });
        area.add(spectrumHeight);
        py += 20;
        this.fftMinus.set(this.tweener.FFTMinus);
        this.fftMulti.set(this.tweener.FFTMulti);
        spectrumPanel.setYHeight(this.tweener.FFTMulti);
        spectrumPanel.setTop(1.0f - this.tweener.FFTMinus);
        spectrumPanel.setStartX(this.tweener.FFTSpectrumStart);
        spectrumPanel.setEndX(this.tweener.FFTSpectrumEnd);
        this.FFTHitMode = new DetailButton(Icons.ICON_NONE, "hitmode:");
        this.FFTHitMode.setBounds(10, py + 10, 110, 20);
        this.FFTHitMode.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                ++FloatDetail.this.tweener.FFTHitMode;
                if (FloatDetail.this.tweener.FFTHitMode == 3) {
                    FloatDetail.this.tweener.FFTHitMode = 0;
                }
                FloatDetail.this.updateFFTHitModeButton();
            }
        });
        Tweener fftHitValueTweener = new Tweener();
        fftHitValueTweener.setKeyframed(false);
        guiFloat FFTHitValue = new guiFloat(fftHitValueTweener);
        FFTHitValue.setFnColor(Settings.mainColor1);
        FFTHitValue.setBgColor(Settings.windowBackground);
        FFTHitValue.drawBottomBorder = false;
        FFTHitValue.setBounds(130, py + 10, 120, 20);
        FFTHitValue.addValueChangedListener(new ValueChangedListener(){

            public void valueChanged(ValueEvent e) {
                FloatDetail.this.tweener.FFTHitValue = e.getValue();
            }
        });
        area.add(FFTHitValue);
        FFTHitValue.setValue(this.tweener.FFTHitValue);
        this.updateFFTHitModeButton();
        area.add(this.FFTHitMode);
        area.setBounds(10, posy, 270, (py += 30) + 20);
    }

    void updateFFTHitModeButton() {
        String s = "none";
        if (this.tweener.FFTHitMode == 1) {
            s = "cycle";
        }
        if (this.tweener.FFTHitMode == 2) {
            s = "hit&fall";
        }
        this.FFTHitMode.setTitle("hitmode: " + s);
    }
}

