/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.detail;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import sumo.gui.Button;
import sumo.gui.Icons;
import sumo.gui.Settings;
import sumo.gui.detail.Elements.DetailButton;
import sumo.gui.detail.ShaderDetail;
import sumo.shader.PartFragment;
import sumo.shader.ShaderPartProgram;

public class ShaderDetailPart
extends JComponent {
    private static final long serialVersionUID = -314808509751336532L;
    ShaderPartProgram shaderPart;
    ShaderDetail detail;
    DetailButton com;
    Button bvisible;
    int width = 280;
    Color bgcolor = Settings.lineBackgroundOver;

    public ShaderDetailPart(ShaderPartProgram part, ShaderDetail det) {
        this.detail = det;
        this.shaderPart = part;
        Button bUP = new Button(Icons.ICON_LAYER_UP, "up");
        bUP.setPosition(5, 5);
        bUP.setBgColor(this.bgcolor);
        this.add(bUP);
        Button bDown = new Button(Icons.ICON_LAYER_DOWN, "down");
        bDown.setPosition(23, 5);
        bDown.setBgColor(this.bgcolor);
        this.add(bDown);
        this.bvisible = new Button(Icons.ICON_BOX_CHECK, "visible");
        this.bvisible.setPosition(this.width - 115, 5);
        this.bvisible.setBgColor(this.bgcolor);
        this.add(this.bvisible);
        Button bDelete = new Button(Icons.ICON_BOX_X, "delete");
        bDelete.setPosition(this.width - 20, 5);
        bDelete.setBgColor(this.bgcolor);
        this.add(bDelete);
        if (part.getFragmentPart().blendingAllowed) {
            this.com = new DetailButton(-1, "");
            this.com.setBounds(this.width - 90, 5, 60, 17);
            this.add(this.com);
        }
        int maxy = 23;
        int c = 0;
        System.out.println("new shader detail part!!!" + this.shaderPart.getTextureNames().size());
        for (String s : this.shaderPart.getTextureNames()) {
            DetailButton b = new DetailButton(-1, s.substring(1) + ": " + String.valueOf(this.shaderPart.getTextureNums()[++c - 1] + 1));
            b.setBounds(40, 5 + c * 19, 140, 18);
            b.myData = c - 1;
            this.add(b);
            maxy += 21;
            b.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    int n = ((DetailButton)e.getComponent()).myData;
                    int[] nArray = ShaderDetailPart.this.shaderPart.getTextureNums();
                    int n2 = n;
                    nArray[n2] = nArray[n2] + 1;
                    if (ShaderDetailPart.this.shaderPart.getTextureNums()[n] > 3) {
                        ShaderDetailPart.this.shaderPart.getTextureNums()[n] = 0;
                    }
                    String s = ShaderDetailPart.this.shaderPart.getTextureNames().get(n);
                    ((DetailButton)e.getComponent()).setTitle("" + s.substring(1) + ": " + String.valueOf(ShaderDetailPart.this.shaderPart.getTextureNums()[n] + 1));
                    ShaderDetailPart.this.detail.shader.recompile();
                }
            });
        }
        this.setBounds(this.getBounds().x, this.getBounds().y, this.getBounds().width, maxy += 3);
        this.bvisible.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                ShaderDetailPart.this.shaderPart.setEnabled(!ShaderDetailPart.this.shaderPart.getEnabled());
                ShaderDetailPart.this.detail.shader.recompile();
                ShaderDetailPart.this.updateComponents();
            }
        });
        bDelete.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                ShaderDetailPart.this.detail.shader.getSumoShader().remove(ShaderDetailPart.this.shaderPart);
                ShaderDetailPart.this.detail.shader.recompile();
                ShaderDetailPart.this.detail.rebuildParts();
            }
        });
        if (this.com != null) {
            this.com.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    ShaderDetailPart.this.shaderPart.getFragmentPart().setBlend_mode(ShaderDetailPart.this.shaderPart.getFragmentPart().getBlend_mode() + 1);
                    ShaderDetailPart.this.detail.shader.recompile();
                    ShaderDetailPart.this.updateComponents();
                }
            });
        }
        bDown.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                int i = ShaderDetailPart.this.detail.shader.getSumoShader().getProgramms().lastIndexOf(ShaderDetailPart.this.shaderPart);
                if (i + 1 < ShaderDetailPart.this.detail.shader.getSumoShader().getProgramms().size()) {
                    ShaderDetailPart.this.detail.shader.getSumoShader().getProgramms().remove(ShaderDetailPart.this.shaderPart);
                    ShaderDetailPart.this.detail.shader.getSumoShader().getProgramms().add(i + 1, ShaderDetailPart.this.shaderPart);
                    ShaderDetailPart.this.detail.shader.recompile();
                    ShaderDetailPart.this.detail.rebuildParts();
                }
            }
        });
        bUP.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                int i = ShaderDetailPart.this.detail.shader.getSumoShader().getProgramms().lastIndexOf(ShaderDetailPart.this.shaderPart);
                if (i - 1 >= 0) {
                    ShaderDetailPart.this.detail.shader.getSumoShader().getProgramms().remove(ShaderDetailPart.this.shaderPart);
                    ShaderDetailPart.this.detail.shader.getSumoShader().getProgramms().add(i - 1, ShaderDetailPart.this.shaderPart);
                    ShaderDetailPart.this.detail.shader.recompile();
                    ShaderDetailPart.this.detail.rebuildParts();
                    System.out.println("joa");
                }
            }
        });
        this.updateComponents();
    }

    public void paint(Graphics g) {
        g.setColor(this.bgcolor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.black);
        g.setFont(Settings.bigfont);
        g.drawString(this.shaderPart.getTitle(), 45, 15);
        this.paintComponents(g);
    }

    public void setPos(int x, int y) {
        this.setBounds(x, y, this.width, this.getHeight());
    }

    public void updateComponents() {
        if (this.shaderPart.getEnabled()) {
            this.bvisible.setIcon(Icons.ICON_BOX_CHECK);
        } else {
            this.bvisible.setIcon(Icons.ICON_BOX);
        }
        if (this.com != null) {
            this.shaderPart.getFragmentPart();
            this.com.setTitle(PartFragment.COLOR_BLEND_TITLES[this.shaderPart.getFragmentPart().getBlend_mode()]);
        }
    }
}

