/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.detail.Elements;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import sumo.gui.Settings;
import sumo.gui.detail.Elements.DetailButton;
import sumo.gui.detail.Elements.DetailLabel;

public class Area
extends JPanel {
    ArrayList<JComponent> content = new ArrayList();
    private String title = "no title";
    private boolean needsReOrder = false;
    public static int LAYOUT_ONE = 0;
    public static int LAYOUT_TWO = 1;
    public static int LAYOUT_FREE = 2;
    int layout = 0;
    int myHeight = -1;

    public Area(String title, JPanel parent, int layout) {
        this.layout = layout;
        this.title = title;
    }

    public void paint(Graphics g) {
        if (this.needsReOrder) {
            this.reOrder();
        }
        g.setColor(Settings.lineBackground);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setFont(Settings.bigfont);
        g.setColor(Settings.borderColor);
        g.drawRoundRect(5, 10, this.getWidth() - 10, this.getHeight() - 20, 5, 5);
        int stringwidth = g.getFontMetrics().stringWidth(this.title);
        g.setColor(Settings.lineBackground);
        g.fillRect(15, 2, stringwidth + 10, 17);
        g.setColor(Color.black);
        g.drawString(this.title, 20, 15);
        this.paintComponents(g);
    }

    private void reOrder() {
        if (this.layout == LAYOUT_FREE) {
            return;
        }
        this.removeAll();
        int posy = 26;
        if (this.layout == LAYOUT_ONE) {
            for (JComponent p : this.content) {
                p.setBounds(12, posy, this.getWidth() - 20, p.getHeight());
                posy += p.getHeight() + 5;
                this.add(p);
            }
        } else if (this.layout == LAYOUT_TWO) {
            boolean cycle = false;
            for (JComponent p : this.content) {
                int xx = 10;
                if (cycle) {
                    xx = this.getWidth() / 2;
                }
                p.setBounds(xx, posy, this.getWidth() / 2 - 20, p.getHeight());
                this.add(p);
                if (cycle) {
                    posy += p.getHeight() + 5;
                }
                cycle = !cycle;
            }
            if ((double)(this.content.size() % 2) != 0.0) {
                posy += this.content.get(this.content.size() - 1).getHeight() + 5;
            }
        }
        if (this.layout != LAYOUT_FREE) {
            this.setBounds(this.getBounds().x, this.getBounds().y, this.getWidth(), posy + 13);
        }
    }

    public void addLine(DetailButton b) {
        this.needsReOrder = true;
        this.content.add(b);
    }

    public void addLine(DetailLabel b) {
        this.needsReOrder = true;
        this.content.add(b);
    }

    public int CalcHeight() {
        if (this.myHeight != -1) {
            this.setBounds(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.myHeight);
            return this.myHeight;
        }
        this.reOrder();
        return this.getBounds().height;
    }

    public void setAreaHeight(int i) {
        this.myHeight = i;
        this.setBounds(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.myHeight);
    }
}

