/*
 * Decompiled with CFR 0.152.
 */
package sumo.game;

import java.util.ArrayList;
import java.util.List;
import sumo.game.WarpEvent;
import sumo.game.character;
import sumo.resource.types.v3d;
import sumo.v3d.Camera;
import sumo.v3d.Light;
import sumo.v3d.NodeIF;
import sumo.v3d.Scene;
import sumo.v3d.math.VEC3Tweened;
import sumo.v3d.mesh.BoundingBoxAA;
import sumo.v3d.mesh.Object;

public class Level {
    public Scene scene = null;
    v3d v3dfile = null;
    Camera cam = null;
    ArrayList<BoundingBoxAA> boxes = new ArrayList();
    ArrayList<BoundingBoxAA> warpBoxes = new ArrayList();
    ArrayList<WarpEvent> warpEvents = new ArrayList();

    public Level(v3d v3dfile) {
        this.v3dfile = v3dfile;
        this.scene = v3dfile.getScene();
        this.scene.loop = true;
        this.scene.shadowed = true;
        this.cam = (Camera)this.scene.getCam();
        this.calcBoundingBoxes();
    }

    public Camera getCam() {
        return this.cam;
    }

    public void render(float time) {
        this.scene.render(time);
        this.scene.shadow.polyOffsetFactor = 3.0f;
        this.scene.shadow.polyOffsetUnits = 1.0f;
    }

    private void calcBoundingBoxes() {
        List<NodeIF> meshes = this.scene.getMeshesByNameContains("_bb");
        for (NodeIF m : meshes) {
            BoundingBoxAA b = new BoundingBoxAA();
            b.calc((Object)m);
            this.boxes.add(b);
        }
        List<NodeIF> warpMeshes = this.scene.getMeshesByNameContains("_warp");
        for (NodeIF m : warpMeshes) {
            BoundingBoxAA b = new BoundingBoxAA();
            b.calc((Object)m);
            this.warpBoxes.add(b);
        }
    }

    public float getNextZ(VEC3Tweened pos) {
        float f = -1.0E9f;
        for (BoundingBoxAA b : this.boxes) {
            if (!b.collisiontestXY(pos) || !(b.getMaxZ() > f) || !(b.getMaxZ() < pos.z.getValue() + 30.0f)) continue;
            f = b.getMaxZ();
        }
        return f;
    }

    public void testCollision(character c) {
        for (BoundingBoxAA b : this.warpBoxes) {
            if (!b.collisiontestXYZ(c.pos)) continue;
            for (WarpEvent we : this.warpEvents) {
                we.warp(b.getName());
            }
        }
        boolean foundcollision = false;
        for (BoundingBoxAA b : this.boxes) {
            if (!b.collisiontestXYZ(c.pos)) continue;
            foundcollision = true;
            System.out.println("foundcollision!" + b.getName());
            c.useLastValidPos();
        }
        if (!foundcollision) {
            c.setLastValidPos(c.pos);
        }
    }

    public void addWarp(WarpEvent warpEvent) {
        this.warpEvents.add(warpEvent);
    }

    public Light getLight() {
        return this.scene.getLight();
    }
}

