/*
 * Decompiled with CFR 0.152.
 */
package sumo.app;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import sumo.game.GameMenu;
import sumo.game.Level;
import sumo.game.PostProcess;
import sumo.game.WarpEvent;
import sumo.game.character;
import sumo.gui.dialogs.exceptionDialog;
import sumo.math.vec2i;
import sumo.opengl.FBO;
import sumo.opengl.GLWindow;
import sumo.opengl.OpenGLSettings;
import sumo.project.Project;
import sumo.resource.types.Texture;
import sumo.resource.types.v3d;
import sumo.util.FPSCounter;
import sumo.v3d.Camera;
import sumo.v3d.Shader;
import sumo.v3d.ShaderProgram;
import sumoTween.timer.TimerIF;

public class gametest {
    static float time = 0.0f;
    static Camera cam;
    static Level currentLevel;
    public static TimerIF timer;
    private static ArrayList<Level> levels;
    static character c;
    static float oldx;
    static float oldy;
    static float oldz;
    static float oldeyex;
    static float oldeyey;
    static float oldeyez;
    static float camdistance;
    static FloatBuffer matrixModelView;
    static FloatBuffer matrixProjection;
    static FloatBuffer matrixCameraInverse;
    public static ShaderProgram shadowShader;
    static Shader sv;
    static Shader sf;
    static FBO shadowfFBO;
    public static Texture shadowTextureFBO;
    static int SHADOW_WIDTH;
    static int SHADOW_HEIGHT;

    public static void main(String[] args) {
        Project p = new Project();
        Project.guimode = false;
        p.init();
        Project.setProject(p);
        OpenGLSettings settings = new OpenGLSettings(1280, 720, false);
        settings.setMultisampling(4);
        p.setOpenGLSsettings(settings);
        GLWindow win = new GLWindow(settings.findMode(), settings);
        win.open();
        boolean isPlaying = false;
        boolean isDragging = false;
        vec2i dragStart = new vec2i();
        vec2i mousePos = new vec2i();
        vec2i mouseDragPos = new vec2i();
        Project.getProject().getResourceManager().add("c:/demogame/", "char_walk.v3d");
        Project.getProject().getResourceManager().add("c:/demogame/", "char_jump.v3d");
        Project.getProject().getResourceManager().add("c:/demogame/", "area.v3d");
        Project.getProject().getResourceManager().add("c:/demogame/", "area2.v3d");
        while (Project.getProject().getResourceManager().loadingBar()) {
        }
        timer = Project.getProject().getTimer();
        System.out.println("character init");
        c = new character();
        c.init();
        System.out.println("loading area v3d...");
        gametest.loadLevel("area.v3d");
        gametest.loadLevel("area2.v3d");
        gametest.switchLevel(levels.get(0));
        levels.get(0).addWarp(new WarpEvent(){

            public void warp(String objName) {
                if (objName.equals("_warp1")) {
                    System.out.println("YEAH!!!");
                    gametest.switchLevel((Level)levels.get(1));
                }
            }
        });
        PostProcess pp = new PostProcess();
        FPSCounter fpsCounter = new FPSCounter();
        try {
            System.out.println("init inputs...");
            System.out.println("creatin menu...");
            GameMenu m = new GameMenu();
            GL11.glClearColor((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
            System.out.println("loop...");
            while (!Keyboard.isKeyDown((int)1)) {
                time = Project.getProject().getTime();
                gametest.doKeyboard(c, time);
                gametest.doCamera(time, c);
                GL11.glClear((int)16640);
                currentLevel.render(time);
                GL11.glPushMatrix();
                c.render(time);
                GL11.glPopMatrix();
                currentLevel.testCollision(c);
                float z = currentLevel.getNextZ(gametest.c.pos);
                c.setAutoPosZ(z);
                fpsCounter.nextFrame();
                Display.update();
                if (!isPlaying && Project.getProject().getResourceManager().isAllLoaded()) {
                    Project.getProject().getTimer().play();
                    isPlaying = true;
                }
                Mouse.poll();
                int wheel = Mouse.getDWheel();
                if (wheel != 0 && (camdistance += -0.2f * (float)wheel) < 0.0f) {
                    camdistance = 20.0f;
                }
                if (Mouse.isButtonDown((int)0)) {
                    if (!isDragging) {
                        isDragging = true;
                    }
                } else {
                    isDragging = false;
                }
                GL11.glClear((int)256);
                Display.setTitle((String)("pos: " + gametest.c.pos.z.getValue() + " fps:" + fpsCounter.fps));
                try {
                    Thread.sleep(5L);
                }
                catch (Exception e) {}
            }
            win.close();
        }
        catch (Exception e) {
            new exceptionDialog(e);
        }
        System.exit(0);
    }

    private static void doCamera(float time, character c) {
        oldx = gametest.cam.target.x.getValue(time);
        oldy = gametest.cam.target.y.getValue(time);
        oldz = gametest.cam.target.z.getValue(time);
        oldeyex = gametest.cam.eye.x.getValue(time);
        oldeyey = gametest.cam.eye.y.getValue(time);
        oldeyez = gametest.cam.eye.z.getValue(time);
        gametest.cam.target.x.clear();
        gametest.cam.target.y.clear();
        gametest.cam.projecttimer = true;
        gametest.cam.eye.x.clear();
        gametest.cam.eye.y.clear();
        gametest.cam.target.x.setKeyframingEnabled(true);
        gametest.cam.target.y.setKeyframingEnabled(true);
        gametest.cam.target.z.setKeyframingEnabled(true);
        gametest.cam.eye.x.setKeyframingEnabled(true);
        gametest.cam.eye.y.setKeyframingEnabled(true);
        gametest.cam.eye.z.setKeyframingEnabled(true);
        float camDelay = 1.0f;
        gametest.cam.target.x.setValue(time, oldx);
        gametest.cam.target.x.setValue(time + camDelay, c.pos.x.getValue(time));
        gametest.cam.target.y.setValue(time, oldy);
        gametest.cam.target.y.setValue(time + camDelay, c.pos.y.getValue(time));
        gametest.cam.target.z.setValue(time, oldz);
        gametest.cam.target.z.setValue(time, c.pos.z.getValue(time));
        gametest.cam.eye.x.setValue(time, oldeyex);
        gametest.cam.eye.x.setValue(time + camDelay, c.pos.x.getValue(time) + camdistance);
        gametest.cam.eye.y.setValue(time, oldeyey);
        gametest.cam.eye.y.setValue(time + camDelay, c.pos.y.getValue(time) + 20.0f);
        gametest.cam.eye.z.setValue(time, oldeyez);
        gametest.cam.eye.z.setValue(time, c.pos.z.getValue(time) + 60.0f);
    }

    private static void doKeyboard(character c, float time) {
        if (Keyboard.isKeyDown((int)19)) {
            c = new character();
            c.init();
        }
        if (Keyboard.isKeyDown((int)203)) {
            c.setWalkDir(time, 0.0f);
        }
        if (Keyboard.isKeyDown((int)205)) {
            c.setWalkDir(time, 180.0f);
        }
        if (Keyboard.isKeyDown((int)200)) {
            c.setWalkDir(time, 270.0f);
        }
        if (Keyboard.isKeyDown((int)208)) {
            c.setWalkDir(time, 90.0f);
        }
        if (Keyboard.isKeyDown((int)57)) {
            c.jump(time);
        }
        if (Keyboard.isKeyDown((int)203)) {
            c.walky(time, -1.0f);
        }
        if (Keyboard.isKeyDown((int)205)) {
            c.walky(time, 1.0f);
        }
        if (Keyboard.isKeyDown((int)200)) {
            c.walkx(time, -1.0f);
        }
        if (Keyboard.isKeyDown((int)208)) {
            c.walkx(time, 1.0f);
        }
    }

    private static void loadLevel(String filename) {
        v3d v = (v3d)Project.getProject().getResourceManager().getResourceByFileName(filename);
        Level l = new Level(v);
        l.scene.rootnode.addChild(c);
        levels.add(l);
    }

    static void setController() {
        try {
            Controllers.create();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static void switchLevel(Level l) {
        currentLevel = l;
        cam = currentLevel.getCam();
    }

    public static void initShadow() {
        sf = new Shader("c:/demogame/", "shadow.fs", 1);
        sv = new Shader("c:/demogame/", "shadow.vs", 2);
        shadowShader.changeShader(sf);
        shadowShader.changeShader(sv);
        shadowTextureFBO = new Texture("", SHADOW_WIDTH, SHADOW_HEIGHT, false, true);
        shadowfFBO = new FBO(null, shadowTextureFBO, 2);
    }

    public static void RenderWorld(boolean useCam) {
        GL11.glPushMatrix();
        cam.setEnabled(false);
        currentLevel.render(time);
        GL11.glPushMatrix();
        c.render(time);
        GL11.glPopMatrix();
        currentLevel.testCollision(c);
        float z = currentLevel.getNextZ(gametest.c.pos);
        c.setAutoPosZ(z);
        GL11.glPopMatrix();
    }

    static void applyShadowMap() {
        shadowShader.bind();
        ARBMultitexture.glActiveTextureARB((int)33984);
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)shadowTextureFBO.getID());
        shadowShader.setUniform1i(shadowShader.setUniformLocation("shadowMap"), 0);
        GL11.glTexParameteri((int)3553, (int)34892, (int)34894);
        GL11.glTexParameteri((int)3553, (int)34893, (int)515);
        float[] mBias = new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f};
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)16);
        fb.put(mBias).rewind();
        GL11.glMatrixMode((int)5890);
        GL11.glLoadMatrix((FloatBuffer)fb);
        GL11.glMultMatrix((FloatBuffer)matrixProjection);
        GL11.glMultMatrix((FloatBuffer)matrixModelView);
        GL11.glMultMatrix((FloatBuffer)matrixCameraInverse);
        GL11.glMatrixMode((int)5888);
        gametest.RenderWorld(true);
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        ARBMultitexture.glActiveTextureARB((int)33984);
        GL11.glDisable((int)3553);
        shadowShader.unbind();
    }

    static {
        levels = new ArrayList();
        camdistance = 200.0f;
        shadowShader = new ShaderProgram();
        shadowfFBO = null;
        SHADOW_WIDTH = 2048;
        SHADOW_HEIGHT = 2048;
    }
}

