/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import sumo.project.Project;

public class Shader {
    int type = 0;
    public String text = "";
    int shaderID = -1;
    public static final int SHADER_FRAGMENT = 1;
    public static final int SHADER_VERTEX = 2;
    public boolean loaded = false;
    public boolean updateProgram = false;
    boolean bound = false;
    String _filename = "";
    String _path = "";

    public void recompile() {
        ByteBuffer shadebytebuffer = this.getProgramCode(this._path, this._filename);
        if (shadebytebuffer == null) {
            System.out.println("shader null");
            System.exit(0);
        }
        int which = -1;
        which = this.type == 1 ? 35632 : 35633;
        if (this.shaderID == -1) {
            this.shaderID = ARBShaderObjects.glCreateShaderObjectARB(which);
        }
        ARBShaderObjects.glShaderSourceARB(this.shaderID, shadebytebuffer);
        ARBShaderObjects.glCompileShaderARB(this.shaderID);
        System.out.println("shader compiled :" + this.shaderID + " (" + this._filename + ")");
        int er = GL11.glGetError();
        if (er != 0) {
            // empty if block
        }
        this.updateProgram = true;
        this.loaded = true;
    }

    void loadShader(String path, String filename) {
        try {
            this._path = path;
            this._filename = filename;
            this.recompile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Shader(String path, String filename, int shadertype) {
        this.type = shadertype;
        this.loadShader(path, filename);
    }

    public void reload() {
        System.out.println("reload shader:" + this._filename);
        this.recompile();
    }

    private ByteBuffer getProgramCode(String path, String filename) {
        InputStream fileInputStream = Project.getProject().getInputStream(path, filename);
        byte[] shaderCode = null;
        try {
            if (fileInputStream == null) {
                fileInputStream = new FileInputStream(path + filename);
            }
            DataInputStream dataStream = new DataInputStream(fileInputStream);
            shaderCode = new byte[fileInputStream.available()];
            dataStream.readFully(shaderCode);
            this.text = new String(shaderCode);
            fileInputStream.close();
            dataStream.close();
        }
        catch (Exception e) {
            System.out.println("filename:" + path + filename);
            System.out.println("" + e);
        }
        ByteBuffer shaderPro = BufferUtils.createByteBuffer(shaderCode.length);
        shaderPro.put(shaderCode);
        shaderPro.flip();
        return shaderPro;
    }
}

