/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import sumo.v3d.Node;
import sumo.v3d.NodeIF;
import sumo.v3d.math.Vec3fkeyframed;

public class Light
extends Node
implements NodeIF {
    public FloatBuffer colorDiffuseFB = BufferUtils.createFloatBuffer(4);
    public FloatBuffer colorAmbientFB = BufferUtils.createFloatBuffer(4);
    public FloatBuffer colorSpecularFB = BufferUtils.createFloatBuffer(4);
    public Vec3fkeyframed posAnim = null;
    public FloatBuffer pos = BufferUtils.createFloatBuffer(4);

    public void setPos(float x, float y, float z) {
        float[] fff = new float[]{x, y, z};
        this.pos.put(fff).rewind();
    }

    public void setDiffuse(float r, float g, float b) {
        this.colorDiffuseFB.put(new float[]{r, g, b, 1.0f}).rewind();
    }

    public Light() {
        this.type = 2;
        this.setOrder(10);
        this.colorAmbientFB.put(new float[]{0.2f, 0.2f, 0.2f, 1.0f}).rewind();
        this.colorSpecularFB.put(new float[]{1.0f, 1.0f, 1.0f, 1.0f}).rewind();
        this.colorDiffuseFB.put(new float[]{1.0f, 1.0f, 1.0f, 1.0f}).rewind();
    }

    public void render(float time) {
        if (this.posAnim != null) {
            this.setPos(this.posAnim.x.getValue(time), this.posAnim.y.getValue(time), this.posAnim.z.getValue(time));
        }
        GL11.glLight(16385, 4611, this.pos);
        GL11.glEnable(2896);
        GL11.glLightModel(2899, this.colorAmbientFB);
        GL11.glEnable(16385);
        GL11.glLight(16385, 4608, this.colorAmbientFB);
        GL11.glLight(16385, 4609, this.colorDiffuseFB);
        GL11.glLight(16385, 4610, this.colorSpecularFB);
    }
}

