/*
 * Decompiled with CFR 0.152.
 */
package sumo.shader;

import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.shader.PartFragment;
import sumo.shader.PartVertex;
import sumo.shader.ShaderVariable;
import sumo.shader.SumoShader;
import sumo.util.FileChangeListener;
import sumo.util.FileChangeWatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShaderPartProgram {
    private PartFragment frag = null;
    private PartVertex vert = null;
    private boolean enabled = true;
    private String title = "";
    private String filename = "";
    private FileChangeWatcher fileWatcher = null;
    private SumoShader shader;
    public static boolean watchshaders = true;

    public String getFilename() {
        return this.filename;
    }

    public ShaderPartProgram(SumoShader sh, String filename) {
        this.shader = sh;
        this.filename = filename;
        this.reload();
    }

    public PartFragment getFragmentPart() {
        return this.frag;
    }

    public PartVertex getVertexPart() {
        return this.vert;
    }

    public ArrayList<ShaderVariable> getUniforms() {
        ArrayList<ShaderVariable> l = new ArrayList<ShaderVariable>();
        if (this.frag != null) {
            for (ShaderVariable var : this.frag.getUniforms()) {
                l.add(var);
            }
        }
        if (this.vert != null) {
            for (ShaderVariable var : this.vert.getUniforms()) {
                l.add(var);
            }
        }
        return l;
    }

    public void reload() {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(this.filename);
            doc.getDocumentElement().normalize();
            Element eShader = (Element)doc.getElementsByTagName("sumoshader").item(0);
            this.title = eShader == null || eShader.getAttribute("name") == null ? "xml error" : eShader.getAttribute("name");
            NodeList nl = eShader.getElementsByTagName("shader");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element e = (Element)nl.item(i);
                if (e.getAttribute("type").toLowerCase().equals("vertex")) {
                    if (this.vert != null) {
                        this.vert.reload(e);
                        continue;
                    }
                    this.vert = new PartVertex(e);
                    continue;
                }
                if (!e.getAttribute("type").toLowerCase().equals("fragment")) continue;
                if (this.frag != null) {
                    this.frag.reload(e);
                    continue;
                }
                this.frag = new PartFragment(e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.shader.setNeedsRecompile();
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
    }

    public ArrayList<String> getTextureNames() {
        return this.frag.getTextureNames();
    }

    public void setTextureNum(int which, int slot) {
        this.frag.setTextureNum(which, slot);
    }

    public int[] getTextureNums() {
        return this.frag.getTextureNums();
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isAutoReloaded() {
        return this.fileWatcher != null;
    }

    public void setAutoReload(boolean rel) {
        if (watchshaders) {
            if (rel) {
                this.fileWatcher = new FileChangeWatcher(this.filename);
                this.fileWatcher.addFileChangeListener(new FileChangeListener(){

                    public void fileChanged() {
                        ShaderPartProgram.this.reload();
                    }
                });
            } else {
                System.out.println("destroy...");
                this.fileWatcher.dispose();
                this.fileWatcher = null;
            }
        }
    }

    public ShaderVariable getUniform(String name) {
        ArrayList<ShaderVariable> vars = this.getUniforms();
        for (ShaderVariable var : vars) {
            if (!var.name.equals(name)) continue;
            return var;
        }
        return null;
    }
}

