/*
 * Decompiled with CFR 0.152.
 */
package sumo.resource.types;

import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import sumo.resource.resourceIF;
import sumo.resource.types.textureFile;
import sumo.util.Log;

public class Texture
extends textureFile
implements resourceIF {
    public boolean isDepthTexture = false;
    public boolean rgbamode = true;
    public int texturetype = -1;
    int[] pixels;

    public Texture(String filename, int w, int h, boolean rgba, boolean depth) {
        this.width = w;
        this.height = h;
        this.rgbamode = rgba;
        this.isDepthTexture = depth;
        Log.log("res_texture created texture: " + filename + " width:" + this.width + " height:" + this.height);
        if (w == h) {
            this.texturetype = 3553;
            this.id = Texture.createDepthTexture2D(w, h, rgba, depth);
        } else {
            this.texturetype = 34037;
            this.id = Texture.createTexture(w, h, rgba, depth);
        }
        this.setFilename(filename);
    }

    public void setID(int i) {
        this.id = i;
        this.loaded = true;
    }

    public void updateTexture() {
    }

    public void load() {
        Log.log("creating texture " + this.getFilename() + " " + this.width + "x" + this.height);
        this.id = Texture.createTexture(this.width, this.height, this.rgbamode, this.isDepthTexture);
        this.bind();
        this.loaded = true;
    }

    public void loadFromImage(BufferedImage im) {
        IntBuffer buf = null;
        buf = BufferUtils.createIntBuffer(1);
        GL11.glGenTextures(buf);
        this.width = im.getWidth();
        this.height = im.getHeight();
        GL11.glBindTexture(34037, buf.get(0));
        GL11.glTexParameteri(34037, 10241, 9729);
        GL11.glTexParameteri(34037, 10240, 9729);
        GL11.glTexImage2D(34037, 0, 6408, this.width, this.height, 0, 6408, 5121, Texture.convertImagePixels(this.getImagePixels(im), this.width, this.height, true));
        this.setID(buf.get(0));
        this.pixels = null;
    }

    public int[] getImagePixels(BufferedImage im) {
        this.pixels = new int[im.getHeight() * im.getWidth()];
        PixelGrabber pg = new PixelGrabber(im, 0, 0, im.getWidth(), im.getHeight(), this.pixels, 0, im.getWidth());
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            System.out.println("Pixel Grabbing interrupted!");
            return null;
        }
        return this.pixels;
    }

    public static ByteBuffer convertImagePixels(int[] jpixels, int imgw, int imgh, boolean flipVertically) {
        if (flipVertically) {
            jpixels = Texture.flipPixels(jpixels, imgw, imgh);
        }
        byte[] bytes = Texture.convertARGBtoRGBA(jpixels);
        return Texture.allocBytes(bytes);
    }

    public static int[] flipPixels(int[] imgPixels, int imgw, int imgh) {
        int[] flippedPixels = null;
        if (imgPixels != null) {
            flippedPixels = new int[imgw * imgh];
            for (int y = 0; y < imgh; ++y) {
                for (int x = 0; x < imgw; ++x) {
                    flippedPixels[(imgh - y - 1) * imgw + x] = imgPixels[y * imgw + x];
                }
            }
        }
        return flippedPixels;
    }

    public static byte[] convertARGBtoRGBA(int[] jpixels) {
        if (jpixels == null) {
            return null;
        }
        byte[] bytes = new byte[jpixels.length * 4];
        int j = 0;
        for (int i = 0; i < jpixels.length; ++i) {
            boolean outPixel = false;
            int p = jpixels[i];
            int a = p >> 24 & 0xFF;
            int r = p >> 16 & 0xFF;
            int g = p >> 8 & 0xFF;
            int b = p >> 0 & 0xFF;
            bytes[j + 0] = (byte)r;
            bytes[j + 1] = (byte)g;
            bytes[j + 2] = (byte)b;
            bytes[j + 3] = (byte)a;
            j += 4;
        }
        return bytes;
    }

    public static ByteBuffer allocBytes(byte[] bytearray) {
        int SIZE_BYTE = 1;
        ByteBuffer bb = ByteBuffer.allocateDirect(bytearray.length * SIZE_BYTE).order(ByteOrder.nativeOrder());
        bb.put(bytearray).rewind();
        return bb;
    }

    public static int createTexture(int width, int height, boolean rgba, boolean isDepthTexture) {
        int bytepp = 4;
        if (!rgba) {
            bytepp = 3;
        }
        if (isDepthTexture) {
            bytepp = 4;
        }
        IntBuffer buf = null;
        try {
            buf = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
            GL11.glGenTextures(buf);
            GL11.glBindTexture(34037, buf.get(0));
            ByteBuffer bb = ByteBuffer.allocateDirect(width * height * bytepp);
            GL11.glTexParameteri(34037, 10241, 9729);
            GL11.glTexParameteri(34037, 10240, 9729);
            int rgbamode = 6408;
            if (!rgba) {
                rgbamode = 6407;
            }
            if (isDepthTexture) {
                GL11.glTexImage2D(34037, 0, 33190, width, height, 0, 6402, 5126, bb);
            } else {
                GL11.glTexImage2D(34037, 0, rgbamode, width, height, 0, 6408, 5121, bb);
            }
            bb = ByteBuffer.allocateDirect(1);
        }
        catch (Exception e) {
            System.out.println("mem error...");
        }
        return buf.get(0);
    }

    public static int createDepthTexture2D(int width, int height, boolean rgba, boolean isDepthTexture) {
        int bytepp = 4;
        IntBuffer buf = null;
        System.out.println("CREATING SHADOWMAP!!!!!!!!!");
        try {
            buf = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
            GL11.glGenTextures(buf);
            GL11.glBindTexture(3553, buf.get(0));
            ByteBuffer bb = ByteBuffer.allocateDirect(width * height * bytepp);
            GL11.glTexImage2D(3553, 0, 6402, width, height, 0, 6402, 5125, bb);
            GL11.glTexParameteri(3553, 10241, 9729);
            GL11.glTexParameteri(3553, 10240, 9729);
            bb = ByteBuffer.allocateDirect(1);
        }
        catch (Exception e) {
            System.out.println("mem error...");
            e.printStackTrace();
        }
        return buf.get(0);
    }
}

