/*
 * Decompiled with CFR 0.152.
 */
package sumo.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import java.util.jar.JarFile;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.app.guitest;
import sumo.gui.dialogs.exceptionDialog;
import sumo.gui.dialogs.selector.SelectorItem;
import sumo.keyframing.KeyframedResource;
import sumo.opengl.common;
import sumo.opengl.loadingbar;
import sumo.project.Project;
import sumo.resource.resource;
import sumo.resource.resourceIF;
import sumo.resource.resourceType;
import sumo.resource.types.FBOResource;
import sumo.util.Files;
import sumo.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager {
    ArrayList<resourceIF> resources = new ArrayList();
    Vector resourceTypes = null;
    private loadingbar load = new loadingbar();
    public static boolean useRelativePath = false;
    private boolean isAllLoaded = true;
    KeyframedResource activeResourceSelect = null;
    private boolean loadFromJar = false;
    ArrayList<String> alternativPaths = new ArrayList();
    ArrayList<KeyframedResource> allKeyframedResources;

    public ArrayList<resourceIF> getAllResources() {
        return this.resources;
    }

    public ArrayList<resourceIF> getResources(Class c) {
        ArrayList<resourceIF> rs = new ArrayList<resourceIF>();
        for (resourceIF r : this.resources) {
            if (!r.getClass().equals(c)) continue;
            rs.add(r);
        }
        return rs;
    }

    public String[][] getAllResourcesList(String s) {
        int count = 0;
        Log.log("getAllResourcesList: " + s);
        for (int i = 0; i < this.resources.size(); ++i) {
            resource r = (resource)((Object)this.resources.get(i));
            if (r.getTypeDescr().equals(s)) {
                ++count;
            }
            Log.log("resource: " + r.getTypeDescr());
        }
        String[][] ret = new String[count][3];
        count = 0;
        for (int i = 0; i < this.resources.size(); ++i) {
            resource r = (resource)((Object)this.resources.get(i));
            if (!r.getTypeDescr().equals(s)) continue;
            ret[count][0] = r.filename;
            ret[count][1] = r.getTypeDescr();
            ret[count][2] = r.getInfo();
            ++count;
        }
        return ret;
    }

    public void addResourceType(resourceType rt) {
        if (this.resourceTypes == null) {
            this.resourceTypes = new Vector();
        }
        this.resourceTypes.add(rt);
    }

    public void init() {
        Log.log("resourcemanager init");
    }

    public resourceIF getResourceLoaderInstance(String classname) {
        Log.log("getResourceInstance");
        resourceIF c = null;
        try {
            Log.log("classname:" + classname);
            Class<?> testclass = Class.forName(classname);
            c = (resourceIF)testclass.newInstance();
        }
        catch (Exception e) {
            Log.error(e);
        }
        return c;
    }

    public void addAlternativePath(String s) {
        if (!this.alternativPaths.contains(s)) {
            this.alternativPaths.add(s);
        }
    }

    public void fixResourcePath(resourceIF r) {
        if (useRelativePath) {
            r.setPath("data/");
        }
        if (!ResourceManager.fileExist(r.getPath() + r.getFilename())) {
            for (int i = 0; i < this.alternativPaths.size(); ++i) {
                r.setPath(this.alternativPaths.get(i));
                if (!ResourceManager.fileExist(r.getPath() + r.getFilename())) continue;
                return;
            }
        }
    }

    public void addNoCheck(resourceIF r) {
        this.resources.add(r);
        this.isAllLoaded = false;
    }

    public void add(resourceIF r) {
        if (!r.getFilename().startsWith("pbuffer") && !r.getFilename().startsWith("_vsys")) {
            this.alternativPaths.add(r.getPath());
        }
        if (!ResourceManager.fileExist(r.getPath() + r.getFilename())) {
            this.fixResourcePath(r);
        }
        this.resources.add(r);
        this.isAllLoaded = false;
    }

    public static boolean fileExist(String filename) {
        if (filename.contains("framebuffer 3 depth")) {
            return true;
        }
        if (filename.contains("framebuffer 1")) {
            return true;
        }
        if (filename.contains("framebuffer 2")) {
            return true;
        }
        if (filename.contains("framebuffer 3 color")) {
            return true;
        }
        File f = new File(filename);
        if (!f.exists()) {
            Log.log("does not exist:" + filename);
            return false;
        }
        return true;
    }

    public resourceIF add(String path, String filename) {
        if (this.allreadyloaded(filename)) {
            return this.getResourceByFileName(filename);
        }
        if (this.getResourceByFileName(filename) != null) {
            return null;
        }
        if (filename.equals("pbuffer")) {
            return null;
        }
        if (filename.equals("_vsys")) {
            return null;
        }
        this.addAlternativePath("demo/");
        this.addAlternativePath(path);
        boolean found = false;
        resourceIF r = null;
        try {
            if (this.resourceTypes == null) {
                this.init();
            }
            for (int i = 0; i < this.resourceTypes.size(); ++i) {
                resourceType rt = (resourceType)this.resourceTypes.get(i);
                for (int a = 0; a < rt.getFilenameExtensions().length; ++a) {
                    if (!filename.toLowerCase().endsWith("." + rt.getFilenameExtensions()[a].toLowerCase())) continue;
                    Log.log("adding resource:" + path + "/" + filename + " class: _" + rt.getLoaderclass() + "_");
                    r = this.getResourceLoaderInstance(rt.getLoaderclass());
                    r.setFilename(filename);
                    r.setPath(path);
                    this.isAllLoaded = false;
                    found = true;
                }
            }
            if (r != null) {
                this.fixResourcePath(r);
                this.resources.add(r);
            } else {
                System.out.println("RESOURCE NOT ADDED, IS NULL");
            }
            return r;
        }
        catch (Exception e) {
            Log.error("resourceloader error", e);
            return null;
        }
    }

    boolean allreadyloaded(String fn) {
        for (int i = 0; i < this.resources.size(); ++i) {
            resourceIF r = this.resources.get(i);
            if (!r.getFilename().equals(fn)) continue;
            return true;
        }
        return false;
    }

    public Vector getResourceNames() {
        Vector v = new Vector();
        for (int i = 0; i < this.resources.size(); ++i) {
            resourceIF r = this.resources.get(i);
            Vector<String> info = new Vector<String>();
            info.add(r.getPath());
            info.add(r.getFilename());
            info.add(r.getTypeDescr());
            v.add(info);
        }
        return v;
    }

    public resourceIF getResourceByFileName(String s) {
        if (s == null) {
            return null;
        }
        resourceIF r = null;
        resourceIF rr = null;
        for (int i = 0; i < this.resources.size(); ++i) {
            r = this.resources.get(i);
            if (r == null) {
                System.out.println("OUGH!!!!");
                continue;
            }
            if (!r.getFilename().endsWith(s)) continue;
            rr = r;
        }
        return rr;
    }

    public int numResources(String filter) {
        int count = 0;
        for (int i = 0; i < this.resources.size(); ++i) {
            resourceIF t = this.resources.get(i);
            if (!t.getTypeDescr().equals(filter)) continue;
            ++count;
        }
        return count;
    }

    public void printAllResources() {
        System.out.println("-----all resources");
        for (int i = 0; i < this.resources.size(); ++i) {
            resourceIF t = this.resources.get(i);
            System.out.println(t.getFilename());
        }
        System.out.println("---");
    }

    public String[] getResourceNamesArray(String filter) {
        Log.log("namesarray:");
        int count = 0;
        String[] titles = new String[this.numResources(filter)];
        for (int i = 0; i < this.resources.size(); ++i) {
            resourceIF t = this.resources.get(i);
            if (t.getTypeDescr().equals(filter)) {
                titles[count] = t.getFilename();
                ++count;
            }
            Log.log("namesarray:" + t.getFilename());
        }
        return titles;
    }

    public void copyResourcesTo(String toPath) {
        for (int i = 0; i < this.resources.size(); ++i) {
            resourceIF t = this.resources.get(i);
            if (!t.getFilename().startsWith("pbuffer") && !t.getFilename().startsWith("_vsys")) {
                Files.copyfile(t.getPath() + t.getFilename(), toPath + t.getFilename());
            }
            Log.log("_" + t.getFilename());
        }
    }

    public void checkAllLoaded() {
        ArrayList<resourceIF> l = this.getAllResources();
        this.isAllLoaded = true;
        for (resourceIF r : l) {
            if (r.isLoaded() || r instanceof FBOResource) continue;
            this.isAllLoaded = false;
            return;
        }
    }

    public void loadResources() {
        if (!this.isAllLoaded()) {
            ArrayList<resourceIF> l = this.getAllResources();
            for (int i = 0; i < l.size(); ++i) {
                resourceIF r = l.get(i);
                if (r == null) {
                    Log.log("resource is null!");
                    continue;
                }
                if (r.isLoaded()) continue;
                r.load();
            }
            this.isAllLoaded = true;
            System.gc();
            guitest.updateResources();
            if (this.allKeyframedResources != null) {
                for (KeyframedResource k : this.allKeyframedResources) {
                    k.notifyKeysChanged();
                }
            }
            this.allKeyframedResources = null;
        }
    }

    public void setAllLoaded(boolean b) {
        this.isAllLoaded = b;
    }

    public boolean getLoadFromJar() {
        return false;
    }

    public JarFile getJarFile() {
        return null;
    }

    public ArrayList<SelectorItem> getAsGuiITems(resourceIF restype) {
        ArrayList<SelectorItem> items = new ArrayList<SelectorItem>();
        ArrayList<resourceIF> resources2 = Project.getProject().getResourceManager().getAllResources();
        for (int i = 0; i < resources2.size(); ++i) {
            if (restype != null && !restype.getTypeDescr().equals(resources2.get(i).getTypeDescr())) continue;
            SelectorItem item = new SelectorItem();
            item.setTitle(resources2.get(i).getFilename());
            item.setDescr(resources2.get(i).getPath() + " - " + resources2.get(i).getInfo());
            item.setObj(resources2.get(i));
            item.setIcon(resources2.get(i).getIcon());
            items.add(item);
        }
        Collections.sort(items, new Comparator(){

            public int compare(Object a, Object b) {
                SelectorItem ia = (SelectorItem)a;
                SelectorItem ib = (SelectorItem)b;
                return ((resourceIF)ia.getObj()).getFilename().compareTo(((resourceIF)ib.getObj()).getFilename());
            }
        });
        return items;
    }

    public void setActiveResourceSelect(KeyframedResource r) {
        this.activeResourceSelect = r;
    }

    public KeyframedResource getActiveResourceSelect() {
        return this.activeResourceSelect;
    }

    public void removeActiveResourceSelect(KeyframedResource theResource) {
        this.activeResourceSelect = null;
    }

    public boolean isAllLoaded() {
        return this.isAllLoaded;
    }

    public void saveResources(Element root) {
        Element xmlResources = root.getOwnerDocument().createElement("resources");
        for (int i = 0; i < this.resources.size(); ++i) {
            resource r = (resource)((Object)this.resources.get(i));
            Element el = root.getOwnerDocument().createElement("resource");
            el.setAttribute("filename", r.getFilename());
            el.setAttribute("path", r.getPath());
            el.setAttribute("isRealFile", String.valueOf(r.isRealFile()));
            r.saveXML(el);
            xmlResources.appendChild(el);
        }
        root.appendChild(xmlResources);
    }

    public void setPingResourceSelectsAfterLoading(ArrayList<KeyframedResource> f) {
        this.allKeyframedResources = f;
    }

    public resourceIF addByClassName(Element er) {
        resourceIF r = null;
        System.out.println("loading by classname: " + er.getAttribute("class"));
        try {
            r = (resourceIF)Class.forName(er.getAttribute("class")).newInstance();
            r.setFilename(er.getAttribute("filename"));
            r.loadXML(er);
        }
        catch (Exception e) {
            new exceptionDialog(e);
        }
        this.add(r);
        return r;
    }

    public void loadResourcesXML(Element xmlResources) {
        if (xmlResources == null) {
            return;
        }
        NodeList ress = xmlResources.getElementsByTagName("resource");
        for (int i = 0; i < ress.getLength(); ++i) {
            Element el = (Element)ress.item(i);
            if (el.getAttribute("class").equals("")) continue;
            this.addByClassName(el);
        }
    }

    public boolean loadingBar() {
        this.checkAllLoaded();
        if (!this.isAllLoaded()) {
            ArrayList<resourceIF> l = Project.getProject().getResourceManager().getAllResources();
            int num = l.size();
            for (int i = 0; i < num; ++i) {
                l = Project.getProject().getResourceManager().getAllResources();
                num = l.size();
                resourceIF r = l.get(i);
                System.out.println(r.getFilename() + " " + r.isLoaded());
                if (r.isLoaded()) continue;
                System.out.println("resman loading resource: " + r.getFilename());
                float f = (float)i / (float)num;
                if (Project.getProject().numResourcesPredicted > 0) {
                    f = (float)i / (float)Project.getProject().numResourcesPredicted;
                }
                System.out.println("--------------------------------------------------------------------------" + f);
                common.switchTo2d();
                common.switchTo3d();
                GL11.glClearColor(0.2f, 0.2f, 0.2f, 1.0f);
                GL11.glClear(16640);
                if (f > 1.0f) {
                    f = 1.0f;
                }
                this.load.draw(f);
                if (Display.isCreated()) {
                    Display.processMessages();
                    try {
                        Display.swapBuffers();
                        Display.update();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                r.load();
            }
            System.gc();
            return true;
        }
        return false;
    }
}

