/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.superrandomevoke;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;
import org.w3c.dom.Element;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyframedBoolean;
import sumo.keyframing.KeyframedFloat;
import sumo.keyframing.KeyframedInt;
import sumo.keyframing.KeyframedResource;
import sumo.plugin.Plugin;
import sumo.plugins.superrandomevoke.RandomParticle;
import sumo.project.Project;
import sumo.resource.types.textureFile;
import sumo.resource.types.v3d;
import sumo.tools.freeTimer;
import sumo.v3d.NodeIF;
import sumo.v3d.Scene;
import sumo.v3d.mesh.Object;

public class SuperRandomEvoke
extends Plugin {
    float[] color_1 = new float[]{1.0f, 1.0f, 1.0f};
    float[] color_2 = new float[]{0.8235294f, 0.44705883f, 0.20784314f};
    float[] color_3 = new float[]{0.14509805f, 0.17254902f, 0.3372549f};
    Scene s;
    public KeyframedFloat size;
    public KeyframedFloat fov;
    public KeyframedFloat space;
    public KeyframedResource scene;
    public KeyframedInt randomize;
    public KeyframedInt num;
    public KeyframedInt cam;
    public KeyframedInt colorize;
    public KeyframedInt myactive;
    public KeyframedBoolean background;
    private float scale = 1.0f;
    private textureFile currenTexture = null;
    public static freeTimer frt = new freeTimer();
    ArrayList<RandomParticle> parts = new ArrayList();
    int lastvalue = 0;

    public void init() {
        this.scene.setResource(new v3d());
        this.scene.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                SuperRandomEvoke.this.randomize();
            }
        });
    }

    protected void randomize() {
        this.s = ((v3d)this.scene.getResource()).getScene();
        List<NodeIF> meshes = this.s.rootnode.getChilds(1);
        this.parts.clear();
        System.out.println(meshes.size());
        for (NodeIF nodeIF : meshes) {
            int num = (int)((float)Math.random() * (float)this.num.getValue() * 2.0f);
            for (int i = 0; i < num; ++i) {
                Object m = (Object)nodeIF;
                RandomParticle p = new RandomParticle();
                this.parts.add(p);
                p.setObj(m);
                m.pos.set(0.0f, 0.0f, 0.0f);
            }
        }
        Collections.sort(this.parts, new Comparator<RandomParticle>(){

            @Override
            public int compare(RandomParticle o1, RandomParticle o2) {
                return o1.getObj().meshes.get((int)0).materialIDs.get((int)0).x - o2.getObj().meshes.get((int)0).materialIDs.get((int)0).x;
            }
        });
    }

    public void render() {
        if (this.randomize.getValue() != this.lastvalue) {
            this.lastvalue = this.randomize.getValue();
            this.randomize();
        }
        GL11.glLoadIdentity();
        GL11.glClearColor(0.14509805f, 0.17254902f, 0.3372549f, 1.0f);
        GL11.glClearDepth(1.0E8);
        GL11.glClear(256);
        if (this.background.getValue()) {
            GL11.glClear(16384);
        }
        GL11.glDisable(2929);
        if (this.fov.getValue() > 0.1f) {
            GL11.glMatrixMode(5889);
            GL11.glLoadIdentity();
            GLU.gluPerspective(this.fov.getValue() * 220.0f, 1.7777778f, 0.02f, 2000.0f);
            GL11.glMatrixMode(5888);
            GL11.glLoadIdentity();
            int camv = this.cam.getValue();
            if (camv == 0) {
                GLU.gluLookAt(0.0f, -114.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f);
            } else if (camv == 1) {
                GLU.gluLookAt(0.0f, -114.0f, 0.0f, 1.0f, 1.0f, 51.0f, 0.0f, 1.0f, 0.0f);
            } else if (camv == 2) {
                GLU.gluLookAt(-50.0f, -114.0f, 0.0f, 31.0f, 31.0f, 51.0f, 0.0f, 1.0f, 0.0f);
            }
        } else {
            GL11.glLoadIdentity();
            GL11.glTranslatef(0.0f, -114.0f, 0.0f);
            GL11.glRotatef(270.0f, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(45.0f, 0.0f, 1.0f, 0.0f);
        }
        this.scale = this.size.getValue() * 1.3f + 0.02f;
        GL11.glScalef(this.scale, this.scale, this.scale);
        if (this.s == null) {
            return;
        }
        float t = frt.getTime();
        int count = 0;
        for (RandomParticle p : this.parts) {
            GL11.glPushMatrix();
            if ((double)(++count) % 3.0 == 0.0) {
                GL11.glRotatef((float)(-Math.sin(Project.getProject().getTime())), 0.0f, 0.0f, 1.0f);
            }
            if (this.colorize.getValue() == 0) {
                p.getObj().meshes.get((int)0).materials.get((int)0).settings.setDiffuse(this.color_1);
            } else if (this.colorize.getValue() == 1) {
                p.getObj().meshes.get((int)0).materials.get((int)0).settings.setDiffuse(this.color_2);
            } else if (this.colorize.getValue() == 2) {
                p.getObj().meshes.get((int)0).materials.get((int)0).settings.setDiffuse(this.color_3);
            }
            if (this.myactive.getValue() != 0) {
                p.render(t, this.space.getValue());
            }
            GL11.glPopMatrix();
        }
        if (RandomParticle.lastmaterial != null) {
            RandomParticle.lastmaterial.unbind();
        }
        GL11.glEnable(2929);
    }

    public String getAuthor() {
        return "tom";
    }

    public float getVersion() {
        return 0.0f;
    }

    public String getName() {
        return "cube";
    }

    public void saveXML(Element root) {
    }

    public void loadXML(Element root) {
    }
}

