/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.shaderExample;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.w3c.dom.Element;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyframedFloat;
import sumo.keyframing.KeyframedResource;
import sumo.opengl.common;
import sumo.plugin.Plugin;
import sumo.project.Project;
import sumo.resource.types.ShaderVertex;
import sumo.resource.types.shaderFragment;
import sumo.resource.types.textureFile;
import sumo.v3d.ShaderProgram;

public class ShaderExample
extends Plugin {
    public KeyframedResource image;
    private textureFile currenTexture = null;
    public KeyframedFloat radius;
    public KeyframedFloat centerx;
    public KeyframedFloat centery;
    ShaderProgram shader;

    public void init() {
        this.image.setResource(new textureFile());
        this.image.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                ShaderExample.this.currenTexture = (textureFile)ShaderExample.this.image.getResource();
            }
        });
    }

    public void render() {
        if (this.shader == null) {
            this.shader = new ShaderProgram();
            ShaderVertex shVertex = new ShaderVertex();
            shaderFragment shFragment = new shaderFragment();
            shVertex.setPath(Project.getProject().getShaderDir());
            shFragment.setPath(Project.getProject().getShaderDir());
            shVertex.setFilename("shaderExample.vs");
            shFragment.setFilename("shaderExample.fs");
            shVertex.load();
            shFragment.load();
            this.shader.changeShader(shFragment.shader);
            this.shader.changeShader(shVertex.shader);
            common.checkGLError((String)"- error while initializing materialrenderershaderthing!!!!!!!!...");
            this.shader.bind();
            this.shader.setMultiTexture(0, this.currenTexture.getID(), "map");
            this.shader.unbind();
        }
        this.shader.bind();
        this.shader.setUniform1f(this.shader.setUniformLocation("radius"), this.radius.getValue() * (float)this.currenTexture.width * 2.0f);
        this.shader.setUniform1f(this.shader.setUniformLocation("centerx"), this.centerx.getValue() * (float)this.currenTexture.width);
        this.shader.setUniform1f(this.shader.setUniformLocation("centery"), this.centery.getValue() * (float)this.currenTexture.height);
        common.switchTo2d();
        int y2 = Project.getProject().getOpenGLSsettings().getHeight();
        boolean y1 = false;
        GL11.glEnable(34037);
        GL13.glActiveTexture(33984);
        ((textureFile)this.image.getResource()).bind();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex2f(0.0f, (float)y1);
        GL11.glTexCoord2f(0.0f, 1.0f * (float)((textureFile)this.image.getResource()).height);
        GL11.glVertex2f(0.0f, y2);
        GL11.glTexCoord2f(1.0f * (float)((textureFile)this.image.getResource()).width, 1.0f * (float)((textureFile)this.image.getResource()).height);
        GL11.glVertex2f(Project.getProject().getOpenGLSsettings().getWidth(), y2);
        GL11.glTexCoord2f(1.0f * (float)((textureFile)this.image.getResource()).width, 0.0f);
        GL11.glVertex2f(Project.getProject().getOpenGLSsettings().getWidth(), (float)y1);
        GL11.glEnd();
        common.switchTo3d();
        this.shader.unbind();
    }

    public String getAuthor() {
        return "tom";
    }

    public float getVersion() {
        return 0.0f;
    }

    public String getName() {
        return "cube";
    }

    private void drawCube() {
        GL11.glBegin(7);
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(0.0f, 0.0f);
        }
        GL11.glVertex3f(1.0f, 1.0f, -1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(0.0f, 1.0f * (float)this.currenTexture.height);
        }
        GL11.glVertex3f(-1.0f, 1.0f, -1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(1.0f * (float)this.currenTexture.width, 1.0f * (float)this.currenTexture.height);
        }
        GL11.glVertex3f(-1.0f, 1.0f, 1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(1.0f * (float)this.currenTexture.width, 0.0f);
        }
        GL11.glVertex3f(1.0f, 1.0f, 1.0f);
        if (this.currenTexture == null) {
            GL11.glColor3f(1.0f, 0.5f, 0.0f);
        }
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(0.0f, 0.0f);
        }
        GL11.glVertex3f(1.0f, -1.0f, 1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(0.0f, 1.0f * (float)this.currenTexture.height);
        }
        GL11.glVertex3f(-1.0f, -1.0f, 1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(1.0f * (float)this.currenTexture.width, 1.0f * (float)this.currenTexture.height);
        }
        GL11.glVertex3f(-1.0f, -1.0f, -1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(1.0f * (float)this.currenTexture.width, 0.0f);
        }
        GL11.glVertex3f(1.0f, -1.0f, -1.0f);
        if (this.currenTexture == null) {
            GL11.glColor3f(1.0f, 0.0f, 0.0f);
        }
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(0.0f, 0.0f);
        }
        GL11.glVertex3f(1.0f, 1.0f, 1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(0.0f, 1.0f * (float)this.currenTexture.height);
        }
        GL11.glVertex3f(-1.0f, 1.0f, 1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(1.0f * (float)this.currenTexture.width, 1.0f * (float)this.currenTexture.height);
        }
        GL11.glVertex3f(-1.0f, -1.0f, 1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(1.0f * (float)this.currenTexture.width, 0.0f);
        }
        GL11.glVertex3f(1.0f, -1.0f, 1.0f);
        if (this.currenTexture == null) {
            GL11.glColor3f(1.0f, 1.0f, 0.0f);
        }
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(0.0f, 0.0f);
        }
        GL11.glVertex3f(1.0f, -1.0f, -1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(0.0f, 1.0f * (float)this.currenTexture.height);
        }
        GL11.glVertex3f(-1.0f, -1.0f, -1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(1.0f * (float)this.currenTexture.width, 1.0f * (float)this.currenTexture.height);
        }
        GL11.glVertex3f(-1.0f, 1.0f, -1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(1.0f * (float)this.currenTexture.width, 0.0f);
        }
        GL11.glVertex3f(1.0f, 1.0f, -1.0f);
        if (this.currenTexture == null) {
            GL11.glColor3f(0.0f, 0.0f, 1.0f);
        }
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(0.0f, 0.0f);
        }
        GL11.glVertex3f(-1.0f, 1.0f, 1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(0.0f, 1.0f * (float)this.currenTexture.height);
        }
        GL11.glVertex3f(-1.0f, 1.0f, -1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(1.0f * (float)this.currenTexture.width, 1.0f * (float)this.currenTexture.height);
        }
        GL11.glVertex3f(-1.0f, -1.0f, -1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(1.0f * (float)this.currenTexture.width, 0.0f);
        }
        GL11.glVertex3f(-1.0f, -1.0f, 1.0f);
        if (this.currenTexture == null) {
            GL11.glColor3f(1.0f, 0.0f, 1.0f);
        }
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(0.0f, 0.0f);
        }
        GL11.glVertex3f(1.0f, 1.0f, -1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(0.0f, 1.0f * (float)this.currenTexture.height);
        }
        GL11.glVertex3f(1.0f, 1.0f, 1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(1.0f * (float)this.currenTexture.width, 1.0f * (float)this.currenTexture.height);
        }
        GL11.glVertex3f(1.0f, -1.0f, 1.0f);
        if (this.currenTexture != null) {
            GL11.glTexCoord2f(1.0f * (float)this.currenTexture.width, 0.0f);
        }
        GL11.glVertex3f(1.0f, -1.0f, -1.0f);
        GL11.glEnd();
    }

    public void saveXML(Element root) {
    }

    public void loadXML(Element root) {
    }
}

