/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugin;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.w3c.dom.Element;
import sumo.gui.AbstractLine;
import sumo.gui.detail.Elements.PluginButton;
import sumo.keyframing.KeyFramedBase;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyframedBoolean;
import sumo.keyframing.KeyframedFloat;
import sumo.keyframing.KeyframedInt;
import sumo.keyframing.KeyframedResource;
import sumo.plugin.PluginConfig;
import sumo.plugin.PluginIF;
import sumo.project.Project;
import sumo.util.Log;
import sumoTween.Tweener;
import sumoTween.TweenerXML;
import sumoTween.easing.Cubic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Plugin
implements PluginIF {
    private PluginConfig config;
    static int guiIdCounter = 0;
    boolean isMinimized = false;
    boolean isVisible = true;
    ArrayList<PluginButton> pluginButtons = new ArrayList();
    private int renderFrameBuffer = -1;
    int guiID = 0;
    ArrayList<Object> vars = new ArrayList();
    AbstractLine abstractLine = null;

    @Override
    public void setConfig(PluginConfig config) {
        this.config = config;
    }

    @Override
    public PluginConfig getConfig() {
        return this.config;
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @Override
    public abstract float getVersion();

    @Override
    public abstract String getAuthor();

    @Override
    public abstract void render();

    @Override
    public abstract void init();

    @Override
    public abstract void saveXML(Element var1);

    @Override
    public abstract void loadXML(Element var1);

    @Override
    public void setPlugKeys(String fieldname, boolean keyframed, Object keys, int i) {
    }

    @Override
    public void setResource(String title, String filename, String path) {
    }

    @Override
    public void setValue(String title, boolean booleanvalue) {
    }

    @Override
    public int getID() {
        return this.guiID;
    }

    @Override
    public void initVariables() {
        this.guiID = ++guiIdCounter;
        Field[] publicFields = this.getClass().getFields();
        System.out.println("found variable fields:" + publicFields.length);
        for (int i = 0; i < publicFields.length; ++i) {
            Object f;
            System.out.println("  new " + publicFields[i].getType().toString().replaceFirst("class ", "") + ": " + publicFields[i].getName());
            if (publicFields[i].getType().toString().replaceFirst("class ", "").contains("weener")) {
                try {
                    f = new Tweener(new Cubic());
                    ((Tweener)f).setKeyframed(false);
                    ((Tweener)f).setTimer(Project.getProject().getTimer());
                    publicFields[i].set(this, f);
                    ((Tweener)f).setName(publicFields[i].getName());
                    this.addVariable(f);
                    ((Tweener)f).set(0.0f, 0.5f);
                }
                catch (Exception e) {
                    Log.error(e);
                }
            }
            if (publicFields[i].getType().toString().replaceFirst("class ", "").contains(KeyframedInt.classSimpleName)) {
                try {
                    f = new KeyframedInt();
                    ((KeyFramedBase)f).setKeyframingEnabled(true);
                    publicFields[i].set(this, f);
                    ((KeyframedInt)f).setName(publicFields[i].getName());
                    this.addVariable(f);
                }
                catch (Exception e) {
                    Log.error(e);
                }
            }
            if (publicFields[i].getType().toString().replaceFirst("class ", "").contains(KeyframedBoolean.classSimpleName)) {
                try {
                    f = new KeyframedBoolean();
                    ((KeyFramedBase)f).setKeyframingEnabled(true);
                    publicFields[i].set(this, f);
                    ((KeyframedBoolean)f).setName(publicFields[i].getName());
                    this.addVariable(f);
                }
                catch (Exception e) {
                    Log.error(e);
                }
            }
            if (!publicFields[i].getType().toString().replaceFirst("class ", "").contains(KeyframedResource.classSimpleName)) continue;
            try {
                f = new KeyframedResource();
                ((KeyFramedBase)f).setKeyframingEnabled(false);
                publicFields[i].set(this, f);
                ((KeyframedResource)f).setName(publicFields[i].getName());
                this.addVariable(f);
                continue;
            }
            catch (Exception e) {
                Log.error(e);
            }
        }
    }

    @Override
    public boolean isMinimized() {
        return this.isMinimized;
    }

    @Override
    public void setMinimized(boolean m) {
        this.isMinimized = m;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    @Override
    public int getFrameBuffer() {
        return this.renderFrameBuffer;
    }

    @Override
    public void setFrameBuffer(int i) {
        this.renderFrameBuffer = i;
    }

    public void addVariable(Object v) {
        this.vars.add(v);
    }

    @Override
    public void replaceVariable(Object kf, Tweener tween) {
        for (int i = 0; i < this.vars.size(); ++i) {
            if (!this.vars.get(i).equals(kf)) continue;
            this.vars.set(i, tween);
        }
    }

    @Override
    public Object getVariable(String title) {
        for (int i = 0; i < this.vars.size(); ++i) {
            Object o = this.vars.get(i);
            if (!(o instanceof KeyframedFloat || o instanceof KeyframedInt || o instanceof KeyframedBoolean || o instanceof KeyframedResource ? ((KeyFramedIF)this.vars.get(i)).getName().equals(title) : o instanceof Tweener && ((Tweener)this.vars.get(i)).getName().equals(title))) continue;
            return this.vars.get(i);
        }
        return null;
    }

    @Override
    public void save(Element root) {
        Element xmlPlug = root.getOwnerDocument().createElement("plugin");
        xmlPlug.setAttribute("class", this.getConfig().getClassName());
        xmlPlug.setAttribute("visible", String.valueOf(this.isVisible()));
        xmlPlug.setAttribute("minimized", String.valueOf(this.isMinimized()));
        xmlPlug.setAttribute("framebuffer", String.valueOf(this.getFrameBuffer()));
        for (int i = 0; i < this.vars.size(); ++i) {
            Object o = this.vars.get(i);
            if (o instanceof Tweener) {
                Element el = TweenerXML.toXML(xmlPlug, (Tweener)o);
                ((Element)el.getFirstChild()).setAttribute("height", String.valueOf(this.getAbstractLine().drawableLine.getLineHeight()));
                xmlPlug.appendChild(el);
                continue;
            }
            if (o instanceof KeyframedBoolean) {
                ((KeyframedBoolean)o).save(xmlPlug);
                continue;
            }
            if (!(o instanceof KeyframedResource)) continue;
            ((KeyframedResource)o).save(xmlPlug);
        }
        root.appendChild(xmlPlug);
        Element xmlPlugExtra = root.getOwnerDocument().createElement("pluginsettings");
        this.saveXML(xmlPlugExtra);
        xmlPlug.appendChild(xmlPlugExtra);
    }

    @Override
    public void setAbstractLine(AbstractLine newline) {
        this.abstractLine = newline;
    }

    @Override
    public AbstractLine getAbstractLine() {
        return this.abstractLine;
    }

    @Override
    public String getSubTitle() {
        return null;
    }

    @Override
    public void addPluginButton(PluginButton but) {
        this.pluginButtons.add(but);
    }

    @Override
    public ArrayList<PluginButton> getPluginButtons() {
        return this.pluginButtons;
    }
}

