/*
 * Decompiled with CFR 0.152.
 */
package sumo.opengl;

import java.util.ArrayList;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import sumo.opengl.OpenGLSettings;
import sumo.opengl.common;
import sumo.project.SceneIF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLWindow {
    static DisplayMode[] modes;
    DisplayMode mode;
    int screenWidth = 0;
    int screenHeight = 0;
    public String infotxt = "";
    private String title = null;
    int frames = 0;
    int fps = -1;
    long fpsstart;
    OpenGLSettings settings;
    boolean fboinited = false;
    public boolean playing = true;

    private void init(DisplayMode mode) {
        try {
            Display.setDisplayMode(mode);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (mode == null) {
            System.out.println("nMODE NULL!!!!!!!!!");
        }
        this.screenWidth = mode.getWidth();
        this.screenHeight = mode.getHeight();
    }

    public GLWindow(DisplayMode m, OpenGLSettings settings) {
        System.out.println(m.getWidth() + "x" + m.getHeight() + "!!!");
        this.settings = settings;
        this.init(m);
    }

    public boolean renderScene(SceneIF s) {
        return this.renderScene(s, true);
    }

    public boolean renderScene(SceneIF s, boolean updateDisplay) {
        Display.processMessages();
        if (Display.isCloseRequested()) {
            System.out.println("display close requested...");
            return false;
        }
        if (!this.playing) {
            return false;
        }
        if (Keyboard.isKeyDown(1)) {
            System.out.println("escape...");
            return false;
        }
        common.glInit(this.mode.getWidth(), this.mode.getHeight());
        GL11.glClearDepth(1110.0);
        GL11.glClear(16640);
        GL11.glEnable(2929);
        GL11.glDisable(3042);
        GL11.glDisable(3553);
        GL11.glLoadIdentity();
        s.render();
        if (updateDisplay) {
            Display.update();
        }
        return true;
    }

    public void open() {
        if (this.title == null) {
            this.title = Display.getDisplayMode().getWidth() + "x" + Display.getDisplayMode().getHeight() + " " + Display.getDisplayMode().getBitsPerPixel() + "bpp ";
            Display.setTitle(this.title);
        }
        try {
            Display.setVSyncEnabled(this.settings.getVsynch());
            Display.create(new PixelFormat(this.settings.getBpp(), 8, 8, 8, this.settings.getMultisampling()));
            this.mode = GLWindow.findDisplayMode(this.screenWidth, this.screenHeight, 32, this.settings.getFrequency());
            if (this.mode == null) {
                System.out.println("no displaymode found");
                System.exit(1);
            }
            common.glInit(this.screenWidth, this.screenHeight);
            Display.setFullscreen(this.settings.isFullScreen());
            Keyboard.create();
            System.out.println("Display version: " + Display.getVersion());
            System.out.println("Display adapter: " + Display.getAdapter());
            Display.setTitle(this.title);
        }
        catch (Exception e) {
            System.out.println("exeption: " + e);
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            Display.destroy();
        }
        catch (Exception e) {
            System.out.println("exeption: " + e);
            e.printStackTrace();
        }
    }

    public static DisplayMode findDisplayMode(int width, int height, int bpp, int hz) {
        try {
            modes = Display.getAvailableDisplayModes();
            Display.setTitle("demo");
            for (int i = 0; i < modes.length; ++i) {
                if (modes[i].getWidth() != width || modes[i].getHeight() != height || modes[i].getBitsPerPixel() < bpp || modes[i].getFrequency() != hz) continue;
                System.out.println(modes[i].getWidth() + " " + modes[i].getHeight());
                try {
                    Display.setDisplayMode(modes[i]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return modes[i];
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return null;
    }

    public static ArrayList<DisplayMode> getDisplayModes() {
        ArrayList<DisplayMode> modez = new ArrayList<DisplayMode>();
        try {
            modes = Display.getAvailableDisplayModes();
            for (int i = 0; i < modes.length; ++i) {
                if (modes[i].getBitsPerPixel() != 32) continue;
                modez.add(modes[i]);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return modez;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        Display.setTitle(title);
    }

    public void showInfo() {
        ++this.frames;
        if (Sys.getTime() > this.fpsstart + 1000L) {
            this.fpsstart = Sys.getTime();
            this.fps = this.frames;
            this.frames = 0;
            System.out.println(this.fps + " fps");
        }
    }
}

