/*
 * Decompiled with CFR 0.152.
 */
package sumo.opengl;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import sumo.app.guitest;
import sumo.opengl.AWTGLPanel;
import sumo.opengl.OpenGLSettings;
import sumo.project.Project;
import sumo.util.Log;

public class AWTGLWindow
extends JFrame {
    public AWTGLPanel glPanel;
    JPanel p;
    OpenGLSettings settings;
    Rectangle oldBounds = new Rectangle();

    public void updateResize() {
        System.out.println(this.getWidth());
        System.out.println(this.glPanel.getSettings().getWidth());
        System.out.println(this.glPanel.getSettings().getHeight());
        int h = (int)((float)this.getWidth() * 0.5625f);
        if (this.getHeight() < h) {
            int w = (int)((float)this.getHeight() / ((float)this.glPanel.getSettings().getHeight() / (float)this.glPanel.getSettings().getWidth()));
            this.createGlPanel(w, this.getHeight());
            this.glPanel.setBounds((this.getWidth() - w) / 2, 0, w, this.getHeight());
        } else {
            this.createGlPanel(this.getWidth(), h);
            this.glPanel.setBounds(0, (this.getHeight() - h) / 2, this.getWidth(), h);
        }
        this.p.setBounds(0, 0, this.getWidth(), this.getHeight());
        System.out.println("windowpanel :" + this.glPanel.getSize().width + " x " + this.glPanel.getSize().height);
    }

    public AWTGLWindow() {
        this.setSize(640, 480);
        this.setLayout(null);
        this.p = new JPanel();
        this.p.setLayout(null);
        this.p.setBackground(Color.DARK_GRAY);
        this.p.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.createGlPanel(640, 300);
        this.glPanel.setFocusable(true);
        this.glPanel.setBounds(0, 0, this.glPanel.getSettings().getWidth(), this.glPanel.getSettings().getHeight());
        this.glPanel.setScene(Project.getProject().getCurrentScene());
        this.p.add(this.glPanel);
        this.add(this.p);
        this.setUndecorated(false);
        this.updateResize();
        this.setVisible(true);
        this.glPanel.requestFocus();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                AWTGLWindow.this.updateResize();
            }
        });
        this.setDefaultCloseOperation(0);
    }

    private void createGlPanel(int w, int h) {
        try {
            this.p.removeAll();
            this.glPanel = null;
            this.settings = new OpenGLSettings();
            this.settings.setWidth(w);
            this.settings.setHeight(h);
            this.settings.sharedContext = guitest.glPanel;
            this.glPanel = new AWTGLPanel(this.settings, true);
            this.glPanel.setScene(Project.getProject().getCurrentScene());
            this.p.add(this.glPanel);
            this.glPanel.requestFocus();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.error("creating awt gl panel", e);
        }
        this.glPanel.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    if (!AWTGLWindow.this.isUndecorated()) {
                        AWTGLWindow.this.oldBounds = AWTGLWindow.this.getBounds();
                        AWTGLWindow.this.removeNotify();
                        AWTGLWindow.this.setUndecorated(true);
                        AWTGLWindow.this.addNotify();
                    } else {
                        AWTGLWindow.this.removeNotify();
                        AWTGLWindow.this.setUndecorated(false);
                        AWTGLWindow.this.addNotify();
                    }
                }
            }
        });
    }

    public boolean repaintGL() {
        if (this.glPanel != null) {
            this.glPanel.repaint();
            return true;
        }
        return false;
    }

    public void setFullscreen() {
    }
}

