/*
 * Decompiled with CFR 0.152.
 */
package sumo.keyframing;

import java.util.ArrayList;
import java.util.Comparator;
import sumo.keyframing.KeyFloat;
import sumo.keyframing.KeyFramedBase;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyIF;
import sumo.project.Project;
import sumo.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyframedFloat
extends KeyFramedBase
implements KeyFramedIF {
    public static String classSimpleName = "KeyframedFloat";
    private String name = "";
    private int currentkey = 0;
    private KeyFloat[] keyframes = null;
    public float timelength = 0.0f;
    short defaultInterpolation = 0;
    private boolean allowInterpolationChange = true;
    int loc = -1;
    KeyIF defaultKey = new KeyFloat(0.0f, 0.0f, this.defaultInterpolation, this);
    boolean disabled = false;

    @Override
    public void setDefaultKey(KeyIF k) {
        this.defaultKey = k;
    }

    @Override
    public KeyIF getDefaultKey() {
        return this.defaultKey;
    }

    @Override
    public String getClassSimpleName() {
        return classSimpleName;
    }

    @Override
    public short getDefaultInterpolationMode() {
        return this.defaultInterpolation;
    }

    @Override
    public void setDefaultInterpolationMode(short m) {
        this.defaultInterpolation = m;
    }

    @Override
    public boolean isAllowInterpolationChange() {
        return this.allowInterpolationChange;
    }

    @Override
    public void setAllowInterpolationChange(boolean allowInterpolationChange) {
        this.allowInterpolationChange = allowInterpolationChange;
    }

    public KeyframedFloat() {
        this.clear();
    }

    public KeyframedFloat(String name) {
        this.name = name;
        this.clear();
    }

    @Override
    public void addKey(float t, Object v) {
        this.change(t, (Float)v);
    }

    @Override
    public void insertKey(KeyIF k) {
        this.change(k.getTime(), Float.valueOf(((KeyFloat)k).getValue()));
        if (this.getKey(k.getTime()) != null) {
            this.getKey(k.getTime()).setModeIn(k.getModeIn());
            this.getKey(k.getTime()).setModeOut(k.getModeOut());
        }
    }

    public KeyIF getKey(float time) {
        for (int i = 0; i < this.keyframes.length; ++i) {
            if (this.keyframes[i].time != time) continue;
            return this.keyframes[i];
        }
        return null;
    }

    @Override
    public void removeAt(float f) {
        this.move(f, 9999999.0f);
        this.keyframes = (KeyFloat[])Arrays.resizeArray(this.keyframes, this.keyframes.length - 1);
        if (this.keyframes.length == 0) {
            this.change(0.0f, Float.valueOf(0.0f));
        }
    }

    @Override
    public void move(float t, float t2) {
        for (int i = 0; i < this.keyframes.length; ++i) {
            if (t != this.keyframes[i].getTime()) continue;
            this.keyframes[i].setTime(t2);
            break;
        }
        this.sortKeys();
    }

    public void sortKeys() {
        java.util.Arrays.sort(this.keyframes, new Comparator<KeyFloat>(){

            @Override
            public int compare(KeyFloat a, KeyFloat b) {
                if (a.getTime() > b.getTime()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public KeyIF[] getKeys() {
        return this.keyframes;
    }

    public void setValue(float f) {
        this.change(Project.getProject().getTime(), Float.valueOf(f));
        this.notifyKeysChanged(this);
    }

    public void setValue(float time, float f) {
        this.change(time, Float.valueOf(f));
        this.notifyKeysChanged(this);
    }

    public void change(KeyFloat f) {
        this.change(f.getTime(), Float.valueOf(f.getValue()));
        this.notifyKeysChanged(this);
    }

    public void change(float time, Object v) {
        float value = ((Float)v).floatValue();
        this.notifyKeysChanged(this);
        if (!this.isKeyframed) {
            this.keyframes[0].setValue(value);
        } else {
            if (time > this.timelength) {
                this.timelength = time;
            }
            if (this.keyframes != null) {
                int which = this.keyframes.length;
                boolean alldone = false;
                for (int i = 0; i < this.keyframes.length; ++i) {
                    if (this.keyframes[i].getTime() == time) {
                        this.keyframes[i].setValue(value);
                        alldone = true;
                    }
                    if (!(time < this.keyframes[i].getTime())) continue;
                    which = i;
                }
                if (!alldone) {
                    this.keyframes = (KeyFloat[])Arrays.resizeArray(this.keyframes, this.keyframes.length + 1);
                    this.keyframes[this.keyframes.length - 1] = new KeyFloat(time, value, this.defaultInterpolation, this);
                }
                this.sortKeys();
            } else {
                Arrays.resizeArray(this.keyframes, 1);
                this.keyframes[0] = new KeyFloat(time, value, this.defaultInterpolation, this);
                this.keyframes[0].setModeIn((short)0);
                this.keyframes[0].setModeOut((short)0);
                this.sortKeys();
            }
        }
    }

    public float getNextValue() {
        if (this.currentkey + 1 > this.keyframes.length - 1) {
            return this.keyframes[this.currentkey].getValue();
        }
        return this.keyframes[this.currentkey + 1].getValue();
    }

    public float getPercent(float time) {
        if (this.currentkey == this.keyframes.length - 1) {
            return 0.0f;
        }
        float val = (time - this.keyframes[this.currentkey].getTime()) / (this.keyframes[this.currentkey + 1].getTime() - this.keyframes[this.currentkey].getTime());
        return val;
    }

    public float getValue() {
        return this.getValue(Project.getProject().getTime());
    }

    public float getValue(float time) {
        if (this.disabled) {
            return 0.0f;
        }
        if (!this.isKeyframed) {
            return this.keyframes[0].getValue();
        }
        int which = 0;
        for (int i = 0; i < this.keyframes.length; ++i) {
            if (!(this.keyframes[i].getTime() <= time)) continue;
            which = i;
            this.currentkey = i;
        }
        if (which == -1 || which == this.keyframes.length - 1) {
            this.currentkey = this.keyframes.length - 1;
            return this.keyframes[this.keyframes.length - 1].value;
        }
        int next = which + 1;
        float val = (time - this.keyframes[which].time) / (this.keyframes[next].time - this.keyframes[which].time);
        if (this.keyframes[which].getModeOut() == 1) {
            return this.keyframes[which].getValue();
        }
        val = this.keyframes[which].value + val * (this.keyframes[next].value - this.keyframes[which].value);
        return val;
    }

    public float smoothStep(float x) {
        return x * x * (2.0f - 1.0f * x);
    }

    public KeyFloat get(int which) {
        return this.keyframes[which];
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void deleteKeys(ArrayList<KeyIF> markedKeys) {
        this.disabled = true;
        boolean found = true;
        while (found) {
            found = false;
            for (int i = this.keyframes.length - 1; i >= 0; --i) {
                if (!markedKeys.contains(this.keyframes[i])) continue;
                found = true;
                this.removeAt(this.keyframes[i].getTime());
            }
        }
        this.disabled = false;
    }

    @Override
    public void clear() {
        this.keyframes = new KeyFloat[1];
        this.keyframes[0] = new KeyFloat(this.defaultKey.getTime(), ((KeyFloat)this.defaultKey).getValue(), this.defaultInterpolation, this);
        this.notifyKeysChanged(this);
    }

    @Override
    public void invokeChangeListener() {
        this.notifyKeysChanged(this);
    }

    public boolean isFinished() {
        return this.currentkey == this.keyframes.length - 1;
    }

    public void print() {
        for (int i = 0; i < this.keyframes.length; ++i) {
            System.out.println(this.keyframes[i].time + ": " + this.keyframes[i].value);
        }
    }
}

