/*
 * Decompiled with CFR 0.152.
 */
package sumo.input.midi;

import java.io.PrintStream;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import sumo.input.midi.MidiController;

public class MidiReceiver
implements Receiver {
    public static long seByteCount = 0L;
    public static long smByteCount = 0L;
    public static long seCount = 0L;
    public static long smCount = 0L;
    private static final String[] sm_astrKeyNames = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    private static final String[] sm_astrKeySignatures = new String[]{"Cb", "Gb", "Db", "Ab", "Eb", "Bb", "F", "C", "G", "D", "A", "E", "B", "F#", "C#"};
    private static final String[] SYSTEM_MESSAGE_TEXT = new String[]{"System Exclusive (should not be in ShortMessage!)", "MTC Quarter Frame: ", "Song Position: ", "Song Select: ", "Undefined", "Undefined", "Tune Request", "End of SysEx (should not be in ShortMessage!)", "Timing clock", "Undefined", "Start", "Continue", "Stop", "Undefined", "Active Sensing", "System Reset"};
    private static final String[] QUARTER_FRAME_MESSAGE_TEXT = new String[]{"frame count LS: ", "frame count MS: ", "seconds count LS: ", "seconds count MS: ", "minutes count LS: ", "minutes count MS: ", "hours count LS: ", "hours count MS: "};
    private static final String[] FRAME_TYPE_TEXT = new String[]{"24 frames/second", "25 frames/second", "30 frames/second (drop)", "30 frames/second (non-drop)"};
    private PrintStream m_printStream;
    private boolean m_bDebug;
    private boolean m_bPrintTimeStampAsTicks;
    MidiController midiController;
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public MidiReceiver(PrintStream printStream, MidiController c) {
        this(printStream, false);
        this.midiController = c;
    }

    public MidiReceiver(PrintStream printStream, boolean bPrintTimeStampAsTicks) {
        this.m_printStream = printStream;
        this.m_bDebug = false;
        this.m_bPrintTimeStampAsTicks = bPrintTimeStampAsTicks;
    }

    public void close() {
    }

    public void send(MidiMessage message, long lTimeStamp) {
        String strMessage = null;
        strMessage = message instanceof ShortMessage ? this.decodeMessage((ShortMessage)message) : (message instanceof SysexMessage ? this.decodeMessage((SysexMessage)message) : (message instanceof MetaMessage ? this.decodeMessage((MetaMessage)message) : "unknown message type"));
        String strTimeStamp = null;
        strTimeStamp = this.m_bPrintTimeStampAsTicks ? "tick " + lTimeStamp + ": " : (lTimeStamp == -1L ? "timestamp [unknown]: " : "timestamp " + lTimeStamp + " us: ");
    }

    public String decodeMessage(ShortMessage message) {
        String strMessage = null;
        switch (message.getCommand()) {
            case 128: {
                strMessage = "note Off " + MidiReceiver.getKeyName(message.getData1()) + " velocity: " + message.getData2();
                break;
            }
            case 144: {
                strMessage = "note On " + MidiReceiver.getKeyName(message.getData1()) + " velocity: " + message.getData2();
                break;
            }
            case 160: {
                strMessage = "polyphonic key pressure " + MidiReceiver.getKeyName(message.getData1()) + " pressure: " + message.getData2();
                break;
            }
            case 176: {
                strMessage = "control change " + message.getData1() + " value: " + message.getData2();
                this.midiController.addMidiEvent(message.getData1(), message.getData2());
                break;
            }
            case 192: {
                strMessage = "program change " + message.getData1();
                break;
            }
            case 208: {
                strMessage = "key pressure " + MidiReceiver.getKeyName(message.getData1()) + " pressure: " + message.getData2();
                break;
            }
            case 224: {
                strMessage = "pitch wheel change " + MidiReceiver.get14bitValue(message.getData1(), message.getData2());
                break;
            }
            case 240: {
                strMessage = SYSTEM_MESSAGE_TEXT[message.getChannel()];
                switch (message.getChannel()) {
                    case 1: {
                        int nQType = (message.getData1() & 0x70) >> 4;
                        int nQData = message.getData1() & 0xF;
                        if (nQType == 7) {
                            nQData &= 1;
                        }
                        strMessage = strMessage + QUARTER_FRAME_MESSAGE_TEXT[nQType] + nQData;
                        if (nQType != 7) break;
                        int nFrameType = (message.getData1() & 6) >> 1;
                        strMessage = strMessage + ", frame type: " + FRAME_TYPE_TEXT[nFrameType];
                        break;
                    }
                    case 2: {
                        strMessage = strMessage + MidiReceiver.get14bitValue(message.getData1(), message.getData2());
                        break;
                    }
                    case 3: {
                        strMessage = strMessage + message.getData1();
                    }
                }
                break;
            }
            default: {
                strMessage = "unknown message: status = " + message.getStatus() + ", byte1 = " + message.getData1() + ", byte2 = " + message.getData2();
            }
        }
        if (message.getCommand() != 240) {
            int nChannel = message.getChannel() + 1;
            String strChannel = "channel " + nChannel + ": ";
            strMessage = strChannel + strMessage;
        }
        ++smCount;
        smByteCount += (long)message.getLength();
        return "[" + MidiReceiver.getHexString(message) + "] " + strMessage;
    }

    public String decodeMessage(SysexMessage message) {
        byte[] abData = message.getData();
        String strMessage = null;
        if (message.getStatus() == 240) {
            strMessage = "Sysex message: F0" + MidiReceiver.getHexString(abData);
        } else if (message.getStatus() == 247) {
            strMessage = "Continued Sysex message F7" + MidiReceiver.getHexString(abData);
            --seByteCount;
        }
        seByteCount += (long)(abData.length + 1);
        ++seCount;
        return strMessage;
    }

    public String decodeMessage(MetaMessage message) {
        byte[] abMessage = message.getMessage();
        byte[] abData = message.getData();
        int nDataLength = message.getLength();
        String strMessage = null;
        switch (message.getType()) {
            case 0: {
                int nSequenceNumber = (abData[0] & 0xFF) << 8 | abData[1] & 0xFF;
                strMessage = "Sequence Number: " + nSequenceNumber;
                break;
            }
            case 1: {
                String strText = new String(abData);
                strMessage = "Text Event: " + strText;
                break;
            }
            case 2: {
                String strCopyrightText = new String(abData);
                strMessage = "Copyright Notice: " + strCopyrightText;
                break;
            }
            case 3: {
                String strTrackName = new String(abData);
                strMessage = "Sequence/Track Name: " + strTrackName;
                break;
            }
            case 4: {
                String strInstrumentName = new String(abData);
                strMessage = "Instrument Name: " + strInstrumentName;
                break;
            }
            case 5: {
                String strLyrics = new String(abData);
                strMessage = "Lyric: " + strLyrics;
                break;
            }
            case 6: {
                String strMarkerText = new String(abData);
                strMessage = "Marker: " + strMarkerText;
                break;
            }
            case 7: {
                String strCuePointText = new String(abData);
                strMessage = "Cue Point: " + strCuePointText;
                break;
            }
            case 32: {
                int nChannelPrefix = abData[0] & 0xFF;
                strMessage = "MIDI Channel Prefix: " + nChannelPrefix;
                break;
            }
            case 47: {
                strMessage = "End of Track";
                break;
            }
            case 81: {
                int nTempo = (abData[0] & 0xFF) << 16 | (abData[1] & 0xFF) << 8 | abData[2] & 0xFF;
                float bpm = MidiReceiver.convertTempo(nTempo);
                bpm = (float)Math.round(bpm * 100.0f) / 100.0f;
                strMessage = "Set Tempo: " + bpm + " bpm";
                break;
            }
            case 84: {
                strMessage = "SMTPE Offset: " + (abData[0] & 0xFF) + ":" + (abData[1] & 0xFF) + ":" + (abData[2] & 0xFF) + "." + (abData[3] & 0xFF) + "." + (abData[4] & 0xFF);
                break;
            }
            case 88: {
                strMessage = "Time Signature: " + (abData[0] & 0xFF) + "/" + (1 << (abData[1] & 0xFF)) + ", MIDI clocks per metronome tick: " + (abData[2] & 0xFF) + ", 1/32 per 24 MIDI clocks: " + (abData[3] & 0xFF);
                break;
            }
            case 89: {
                String strGender = abData[1] == 1 ? "minor" : "major";
                strMessage = "Key Signature: " + sm_astrKeySignatures[abData[0] + 7] + " " + strGender;
                break;
            }
            case 127: {
                String strDataDump = MidiReceiver.getHexString(abData);
                strMessage = "Sequencer-Specific Meta event: " + strDataDump;
                break;
            }
            default: {
                String strUnknownDump = MidiReceiver.getHexString(abData);
                strMessage = "unknown Meta event: " + strUnknownDump;
            }
        }
        return strMessage;
    }

    public static String getKeyName(int nKeyNumber) {
        if (nKeyNumber > 127) {
            return "illegal value";
        }
        int nNote = nKeyNumber % 12;
        int nOctave = nKeyNumber / 12;
        return sm_astrKeyNames[nNote] + (nOctave - 1);
    }

    public static int get14bitValue(int nLowerPart, int nHigherPart) {
        return nLowerPart & 0x7F | (nHigherPart & 0x7F) << 7;
    }

    private static int signedByteToUnsigned(byte b) {
        return b & 0xFF;
    }

    private static float convertTempo(float value) {
        if (value <= 0.0f) {
            value = 0.1f;
        }
        return 6.0E7f / value;
    }

    public static String getHexString(byte[] aByte) {
        StringBuffer sbuf = new StringBuffer(aByte.length * 3 + 2);
        for (int i = 0; i < aByte.length; ++i) {
            sbuf.append(' ');
            sbuf.append(hexDigits[(aByte[i] & 0xF0) >> 4]);
            sbuf.append(hexDigits[aByte[i] & 0xF]);
        }
        return new String(sbuf);
    }

    private static String intToHex(int i) {
        return "" + hexDigits[(i & 0xF0) >> 4] + hexDigits[i & 0xF];
    }

    public static String getHexString(ShortMessage sm) {
        int status = sm.getStatus();
        String res = MidiReceiver.intToHex(sm.getStatus());
        switch (status) {
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return res;
            }
        }
        res = res + ' ' + MidiReceiver.intToHex(sm.getData1());
        switch (status) {
            case 241: 
            case 243: {
                return res;
            }
        }
        switch (sm.getCommand()) {
            case 192: 
            case 208: {
                return res;
            }
        }
        res = res + ' ' + MidiReceiver.intToHex(sm.getData2());
        return res;
    }
}

