/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.timing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import sumo.app.guitest;
import sumo.gui.Icons;
import sumo.gui.ScenePanel;
import sumo.gui.Settings;
import sumo.gui.debug.guiDebugData;
import sumo.gui.debug.guiStopWatch;
import sumo.math.vec2f;
import sumo.math.vec2i;
import sumo.project.Project;

public class TimingPanel
extends JPanel {
    ScenePanel sp;
    private ArrayList<vec2f> timeAreas = new ArrayList();
    private int currentMouseButton = -1;
    vec2i mousePos = new vec2i();
    boolean isDragged = false;
    private boolean mouseOver = false;
    guiStopWatch watch = null;

    public TimingPanel() {
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                TimingPanel.this.repaint();
            }

            public void mouseEntered(MouseEvent e) {
                TimingPanel.this.mouseOver = true;
                TimingPanel.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                TimingPanel.this.mouseOver = false;
                TimingPanel.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
                TimingPanel.this.currentMouseButton = e.getButton();
            }

            public void mouseReleased(MouseEvent e) {
                if (TimingPanel.this.isDragged) {
                    TimingPanel.this.isDragged = false;
                }
                if (TimingPanel.this.currentMouseButton == 3) {
                    // empty if block
                }
                TimingPanel.this.sp.repaintTimings(true);
                TimingPanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                if (TimingPanel.this.currentMouseButton == 1) {
                    Project.getProject().setTime(TimingPanel.this.sp.getTimeFromPixelScreen(e.getX()));
                    guitest.glPanel.repaint();
                    TimingPanel.this.sp.repaintTimings(false);
                    TimingPanel.this.repaint();
                } else if (TimingPanel.this.currentMouseButton == 3) {
                    TimingPanel.this.isDragged = true;
                }
            }

            public void mouseMoved(MouseEvent e) {
                if (!TimingPanel.this.isDragged) {
                    TimingPanel.this.mousePos.set(e.getX(), e.getY());
                    TimingPanel.this.repaint();
                }
            }
        });
    }

    public void paint(Graphics gd) {
        if (guiDebugData.debug) {
            this.watch = new guiStopWatch(guiDebugData.STOP_TIMINGPANEL);
        }
        gd.setFont(Settings.smallfont);
        gd.setColor(Settings.lineBackground);
        gd.fillRect(0, 0, gd.getClipBounds().width, gd.getClipBounds().height);
        gd.setColor(Color.yellow);
        for (vec2f ta : this.timeAreas) {
            gd.fillRect(this.sp.getTimeInPixelsScreen(ta.getX()), 0, this.sp.getTimeInPixelsScreen(ta.getY()) - this.sp.getTimeInPixelsScreen(ta.getX()), this.getHeight());
        }
        gd.setColor(Settings.borderColor);
        int x = 0;
        for (int i = 0; i <= Project.getProject().getLength(); ++i) {
            x = this.sp.getTimeInPixelsScreen(i);
            if (x <= 0 || x >= this.getWidth()) continue;
            gd.drawLine(x, 0, x, gd.getClipBounds().height / 2 - 3);
            gd.drawString("" + i, x - 3, gd.getClipBounds().height / 2 + 9);
        }
        gd.setColor(Settings.timing_cursor);
        x = this.sp.getTimeInPixelsScreen(Project.getProject().getTime());
        gd.drawLine(x, 0, x, this.getHeight());
        Icons.drawIcon(gd, Icons.ICON_TIME_CURSOR, x - 11, -4);
        this.paintComponents(gd);
        if (Project.getProject().debugGUI) {
            gd.setFont(Settings.smallfont);
            gd.setColor(Color.blue);
            gd.drawString(this.getClass().getName(), 10, 15);
        }
        if (guiDebugData.debug) {
            this.watch.stop();
        }
    }

    public void setScenePanel(ScenePanel scenePanel) {
        this.sp = scenePanel;
    }

    public void clearTimeAreas() {
        this.timeAreas.clear();
    }

    public void addTimeArea(vec2f area) {
        this.timeAreas.add(area);
    }
}

