/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.lineTypeElements;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JPanel;
import sumo.gui.AbstractLine;
import sumo.gui.Button;
import sumo.gui.Icons;
import sumo.gui.ScenePanel;
import sumo.gui.Settings;
import sumo.gui.detail.keyframeable.FloatDetail;
import sumo.gui.lineTypeElements.ValueChangedListener;
import sumo.gui.lineTypeElements.ValueEvent;
import sumo.gui.lineTypeElements.guiLineTypeIF;
import sumo.gui.timing.KeyFramePanel;
import sumo.gui.timing.KeyFramePanelIF;
import sumo.project.Project;
import sumoTween.Tweener;
import sumoTween.events.TweenEvent;

public class guiInt
extends JPanel
implements guiLineTypeIF {
    private KeyFramePanel keyframepanel;
    boolean enabledisable = false;
    int value = 0;
    private Vector<ValueChangedListener> valueChangedListeners = new Vector();
    Tweener tweener;
    private boolean setDetail = true;
    Button btInc;
    Button btDec;
    Color bgColor = Settings.windowBackground;
    AbstractLine abstractLine = null;

    public guiInt(Tweener f) {
        this(f, true);
    }

    public guiInt(Tweener f, boolean _setDetail) {
        this.setDetail = _setDetail;
        this.init();
        f.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                if (guiInt.this.keyframepanel != null) {
                    guiInt.this.keyframepanel.setkeys(guiInt.this.tweener);
                    guiInt.this.keyframepanel.repaint();
                }
            }

            public void finished() {
            }
        });
        this.tweener = f;
        this.setLayout(null);
        this.btInc = new Button(Icons.ICON_KEY_NEXT, "+");
        this.btInc.setBounds(90, 0, 15, 15);
        this.add(this.btInc);
        this.btDec = new Button(Icons.ICON_KEY_PREVIOUS, "-");
        this.btDec.setBounds(0, 0, 15, 15);
        this.add(this.btDec);
        this.btInc.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                guiInt.this.tweener.set(Project.getProject().getTime(), guiInt.this.tweener.getValue() + 1.0f, 3);
                guiInt.this.repaint();
            }
        });
        this.btDec.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                guiInt.this.tweener.set(Project.getProject().getTime(), guiInt.this.tweener.getValue() - 1.0f, 3);
                guiInt.this.repaint();
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (guiInt.this.setDetail) {
                    Project.getProject().setDetailPanel(new FloatDetail(guiInt.this.tweener, guiInt.this.abstractLine));
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public guiInt() {
        this.init();
    }

    void init() {
        this.setBounds(new Rectangle(103, 16));
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    public void paint(Graphics g) {
        if (this.tweener != null) {
            this.value = this.tweener.getIntValue();
        }
        Graphics2D gd = (Graphics2D)g;
        gd.setColor(Settings.lineBackground);
        gd.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.tweener.isEnabled()) {
            gd.setColor(Settings.pluginTitleBackground);
            gd.fillRoundRect(18, 0, 70, this.getHeight() - 3, 7, 7);
            gd.setColor(Color.black);
            gd.setFont(Settings.smallfont);
            gd.drawString("" + this.tweener.getIntValue() + this.tweener.getTitleValue(), 25, 10);
            gd.setColor(Color.WHITE);
            gd.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            this.paintComponents(gd);
        }
    }

    private void notifyValueChangedListeners() {
        ValueEvent e = new ValueEvent(this, this.value);
        for (int x = 0; x < this.valueChangedListeners.size(); ++x) {
            ValueChangedListener target = this.valueChangedListeners.elementAt(x);
            target.valueChanged(e);
        }
    }

    public Tweener getTheInt() {
        return this.tweener;
    }

    public void setTheFloat(Tweener i) {
        this.tweener = i;
    }

    public void addValueChangedListener(ValueChangedListener l) {
        if (this.valueChangedListeners.contains(l)) {
            return;
        }
        this.valueChangedListeners.addElement(l);
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.tweener.set(Project.getProject().getTime(), value, 3);
    }

    public Component getComponent() {
        return this;
    }

    public boolean isKeyframeAble() {
        return true;
    }

    public boolean isKeyFramed() {
        return this.tweener.isKeyframed();
    }

    public void setIsKeyFramed(boolean b) {
        this.tweener.setKeyframed(b);
        this.notifyValueChangedListeners();
    }

    public void setKeyframePanel(KeyFramePanelIF kf) {
        this.keyframepanel = (KeyFramePanel)kf;
        this.keyframepanel.setkeys(this.tweener);
    }

    public Tweener getKeyframed() {
        return null;
    }

    public KeyFramePanelIF getKeyFramePanel(ScenePanel p) {
        if (this.keyframepanel == null) {
            this.keyframepanel = new KeyFramePanel(p);
        }
        return this.keyframepanel;
    }

    public void setAbstractLine(AbstractLine al) {
        this.abstractLine = al;
    }

    public boolean getEnableDisableSwitch() {
        return this.enabledisable;
    }

    public void setEnableDisableSwitch(boolean enabledisable) {
        this.enabledisable = enabledisable;
    }
}

