/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.detail;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JList;
import sumo.app.guitest;
import sumo.gui.Icons;
import sumo.gui.detail.DetailEmpty;
import sumo.gui.detail.DetailIF;
import sumo.gui.detail.Elements.Area;
import sumo.gui.detail.Elements.DetailButton;
import sumo.gui.detail.ShaderDetailPart;
import sumo.gui.dialogs.StringDialog;
import sumo.gui.dialogs.shaderWindow;
import sumo.project.Project;
import sumo.resource.types.sShader;
import sumo.shader.ShaderListener;
import sumo.shader.ShaderPartProgram;

public class ShaderDetail
extends DetailEmpty
implements DetailIF {
    sShader shader;
    JList jl;
    JComboBox c;
    DetailButton code;
    DetailButton name;
    DetailButton brecompile;
    Area areaShaderBuild;
    ArrayList<ShaderDetailPart> parts = new ArrayList();

    public void dispose() {
    }

    private String getProjectButtonName() {
        return "Sumoshader: ";
    }

    public ShaderDetail(sShader sc) {
        this.setTitle(this, "shader: " + sc.getTitle());
        this.shader = sc;
        this.shader.getSumoShader().addShaderListener(new ShaderListener(){

            public void recompiled() {
                if (!ShaderDetail.this.shader.getSumoShader().getCompilerOutput().toLowerCase().contains("error")) {
                    ShaderDetail.this.code.setTitle("shader compiled");
                    ShaderDetail.this.code.setIcon(Icons.ICON_BOX_CHECK);
                } else {
                    ShaderDetail.this.code.setTitle("shader compile error");
                    ShaderDetail.this.code.setIcon(Icons.ICON_BOX_X);
                }
            }
        });
        this.setLayout(null);
        this.setSize(300, 300);
        Area shaderInfo = new Area("shader info", this, Area.LAYOUT_TWO);
        this.code = new DetailButton(Icons.ICON_BOX, "show source");
        shaderInfo.addLine(this.code);
        this.name = new DetailButton(-1, "name: " + this.shader.filename);
        shaderInfo.addLine(this.name);
        this.brecompile = new DetailButton(this.shader.getSumoShader().getAutoRecompile() ? Icons.ICON_REFRESH_AUTO : Icons.ICON_REFRESH, "auto recompile");
        shaderInfo.addLine(this.brecompile);
        this.addArea(shaderInfo);
        this.brecompile.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (ShaderDetail.this.brecompile.getIcon() == Icons.ICON_REFRESH) {
                    ShaderDetail.this.brecompile.setIcon(Icons.ICON_REFRESH_AUTO);
                    ShaderDetail.this.shader.getSumoShader().setAutoRecompile(true);
                } else {
                    ShaderDetail.this.brecompile.setIcon(Icons.ICON_REFRESH);
                    ShaderDetail.this.shader.getSumoShader().setAutoRecompile(false);
                }
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.name.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                StringDialog d = new StringDialog(null, "rename", ShaderDetail.this.shader.filename);
                if (d.getValue() != null) {
                    ShaderDetail.this.shader.setFilename(d.getValue());
                    Project.getProject().setDetailPanel(new ShaderDetail(ShaderDetail.this.shader));
                    guitest.updateResources();
                }
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.code.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                shaderWindow w = new shaderWindow(ShaderDetail.this.shader);
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.areaShaderBuild = new Area("compose shader", this, Area.LAYOUT_FREE);
        this.areaShaderBuild.setLayout(null);
        this.c = new JComboBox();
        this.c.addItem("add shaderpart...");
        this.c.setBounds(10, 25, 280, 20);
        File dir = new File("shader/parts/");
        String[] children = dir.list();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (children[i].endsWith(".xml")) {
                    this.c.addItem("" + children[i].substring(0, children[i].length() - 4));
                }
                String filename = children[i];
            }
        }
        this.areaShaderBuild.add(this.c);
        this.areaShaderBuild.setAreaHeight(100);
        this.addArea(this.areaShaderBuild);
        this.c.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (ShaderDetail.this.c.getSelectedIndex() > 0 && !e.getItem().toString().startsWith("add")) {
                    ShaderDetail.this.code.setTitle("compiling...");
                    ShaderDetail.this.shader.getSumoShader().addPart(e.getItem().toString());
                    ShaderDetail.this.c.setSelectedIndex(0);
                    ShaderDetail.this.shader.recompile();
                    ShaderDetail.this.rebuildParts();
                }
            }
        });
        this.rebuildParts();
    }

    void rebuildParts() {
        int posy = 50;
        for (ShaderDetailPart part : this.parts) {
            this.areaShaderBuild.remove(part);
        }
        this.parts.clear();
        for (ShaderPartProgram prog : this.shader.getSumoShader().getProgramms()) {
            ShaderDetailPart p = new ShaderDetailPart(prog, this);
            p.setPos(10, posy + 1);
            this.parts.add(p);
            this.areaShaderBuild.add(p);
            posy += p.getHeight() + 1;
        }
        this.areaShaderBuild.setAreaHeight(posy + 45);
        this.areaShaderBuild.repaint();
        this.areaShaderBuild.updateUI();
    }

    private String getProjectTimerString() {
        return "timing: " + Project.getProject().getTimer().getTitle();
    }

    private String getProjectLengthString() {
        return "length: " + Project.getProject().getLength() + "s";
    }
}

