/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;
import sumo.gui.Settings;
import sumo.gui.debug.guiDebugData;
import sumo.gui.debug.guiStopWatch;

public class StatusBar
extends JPanel {
    private int fps = 0;
    private String mem = "";
    private String text = "";
    guiStopWatch watch = null;

    public void paint(Graphics g) {
        if (guiDebugData.debug) {
            this.watch = new guiStopWatch(guiDebugData.STOP_STATUSBAR);
        }
        g.setFont(Settings.font);
        g.setColor(Settings.lineTitleColor);
        g.fillRect(-3, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.white);
        g.drawString(this.text, 20, this.getHeight() / 2 - 1);
        g.drawString(this.fps + " fps", this.getWidth() - 60, this.getHeight() / 2 - 1);
        g.drawString(this.mem + " mb", this.getWidth() - 160, this.getHeight() / 2 - 1);
        if (guiDebugData.debug) {
            this.watch.stop();
        }
    }

    public void setFPS(int fps) {
        this.fps = fps;
        this.mem = String.valueOf((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L) + " / " + String.valueOf(Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        this.repaint();
    }

    public void setText(String valueOf) {
        this.text = valueOf;
        this.repaint();
    }
}

