/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui;

import java.awt.Color;
import java.awt.Font;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.app.main;

public class Settings {
    public static final Color timing_cursor = new Color(0x616161);
    public static final Color lineBackground = new Color(0xDDDDDD);
    public static final Color lineTitleBackground = new Color(0xCCCCCC);
    public static final Color lineBackgroundOver = new Color(0xEEEEEE);
    public static final Color lineTitleBackgroundOver = new Color(0xBBBBBB);
    public static final Color lineTitleColor = new Color(0x666666);
    public static final Color iconBackground = new Color(0xCCCCCC);
    public static final Color windowBackground = lineBackground;
    public static Color pluginTitleBackground = new Color(0xAAAAAA);
    public static Color pluginTitleColor = new Color(0xFFFFFF);
    public static Color mainColor1 = new Color(3582207);
    public static Color mainColor2 = new Color(16725709);
    public static Color mainColor1a = new Color(2587321);
    public static final Color[] sceneColors = new Color[]{pluginTitleBackground, new Color(0xFFA0A0), new Color(10529279), new Color(10546431), new Color(10551209), new Color(16752883), new Color(16776864), new Color(16765856)};
    public static final Font verybigfont = new Font("Arial", 1, 16);
    public static final Font bigfont = new Font("Arial", 1, 11);
    public static final Font smallfont = new Font("Arial", 0, 9);
    public static final Font font = new Font("Arial", 0, 11);
    public static Color borderColor = new Color(0x888888);
    public static Color markedColorBackground = new Color(0xEEEEEE);
    private static String configFilename = "config/settings.xml";
    public static boolean maximizeAtStart = false;
    public static boolean snapToFrames = true;

    public static void saveColor(Element parent, String name, Color c) {
        Element xmlSub = parent.getOwnerDocument().createElement("color");
        xmlSub.setAttribute("name", name);
        xmlSub.setAttribute("r", String.valueOf(c.getRed()));
        xmlSub.setAttribute("g", String.valueOf(c.getGreen()));
        xmlSub.setAttribute("b", String.valueOf(c.getBlue()));
        parent.appendChild(xmlSub);
    }

    public static void saveInt(Element parent, String name, int c) {
        Element xmlSub = parent.getOwnerDocument().createElement("int");
        xmlSub.setAttribute("name", name);
        xmlSub.setAttribute("value", String.valueOf(c));
        parent.appendChild(xmlSub);
    }

    public static void saveSettings() {
        System.out.println("saving settings...");
        try {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("settings");
            Settings.saveColor(root, "maincolor1", mainColor1);
            Settings.saveColor(root, "maincolor1a", mainColor1a);
            Settings.saveColor(root, "maincolor2", mainColor2);
            Settings.saveBoolean(root, "maximizeAtStart", maximizeAtStart);
            Settings.saveInt(root, "layout", main.gui.getSumoLayout());
            doc.appendChild(root);
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
            String xmlString = sw.toString();
            PrintWriter fout = new PrintWriter(new FileWriter(configFilename));
            fout.print(xmlString);
            fout.close();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    private static void saveBoolean(Element root, String s, boolean b) {
        Element xmlMAS = root.getOwnerDocument().createElement(s);
        xmlMAS.setAttribute("value", String.valueOf(b));
        root.appendChild(xmlMAS);
    }

    public static void loadSettings() {
        try {
            int i;
            System.out.println("loading settings...");
            Document doc = null;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(configFilename);
            doc.getDocumentElement().normalize();
            maximizeAtStart = Settings.readBoolean(doc, "maximizeAtStart");
            NodeList xmlResources = doc.getElementsByTagName("color");
            for (i = 0; i < xmlResources.getLength(); ++i) {
                Settings.loadColor((Element)xmlResources.item(i));
            }
            xmlResources = doc.getElementsByTagName("int");
            for (i = 0; i < xmlResources.getLength(); ++i) {
                Settings.loadInt((Element)xmlResources.item(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        main.gui.updateResize();
    }

    private static boolean readBoolean(Document doc, String s) {
        NodeList l = doc.getElementsByTagName(s);
        if (l.getLength() > 0) {
            return Boolean.parseBoolean(((Element)l.item(0)).getAttribute("value"));
        }
        return false;
    }

    private static void loadColor(Element item) {
        int r = Integer.parseInt(item.getAttribute("r"));
        int g = Integer.parseInt(item.getAttribute("g"));
        int b = Integer.parseInt(item.getAttribute("b"));
        if (item.getAttribute("name").equals("maincolor1")) {
            mainColor1 = new Color(r, g, b);
        }
        if (item.getAttribute("name").equals("maincolor1a")) {
            mainColor1a = new Color(r, g, b);
        }
        if (item.getAttribute("name").equals("maincolor2")) {
            mainColor2 = new Color(r, g, b);
        }
    }

    private static void loadInt(Element item) {
        int r = Integer.parseInt(item.getAttribute("value"));
        if (item.getAttribute("name").equals("layout")) {
            main.gui.setSumoLayout(r);
        }
    }
}

