/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import sumo.app.guitest;
import sumo.gui.ScenePanel;
import sumo.gui.Settings;
import sumo.gui.debug.guiDebugData;
import sumo.gui.debug.guiStopWatch;
import sumo.gui.detail.SceneDetail;
import sumo.project.Project;

public class SceneSelectPanel
extends JPanel {
    int mouseX = -1;
    int mouseOverScene = -1;
    int lastScene = -2;
    guiStopWatch watch = null;
    guitest mainWindow;

    public SceneSelectPanel() {
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                if (Project.getProject().getCurrentSceneNum() == SceneSelectPanel.this.mouseOverScene) {
                    return;
                }
                SceneSelectPanel.this.mouseX = e.getX();
                SceneSelectPanel.this.repaint();
                if (SceneSelectPanel.this.lastScene != SceneSelectPanel.this.mouseOverScene) {
                    SceneSelectPanel.this.changeScene(SceneSelectPanel.this.mouseOverScene);
                    if (SceneSelectPanel.this.mouseOverScene != -1) {
                        Project.getProject().setDetailPanel(new SceneDetail(Project.getProject().getScene(SceneSelectPanel.this.mouseOverScene)));
                    }
                }
                SceneSelectPanel.this.lastScene = SceneSelectPanel.this.mouseOverScene;
            }

            public void mouseMoved(MouseEvent e) {
                SceneSelectPanel.this.mouseX = e.getX();
                SceneSelectPanel.this.repaint();
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
                SceneSelectPanel.this.mouseX = -1;
                SceneSelectPanel.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
                if (Project.getProject().getCurrentSceneNum() == SceneSelectPanel.this.mouseOverScene) {
                    return;
                }
                if (SceneSelectPanel.this.lastScene != SceneSelectPanel.this.mouseOverScene) {
                    SceneSelectPanel.this.changeScene(SceneSelectPanel.this.mouseOverScene);
                    if (SceneSelectPanel.this.mouseOverScene != -1) {
                        Project.getProject().setDetailPanel(new SceneDetail(Project.getProject().getScene(SceneSelectPanel.this.mouseOverScene)));
                    }
                }
                SceneSelectPanel.this.lastScene = SceneSelectPanel.this.mouseOverScene;
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public void changeScene(int s) {
        Project.getProject().setCurrentSceneNum(s);
        this.mainWindow.setScenePanel((ScenePanel)Project.getProject().getCurrentScene());
        guitest.scenePanel.updateUI();
        this.mainWindow.repaint();
        this.repaint();
    }

    public void paint(Graphics g) {
        if (guiDebugData.debug) {
            this.watch = new guiStopWatch(guiDebugData.STOP_SCENESELECT);
        }
        int swidth = (int)(((float)this.getWidth() - 5.0f) / 60.0f);
        int h = 36;
        g.setColor(Settings.pluginTitleBackground);
        g.fillRect(0, 0, this.getWidth(), h);
        g.setColor(Settings.lineBackground);
        g.fillRect(0, 0, this.getWidth(), h - 10);
        g.setFont(Settings.smallfont);
        g.setColor(Settings.borderColor);
        g.drawLine(0, h - 11, this.getWidth(), h - 11);
        boolean mouseOver = false;
        this.mouseOverScene = -1;
        for (int i = 0; i < 50; ++i) {
            boolean selected = false;
            int posx = 5 + i * swidth + i * 3;
            if (i == Project.getProject().getCurrentSceneNum()) {
                selected = true;
            }
            mouseOver = this.mouseX > posx && this.mouseX < posx + swidth;
            g.setColor(Settings.sceneColors[Project.getProject().getScene(i).getColor()]);
            if (selected) {
                g.fillRect(posx, 5, swidth, 21);
            } else {
                g.fillRect(posx, 5, swidth, h - 16);
            }
            if (selected) {
                g.setColor(Settings.mainColor1);
                g.fillRect(posx + 2, 6, swidth - 4, h - 23);
            }
            if (mouseOver && Project.getProject().getCurrentSceneNum() != i) {
                g.setColor(Settings.lineBackground);
                g.fillRect(posx + 2, 6, swidth - 4, h - 23);
                this.mouseOverScene = i;
            }
            g.setColor(Color.white);
            for (int j = 0; j < Project.getProject().getScene(i).getNumLayers(); ++j) {
                g.drawLine(posx + 14, j * 2 + 9, posx + 18, j * 2 + 9);
            }
            g.setColor(Color.black);
            g.drawString("" + i, posx + 4, 16);
        }
        if (guiDebugData.debug) {
            this.watch.stop();
        }
    }

    public void setMainwindow(guitest parent) {
        this.mainWindow = parent;
    }
}

