/*
 * Decompiled with CFR 0.152.
 */
package sumo.game;

import org.lwjgl.opengl.GL11;
import sumo.app.gametest;
import sumo.keyframing.KeyframedFloat;
import sumo.project.Project;
import sumo.resource.types.v3d;
import sumo.v3d.NodeIF;
import sumo.v3d.Scene;
import sumo.v3d.math.VEC3Tweened;
import sumo.v3d.mesh.BoundingBoxAA;
import sumo.v3d.mesh.Object;
import sumoTween.KeyFloat;
import sumoTween.easing.Cubic;
import sumoTween.events.KeyEvent;

public class character
implements NodeIF {
    public VEC3Tweened pos = new VEC3Tweened(new Cubic(), gametest.timer);
    public VEC3Tweened lastValidPos = new VEC3Tweened(new Cubic(), gametest.timer);
    KeyframedFloat kfDir = new KeyframedFloat();
    float walkdistance = 1.0f;
    float jumpspeed = 0.25f;
    float fallmul = 0.002f;
    BoundingBoxAA bbox = new BoundingBoxAA();
    float dir = 0.0f;
    Object o;
    boolean jumping = false;
    Scene s;
    Scene anim_jump;
    private int animode = 0;
    public static final int ANIM_WALK = 1;
    public static final int ANIM_JUMP = 2;
    float animstart = 0.0f;
    float animend = 0.0f;

    public void init() {
        this.pos.x.setKeyframed(false);
        this.pos.y.setKeyframed(false);
        this.pos.z.setKeyframed(false);
        this.lastValidPos.setKeyframed(false);
        this.pos.z.set(4.0f);
        this.lastValidPos.z.set(4.0f);
        v3d v = (v3d)Project.getProject().getResourceManager().getResourceByFileName("char_walk.v3d");
        this.s = v.getScene();
        v3d vjump = (v3d)Project.getProject().getResourceManager().getResourceByFileName("char_jump.v3d");
        this.anim_jump = vjump.getScene();
        this.o = (Object)this.s.getMeshesByNameContains("_manim_character").get(0);
        this.bbox.calc(this.o, false);
        this.s.loop = true;
        this.s.shadowed = false;
        this.anim_jump.shadowed = false;
    }

    public void render(float time) {
        GL11.glPushMatrix();
        this.pos.glTranslate(time);
        GL11.glRotatef(this.kfDir.getValue(time), 0.0f, 0.0f, 1.0f);
        if (this.animode == 2 && time < this.animend) {
            this.anim_jump.loop = true;
            this.anim_jump.render(time);
        } else if (this.animode == 1 && time < this.animend) {
            this.s.loop = true;
            this.s.render(time);
        } else {
            this.animode = 0;
            this.s.loop = false;
            this.s.render(time);
        }
        GL11.glPopMatrix();
    }

    public void walky(float time, float walkdir) {
        if (!this.jumping) {
            this.animend = time + 0.2f;
            this.animode = 1;
        }
        float oldv = this.pos.y.getValue(time);
        this.pos.y.clear();
        this.pos.y.add(0.1f, oldv + this.walkdistance * walkdir);
    }

    public void walkx(float time, float walkdir) {
        if (!this.jumping) {
            this.animend = time + 0.2f;
            this.animode = 1;
        }
        float oldv = this.pos.x.getValue(time);
        this.pos.x.clear();
        this.pos.x.add(0.1f, oldv + this.walkdistance * walkdir);
    }

    public void setWalkDir(float time, float i) {
        if (this.dir != i) {
            this.kfDir.clear();
            this.kfDir.setKeyframingEnabled(true);
            this.kfDir.setValue(time, this.dir);
            this.kfDir.setValue(time + 0.3f, i);
            this.dir = i;
        }
    }

    public void useLastValidPos() {
        this.pos.x.clear(this.lastValidPos.x.getValue());
        this.pos.y.clear(this.lastValidPos.y.getValue());
        this.pos.z.clear(this.lastValidPos.z.getValue());
    }

    public void setLastValidPos(VEC3Tweened pos2) {
        this.lastValidPos.x.set(pos2.x.getValue());
        this.lastValidPos.y.set(pos2.y.getValue());
        this.lastValidPos.z.set(pos2.z.getValue());
    }

    public void jump(float time) {
        if (this.pos.z.isAnimFinished()) {
            this.animend = time + this.anim_jump.animLength;
            this.animode = 2;
            this.anim_jump.animStart = time;
            this.jumping = true;
            float nowz = this.pos.z.getValue();
            this.pos.z.setKeyframed(true);
            this.pos.z.add(0.0f, nowz, 1);
            this.pos.z.add(this.jumpspeed, nowz + 100.0f, 0, new KeyEvent(){

                public void KeyEvent(KeyFloat keyFloat) {
                    character.this.jumping = false;
                }
            });
            System.out.println("jump!");
        }
    }

    public void setAutoPosZ(float z) {
        float val = this.pos.z.getValue();
        if (!this.jumping && z != this.pos.z.getLastKey().getValue()) {
            float diff = Math.abs(z - val);
            this.pos.z.clear();
            this.pos.z.add(0.0f, val, 0);
            this.pos.z.add(diff * this.fallmul, z, 1);
        }
    }

    public boolean getEnabled() {
        return true;
    }

    public String getName() {
        return "gamecharacter";
    }

    public int getNodeType() {
        return 1;
    }

    public int getOrder() {
        return 0;
    }

    public void renderChilds(float time) {
    }

    public void setEnabled(boolean b) {
    }

    public void setName(String s) {
    }

    public void setOrder(int o) {
    }
}

