/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PLine;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PSmoothTriangle;
import processing.core.PTriangle;
import processing.core.PVector;

public class PGraphics3D
extends PGraphics {
    public float[] zbuffer;
    public PMatrix3D modelview;
    public PMatrix3D modelviewInv;
    protected boolean sizeChanged;
    public PMatrix3D camera;
    protected PMatrix3D cameraInv;
    public float cameraFOV;
    public float cameraX;
    public float cameraY;
    public float cameraZ;
    public float cameraNear;
    public float cameraFar;
    public float cameraAspect;
    public PMatrix3D projection;
    public static final int MAX_LIGHTS = 8;
    public int lightCount = 0;
    public int[] lightType;
    public PVector[] lightPosition;
    public PVector[] lightNormal;
    public float[] lightFalloffConstant;
    public float[] lightFalloffLinear;
    public float[] lightFalloffQuadratic;
    public float[] lightSpotAngle;
    public float[] lightSpotAngleCos;
    public float[] lightSpotConcentration;
    public float[][] lightDiffuse;
    public float[][] lightSpecular;
    public float[] currentLightSpecular;
    public float currentLightFalloffConstant;
    public float currentLightFalloffLinear;
    public float currentLightFalloffQuadratic;
    public static final int TRI_DIFFUSE_R = 0;
    public static final int TRI_DIFFUSE_G = 1;
    public static final int TRI_DIFFUSE_B = 2;
    public static final int TRI_DIFFUSE_A = 3;
    public static final int TRI_SPECULAR_R = 4;
    public static final int TRI_SPECULAR_G = 5;
    public static final int TRI_SPECULAR_B = 6;
    public static final int TRI_COLOR_COUNT = 7;
    private boolean lightingDependsOnVertexPosition;
    static final int LIGHT_AMBIENT_R = 0;
    static final int LIGHT_AMBIENT_G = 1;
    static final int LIGHT_AMBIENT_B = 2;
    static final int LIGHT_DIFFUSE_R = 3;
    static final int LIGHT_DIFFUSE_G = 4;
    static final int LIGHT_DIFFUSE_B = 5;
    static final int LIGHT_SPECULAR_R = 6;
    static final int LIGHT_SPECULAR_G = 7;
    static final int LIGHT_SPECULAR_B = 8;
    static final int LIGHT_COLOR_COUNT = 9;
    protected float[] tempLightingContribution = new float[9];
    protected PVector lightTriangleNorm = new PVector();
    protected boolean manipulatingCamera;
    float[][] matrixStack = new float[32][16];
    float[][] matrixInvStack = new float[32][16];
    int matrixStackDepth;
    protected PMatrix3D forwardTransform;
    protected PMatrix3D reverseTransform;
    protected float leftScreen;
    protected float rightScreen;
    protected float topScreen;
    protected float bottomScreen;
    protected float nearPlane;
    private boolean frustumMode = false;
    protected static boolean s_enableAccurateTextures = false;
    public PSmoothTriangle smoothTriangle;
    protected int shapeFirst;
    protected int shapeLast;
    protected int shapeLastPlusClipped;
    protected int[] vertexOrder = new int[512];
    protected int pathCount;
    protected int[] pathOffset = new int[64];
    protected int[] pathLength = new int[64];
    protected static final int VERTEX1 = 0;
    protected static final int VERTEX2 = 1;
    protected static final int VERTEX3 = 2;
    protected static final int STROKE_COLOR = 1;
    protected static final int TEXTURE_INDEX = 3;
    protected static final int POINT_FIELD_COUNT = 2;
    protected static final int LINE_FIELD_COUNT = 2;
    protected static final int TRIANGLE_FIELD_COUNT = 4;
    static final int DEFAULT_POINTS = 512;
    protected int[][] points = new int[512][2];
    protected int pointCount;
    static final int DEFAULT_LINES = 512;
    public PLine line;
    protected int[][] lines = new int[512][2];
    protected int lineCount;
    static final int DEFAULT_TRIANGLES = 256;
    public PTriangle triangle;
    protected int[][] triangles = new int[256][4];
    protected float[][][] triangleColors = new float[256][3][7];
    protected int triangleCount;
    static final int DEFAULT_TEXTURES = 3;
    protected PImage[] textures = new PImage[3];
    int textureIndex;
    DirectColorModel cm;
    MemoryImageSource mis;
    float[] worldNormal = new float[4];
    PVector lightPositionVec = new PVector();
    PVector lightDirectionVec = new PVector();

    public void setSize(int iwidth, int iheight) {
        this.width = iwidth;
        this.height = iheight;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
        this.reapplySettings();
        this.lightType = new int[8];
        this.lightPosition = new PVector[8];
        this.lightNormal = new PVector[8];
        int i = 0;
        while (i < 8) {
            this.lightPosition[i] = new PVector();
            this.lightNormal[i] = new PVector();
            ++i;
        }
        this.lightDiffuse = new float[8][3];
        this.lightSpecular = new float[8][3];
        this.lightFalloffConstant = new float[8];
        this.lightFalloffLinear = new float[8];
        this.lightFalloffQuadratic = new float[8];
        this.lightSpotAngle = new float[8];
        this.lightSpotAngleCos = new float[8];
        this.lightSpotConcentration = new float[8];
        this.currentLightSpecular = new float[3];
        this.projection = new PMatrix3D();
        this.modelview = new PMatrix3D();
        this.modelviewInv = new PMatrix3D();
        this.forwardTransform = this.modelview;
        this.reverseTransform = this.modelviewInv;
        this.cameraFOV = 1.0471976f;
        this.cameraX = (float)this.width / 2.0f;
        this.cameraY = (float)this.height / 2.0f;
        this.cameraZ = this.cameraY / (float)Math.tan(this.cameraFOV / 2.0f);
        this.cameraNear = this.cameraZ / 10.0f;
        this.cameraFar = this.cameraZ * 10.0f;
        this.cameraAspect = (float)this.width / (float)this.height;
        this.camera = new PMatrix3D();
        this.cameraInv = new PMatrix3D();
        this.sizeChanged = true;
    }

    protected void allocate() {
        this.pixelCount = this.width * this.height;
        this.pixels = new int[this.pixelCount];
        this.zbuffer = new float[this.pixelCount];
        if (this.primarySurface) {
            this.cm = new DirectColorModel(32, 0xFF0000, 65280, 255);
            this.mis = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
            this.mis.setFullBufferUpdates(true);
            this.mis.setAnimated(true);
            this.image = Toolkit.getDefaultToolkit().createImage(this.mis);
        } else {
            Arrays.fill(this.zbuffer, Float.MAX_VALUE);
        }
        this.line = new PLine(this);
        this.triangle = new PTriangle(this);
        this.smoothTriangle = new PSmoothTriangle(this);
    }

    public void beginDraw() {
        if (!this.settingsInited) {
            this.defaultSettings();
        }
        if (this.sizeChanged) {
            this.camera();
            this.perspective();
            this.sizeChanged = false;
        }
        this.resetMatrix();
        this.vertexCount = 0;
        this.modelview.set(this.camera);
        this.modelviewInv.set(this.cameraInv);
        this.lightCount = 0;
        this.lightingDependsOnVertexPosition = false;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.shapeFirst = 0;
        Arrays.fill(this.textures, null);
        this.textureIndex = 0;
        this.normal(0.0f, 0.0f, 1.0f);
    }

    public void endDraw() {
        if (this.hints[5]) {
            this.flush();
        }
        if (this.mis != null) {
            this.mis.newPixels(this.pixels, (ColorModel)this.cm, 0, this.width);
        }
        this.updatePixels();
    }

    protected void defaultSettings() {
        super.defaultSettings();
        this.manipulatingCamera = false;
        this.forwardTransform = this.modelview;
        this.reverseTransform = this.modelviewInv;
        this.camera();
        this.perspective();
        this.textureMode(2);
        this.emissive(0.0f);
        this.specular(0.5f);
        this.shininess(1.0f);
    }

    public void hint(int which) {
        if (which == -5) {
            this.flush();
        } else if (which == 4 && this.zbuffer != null) {
            Arrays.fill(this.zbuffer, Float.MAX_VALUE);
        }
        super.hint(which);
    }

    public void beginShape(int kind) {
        this.shape = kind;
        if (this.hints[5]) {
            this.shapeFirst = this.vertexCount;
            this.shapeLast = 0;
        } else {
            this.vertexCount = 0;
            if (this.line != null) {
                this.line.reset();
            }
            this.lineCount = 0;
            if (this.triangle != null) {
                this.triangle.reset();
            }
            this.triangleCount = 0;
        }
        this.textureImage = null;
        this.curveVertexCount = 0;
        this.normalMode = 0;
    }

    public void texture(PImage image) {
        this.textureImage = image;
        if (this.textureIndex == this.textures.length - 1) {
            this.textures = (PImage[])PApplet.expand(this.textures);
        }
        if (this.textures[this.textureIndex] != null) {
            ++this.textureIndex;
        }
        this.textures[this.textureIndex] = image;
    }

    public void vertex(float x, float y) {
        this.vertex(x, y, 0.0f);
    }

    public void vertex(float x, float y, float u, float v) {
        this.vertex(x, y, 0.0f, u, v);
    }

    public void endShape(int mode) {
        this.shapeLastPlusClipped = this.shapeLast = this.vertexCount;
        if (this.vertexCount == 0) {
            this.shape = 0;
            return;
        }
        this.endShapeModelToCamera(this.shapeFirst, this.shapeLast);
        if (this.stroke) {
            this.endShapeStroke(mode);
        }
        if (this.fill || this.textureImage != null) {
            this.endShapeFill();
        }
        this.endShapeLighting(this.lightCount > 0 && this.fill);
        this.endShapeCameraToScreen(this.shapeFirst, this.shapeLastPlusClipped);
        if (!this.hints[5]) {
            if ((this.fill || this.textureImage != null) && this.triangleCount > 0) {
                this.renderTriangles(0, this.triangleCount);
                if (this.raw != null) {
                    this.rawTriangles(0, this.triangleCount);
                }
                this.triangleCount = 0;
            }
            if (this.stroke) {
                if (this.pointCount > 0) {
                    this.renderPoints(0, this.pointCount);
                    if (this.raw != null) {
                        this.rawPoints(0, this.pointCount);
                    }
                    this.pointCount = 0;
                }
                if (this.lineCount > 0) {
                    this.renderLines(0, this.lineCount);
                    if (this.raw != null) {
                        this.rawLines(0, this.lineCount);
                    }
                    this.lineCount = 0;
                }
            }
            this.pathCount = 0;
        }
        this.shape = 0;
    }

    protected void endShapeModelToCamera(int start, int stop) {
        int i = start;
        while (i < stop) {
            float[] vertex = this.vertices[i];
            vertex[21] = this.modelview.m00 * vertex[0] + this.modelview.m01 * vertex[1] + this.modelview.m02 * vertex[2] + this.modelview.m03;
            vertex[22] = this.modelview.m10 * vertex[0] + this.modelview.m11 * vertex[1] + this.modelview.m12 * vertex[2] + this.modelview.m13;
            vertex[23] = this.modelview.m20 * vertex[0] + this.modelview.m21 * vertex[1] + this.modelview.m22 * vertex[2] + this.modelview.m23;
            vertex[24] = this.modelview.m30 * vertex[0] + this.modelview.m31 * vertex[1] + this.modelview.m32 * vertex[2] + this.modelview.m33;
            if (vertex[24] != 0.0f && vertex[24] != 1.0f) {
                vertex[21] = vertex[21] / vertex[24];
                vertex[22] = vertex[22] / vertex[24];
                vertex[23] = vertex[23] / vertex[24];
            }
            vertex[24] = 1.0f;
            ++i;
        }
    }

    protected void endShapeStroke(int mode) {
        switch (this.shape) {
            case 2: {
                int stop = this.shapeLast;
                int i = this.shapeFirst;
                while (i < stop) {
                    this.addPoint(i);
                    ++i;
                }
                break;
            }
            case 4: {
                int first = this.lineCount;
                int stop = this.shapeLast - 1;
                if (this.shape != 4) {
                    this.addLineBreak();
                }
                int i = this.shapeFirst;
                while (i < stop) {
                    if (this.shape == 4) {
                        this.addLineBreak();
                    }
                    this.addLine(i, i + 1);
                    i += 2;
                }
                if (mode != 2) break;
                this.addLine(stop, this.lines[first][0]);
                break;
            }
            case 9: {
                int i = this.shapeFirst;
                while (i < this.shapeLast - 2) {
                    this.addLineBreak();
                    this.addLine(i + 0, i + 1);
                    this.addLine(i + 1, i + 2);
                    this.addLine(i + 2, i + 0);
                    i += 3;
                }
                break;
            }
            case 10: {
                int stop = this.shapeLast - 1;
                this.addLineBreak();
                int i = this.shapeFirst;
                while (i < stop) {
                    this.addLine(i, i + 1);
                    ++i;
                }
                stop = this.shapeLast - 2;
                i = this.shapeFirst;
                while (i < stop) {
                    this.addLineBreak();
                    this.addLine(i, i + 2);
                    ++i;
                }
                break;
            }
            case 11: {
                int i = this.shapeFirst + 1;
                while (i < this.shapeLast) {
                    this.addLineBreak();
                    this.addLine(this.shapeFirst, i);
                    ++i;
                }
                this.addLineBreak();
                i = this.shapeFirst + 1;
                while (i < this.shapeLast - 1) {
                    this.addLine(i, i + 1);
                    ++i;
                }
                this.addLine(this.shapeLast - 1, this.shapeFirst + 1);
                break;
            }
            case 16: {
                int i = this.shapeFirst;
                while (i < this.shapeLast) {
                    this.addLineBreak();
                    this.addLine(i + 0, i + 1);
                    this.addLine(i + 1, i + 2);
                    this.addLine(i + 2, i + 3);
                    this.addLine(i + 3, i + 0);
                    i += 4;
                }
                break;
            }
            case 17: {
                int i = this.shapeFirst;
                while (i < this.shapeLast - 3) {
                    this.addLineBreak();
                    this.addLine(i + 0, i + 2);
                    this.addLine(i + 2, i + 3);
                    this.addLine(i + 3, i + 1);
                    this.addLine(i + 1, i + 0);
                    i += 2;
                }
                break;
            }
            case 20: {
                int stop = this.shapeLast - 1;
                this.addLineBreak();
                int i = this.shapeFirst;
                while (i < stop) {
                    this.addLine(i, i + 1);
                    ++i;
                }
                if (mode != 2) break;
                this.addLine(stop, this.shapeFirst);
            }
        }
    }

    protected void endShapeFill() {
        switch (this.shape) {
            case 11: {
                int stop = this.shapeLast - 1;
                int i = this.shapeFirst + 1;
                while (i < stop) {
                    this.addTriangle(this.shapeFirst, i, i + 1);
                    ++i;
                }
                break;
            }
            case 9: {
                int stop = this.shapeLast - 2;
                int i = this.shapeFirst;
                while (i < stop) {
                    if (i % 2 == 0) {
                        this.addTriangle(i, i + 2, i + 1);
                    } else {
                        this.addTriangle(i, i + 1, i + 2);
                    }
                    i += 3;
                }
                break;
            }
            case 10: {
                int stop = this.shapeLast - 2;
                int i = this.shapeFirst;
                while (i < stop) {
                    if (i % 2 == 0) {
                        this.addTriangle(i, i + 2, i + 1);
                    } else {
                        this.addTriangle(i, i + 1, i + 2);
                    }
                    ++i;
                }
                break;
            }
            case 16: {
                int stop = this.vertexCount - 3;
                int i = this.shapeFirst;
                while (i < stop) {
                    this.addTriangle(i, i + 1, i + 2);
                    this.addTriangle(i, i + 2, i + 3);
                    i += 4;
                }
                break;
            }
            case 17: {
                int stop = this.vertexCount - 3;
                int i = this.shapeFirst;
                while (i < stop) {
                    this.addTriangle(i + 0, i + 2, i + 1);
                    this.addTriangle(i + 2, i + 3, i + 1);
                    i += 2;
                }
                break;
            }
            case 20: {
                this.addPolygonTriangles();
            }
        }
    }

    protected void endShapeLighting(boolean lights) {
        if (lights) {
            if (!this.lightingDependsOnVertexPosition && this.normalMode == 1) {
                this.calcLightingContribution(this.shapeFirst, this.tempLightingContribution);
                int tri = 0;
                while (tri < this.triangleCount) {
                    this.lightTriangle(tri, this.tempLightingContribution);
                    ++tri;
                }
            } else {
                int tri = 0;
                while (tri < this.triangleCount) {
                    this.lightTriangle(tri);
                    ++tri;
                }
            }
        } else {
            int tri = 0;
            while (tri < this.triangleCount) {
                int index = this.triangles[tri][0];
                this.copyPrelitVertexColor(tri, index, 0);
                index = this.triangles[tri][1];
                this.copyPrelitVertexColor(tri, index, 1);
                index = this.triangles[tri][2];
                this.copyPrelitVertexColor(tri, index, 2);
                ++tri;
            }
        }
    }

    protected void endShapeCameraToScreen(int start, int stop) {
        int i = start;
        while (i < stop) {
            float[] vx = this.vertices[i];
            float ox = this.projection.m00 * vx[21] + this.projection.m01 * vx[22] + this.projection.m02 * vx[23] + this.projection.m03 * vx[24];
            float oy = this.projection.m10 * vx[21] + this.projection.m11 * vx[22] + this.projection.m12 * vx[23] + this.projection.m13 * vx[24];
            float oz = this.projection.m20 * vx[21] + this.projection.m21 * vx[22] + this.projection.m22 * vx[23] + this.projection.m23 * vx[24];
            float ow = this.projection.m30 * vx[21] + this.projection.m31 * vx[22] + this.projection.m32 * vx[23] + this.projection.m33 * vx[24];
            if (ow != 0.0f && ow != 1.0f) {
                ox /= ow;
                oy /= ow;
                oz /= ow;
            }
            vx[18] = (float)this.width * (1.0f + ox) / 2.0f;
            vx[19] = (float)this.height * (1.0f + oy) / 2.0f;
            vx[20] = (oz + 1.0f) / 2.0f;
            ++i;
        }
    }

    protected void addPoint(int a) {
        if (this.pointCount == this.points.length) {
            int[][] temp = new int[this.pointCount << 1][2];
            System.arraycopy(this.points, 0, temp, 0, this.lineCount);
            this.points = temp;
        }
        this.points[this.pointCount][0] = a;
        this.points[this.pointCount][1] = this.strokeColor;
        ++this.pointCount;
    }

    protected void renderPoints(int start, int stop) {
        if (this.strokeWeight != 1.0f) {
            int i = start;
            while (i < stop) {
                float[] a = this.vertices[this.points[i][0]];
                this.renderLineVertices(a, a);
                ++i;
            }
        } else {
            int i = start;
            while (i < stop) {
                float[] a = this.vertices[this.points[i][0]];
                int sx = (int)(a[18] + 0.4999f);
                int sy = (int)(a[19] + 0.4999f);
                if (sx >= 0 && sx < this.width && sy >= 0 && sy < this.height) {
                    int index = sy * this.width + sx;
                    this.pixels[index] = this.points[i][1];
                    this.zbuffer[index] = a[20];
                }
                ++i;
            }
        }
    }

    protected void rawPoints(int start, int stop) {
        this.raw.colorMode(1, 1.0f);
        this.raw.noFill();
        this.raw.strokeWeight(this.vertices[this.lines[start][0]][17]);
        this.raw.beginShape(2);
        int i = start;
        while (i < stop) {
            float[] a = this.vertices[this.lines[i][0]];
            if (this.raw.is3D()) {
                if (a[24] != 0.0f) {
                    this.raw.stroke(a[13], a[14], a[15], a[16]);
                    this.raw.vertex(a[21] / a[24], a[22] / a[24], a[23] / a[24]);
                }
            } else {
                this.raw.stroke(a[13], a[14], a[15], a[16]);
                this.raw.vertex(a[18], a[19]);
            }
            ++i;
        }
        this.raw.endShape();
    }

    protected final void addLineBreak() {
        if (this.pathCount == this.pathOffset.length) {
            this.pathOffset = PApplet.expand(this.pathOffset);
            this.pathLength = PApplet.expand(this.pathLength);
        }
        this.pathOffset[this.pathCount] = this.lineCount;
        this.pathLength[this.pathCount] = 0;
        ++this.pathCount;
    }

    protected void addLine(int a, int b) {
        this.addLineWithClip(a, b);
    }

    protected final void addLineWithClip(int a, int b) {
        float az = this.vertices[a][23];
        float bz = this.vertices[b][23];
        if (az > this.cameraNear) {
            if (bz > this.cameraNear) {
                return;
            }
            int cb = this.interpolateClipVertex(a, b);
            this.addLineWithoutClip(cb, b);
            return;
        }
        if (bz <= this.cameraNear) {
            this.addLineWithoutClip(a, b);
            return;
        }
        int cb = this.interpolateClipVertex(a, b);
        this.addLineWithoutClip(a, cb);
    }

    protected final void addLineWithoutClip(int a, int b) {
        if (this.lineCount == this.lines.length) {
            int[][] temp = new int[this.lineCount << 1][2];
            System.arraycopy(this.lines, 0, temp, 0, this.lineCount);
            this.lines = temp;
        }
        this.lines[this.lineCount][0] = a;
        this.lines[this.lineCount][1] = b;
        ++this.lineCount;
        int n = this.pathCount - 1;
        this.pathLength[n] = this.pathLength[n] + 1;
    }

    protected void renderLines(int start, int stop) {
        int i = start;
        while (i < stop) {
            this.renderLineVertices(this.vertices[this.lines[i][0]], this.vertices[this.lines[i][1]]);
            ++i;
        }
    }

    protected void renderLineVertices(float[] a, float[] b) {
        if (a[17] > 1.25f || a[17] < 0.75f) {
            float ox1 = a[18];
            float oy1 = a[19];
            float ox2 = b[18];
            float oy2 = b[19];
            float weight = a[17] / 2.0f;
            if (ox1 == ox2 && oy1 == oy2) {
                oy1 -= weight;
                oy2 += weight;
            }
            float dX = ox2 - ox1 + 1.0E-4f;
            float dY = oy2 - oy1 + 1.0E-4f;
            float len = (float)Math.sqrt(dX * dX + dY * dY);
            float rh = weight / len;
            float dx0 = rh * dY;
            float dy0 = rh * dX;
            float dx1 = rh * dY;
            float dy1 = rh * dX;
            float ax1 = ox1 + dx0;
            float ay1 = oy1 - dy0;
            float ax2 = ox1 - dx0;
            float ay2 = oy1 + dy0;
            float bx1 = ox2 + dx1;
            float by1 = oy2 - dy1;
            float bx2 = ox2 - dx1;
            float by2 = oy2 + dy1;
            if (this.smooth) {
                this.smoothTriangle.reset(3);
                this.smoothTriangle.smooth = true;
                this.smoothTriangle.interpARGB = true;
                this.smoothTriangle.setVertices(ax1, ay1, a[20], bx2, by2, b[20], ax2, ay2, a[20]);
                this.smoothTriangle.setIntensities(a[13], a[14], a[15], a[16], b[13], b[14], b[15], b[16], a[13], a[14], a[15], a[16]);
                this.smoothTriangle.render();
                this.smoothTriangle.setVertices(ax1, ay1, a[20], bx2, by2, b[20], bx1, by1, b[20]);
                this.smoothTriangle.setIntensities(a[13], a[14], a[15], a[16], b[13], b[14], b[15], b[16], b[13], b[14], b[15], b[16]);
                this.smoothTriangle.render();
            } else {
                this.triangle.reset();
                this.triangle.setVertices(ax1, ay1, a[20], bx2, by2, b[20], ax2, ay2, a[20]);
                this.triangle.setIntensities(a[13], a[14], a[15], a[16], b[13], b[14], b[15], b[16], a[13], a[14], a[15], a[16]);
                this.triangle.render();
                this.triangle.setVertices(ax1, ay1, a[20], bx2, by2, b[20], bx1, by1, b[20]);
                this.triangle.setIntensities(a[13], a[14], a[15], a[16], b[13], b[14], b[15], b[16], b[13], b[14], b[15], b[16]);
                this.triangle.render();
            }
        } else {
            this.line.reset();
            this.line.setIntensities(a[13], a[14], a[15], a[16], b[13], b[14], b[15], b[16]);
            this.line.setVertices(a[18], a[19], a[20], b[18], b[19], b[20]);
            this.line.draw();
        }
    }

    protected void rawLines(int start, int stop) {
        this.raw.colorMode(1, 1.0f);
        this.raw.noFill();
        this.raw.beginShape(4);
        int i = start;
        while (i < stop) {
            float[] a = this.vertices[this.lines[i][0]];
            float[] b = this.vertices[this.lines[i][1]];
            this.raw.strokeWeight(this.vertices[this.lines[i][1]][17]);
            if (this.raw.is3D()) {
                if (a[24] != 0.0f && b[24] != 0.0f) {
                    this.raw.stroke(a[13], a[14], a[15], a[16]);
                    this.raw.vertex(a[21] / a[24], a[22] / a[24], a[23] / a[24]);
                    this.raw.stroke(b[13], b[14], b[15], b[16]);
                    this.raw.vertex(b[21] / b[24], b[22] / b[24], b[23] / b[24]);
                }
            } else if (this.raw.is2D()) {
                this.raw.stroke(a[13], a[14], a[15], a[16]);
                this.raw.vertex(a[18], a[19]);
                this.raw.stroke(b[13], b[14], b[15], b[16]);
                this.raw.vertex(b[18], b[19]);
            }
            ++i;
        }
        this.raw.endShape();
    }

    protected void addTriangle(int a, int b, int c) {
        this.addTriangleWithClip(a, b, c);
    }

    protected final void addTriangleWithClip(int a, int b, int c) {
        boolean aClipped = false;
        boolean bClipped = false;
        int clippedCount = 0;
        this.cameraNear = -8.0f;
        if (this.vertices[a][23] > this.cameraNear) {
            aClipped = true;
            ++clippedCount;
        }
        if (this.vertices[b][23] > this.cameraNear) {
            bClipped = true;
            ++clippedCount;
        }
        if (this.vertices[c][23] > this.cameraNear) {
            ++clippedCount;
        }
        if (clippedCount == 0) {
            this.addTriangleWithoutClip(a, b, c);
        } else if (clippedCount != 3) {
            if (clippedCount == 2) {
                int cc;
                int cb;
                int ca;
                if (!aClipped) {
                    ca = a;
                    cb = b;
                    cc = c;
                } else if (!bClipped) {
                    ca = b;
                    cb = a;
                    cc = c;
                } else {
                    ca = c;
                    cb = b;
                    cc = a;
                }
                int cd = this.interpolateClipVertex(ca, cb);
                int ce = this.interpolateClipVertex(ca, cc);
                this.addTriangleWithoutClip(ca, cd, ce);
            } else {
                int cc;
                int cb;
                int ca;
                if (aClipped) {
                    ca = c;
                    cb = b;
                    cc = a;
                } else if (bClipped) {
                    ca = a;
                    cb = c;
                    cc = b;
                } else {
                    ca = a;
                    cb = b;
                    cc = c;
                }
                int cd = this.interpolateClipVertex(ca, cc);
                int ce = this.interpolateClipVertex(cb, cc);
                this.addTriangleWithoutClip(ca, cd, cb);
                this.addTriangleWithoutClip(cb, cd, ce);
            }
        }
    }

    protected final int interpolateClipVertex(int a, int b) {
        float[] vb;
        float[] va;
        if (this.vertices[a][23] < this.vertices[b][23]) {
            va = this.vertices[b];
            vb = this.vertices[a];
        } else {
            va = this.vertices[a];
            vb = this.vertices[b];
        }
        float az = va[23];
        float bz = vb[23];
        float dz = az - bz;
        if (dz == 0.0f) {
            return a;
        }
        float pa = (this.cameraNear - bz) / dz;
        float pb = 1.0f - pa;
        this.vertex(pa * va[0] + pb * vb[0], pa * va[1] + pb * vb[1], pa * va[2] + pb * vb[2]);
        int irv = this.vertexCount - 1;
        ++this.shapeLastPlusClipped;
        float[] rv = this.vertices[irv];
        rv[18] = pa * va[18] + pb * vb[18];
        rv[19] = pa * va[19] + pb * vb[19];
        rv[20] = pa * va[20] + pb * vb[20];
        rv[21] = pa * va[21] + pb * vb[21];
        rv[22] = pa * va[22] + pb * vb[22];
        rv[23] = pa * va[23] + pb * vb[23];
        rv[24] = pa * va[24] + pb * vb[24];
        rv[3] = pa * va[3] + pb * vb[3];
        rv[4] = pa * va[4] + pb * vb[4];
        rv[5] = pa * va[5] + pb * vb[5];
        rv[6] = pa * va[6] + pb * vb[6];
        rv[7] = pa * va[7] + pb * vb[7];
        rv[8] = pa * va[8] + pb * vb[8];
        rv[13] = pa * va[13] + pb * vb[13];
        rv[14] = pa * va[14] + pb * vb[14];
        rv[15] = pa * va[15] + pb * vb[15];
        rv[16] = pa * va[16] + pb * vb[16];
        rv[9] = pa * va[9] + pb * vb[9];
        rv[10] = pa * va[10] + pb * vb[10];
        rv[11] = pa * va[11] + pb * vb[11];
        rv[25] = pa * va[25] + pb * vb[25];
        rv[26] = pa * va[26] + pb * vb[26];
        rv[27] = pa * va[27] + pb * vb[27];
        rv[28] = pa * va[28] + pb * vb[28];
        rv[29] = pa * va[29] + pb * vb[29];
        rv[30] = pa * va[30] + pb * vb[30];
        rv[32] = pa * va[32] + pb * vb[32];
        rv[33] = pa * va[33] + pb * vb[33];
        rv[34] = pa * va[34] + pb * vb[34];
        rv[31] = pa * va[31] + pb * vb[31];
        rv[35] = 0.0f;
        return irv;
    }

    protected final void addTriangleWithoutClip(int a, int b, int c) {
        if (this.triangleCount == this.triangles.length) {
            int[][] temp = new int[this.triangleCount << 1][4];
            System.arraycopy(this.triangles, 0, temp, 0, this.triangleCount);
            this.triangles = temp;
            float[][][] ftemp = new float[this.triangleCount << 1][3][7];
            System.arraycopy(this.triangleColors, 0, ftemp, 0, this.triangleCount);
            this.triangleColors = ftemp;
        }
        this.triangles[this.triangleCount][0] = a;
        this.triangles[this.triangleCount][1] = b;
        this.triangles[this.triangleCount][2] = c;
        this.triangles[this.triangleCount][3] = this.textureImage == null ? -1 : this.textureIndex;
        ++this.triangleCount;
    }

    protected void addPolygonTriangles() {
        int i;
        float[] vlast;
        float[] vfirst;
        if (this.vertexOrder.length != this.vertices.length) {
            int[] temp = new int[this.vertices.length];
            PApplet.arrayCopy(this.vertexOrder, temp, this.vertexOrder.length);
            this.vertexOrder = temp;
        }
        int d1 = 0;
        int d2 = 1;
        float area = 0.0f;
        int p = this.shapeLast - 1;
        int q = this.shapeFirst;
        while (q < this.shapeLast) {
            area += this.vertices[q][d1] * this.vertices[p][d2] - this.vertices[p][d1] * this.vertices[q][d2];
            p = q++;
        }
        if (area == 0.0f) {
            boolean foundValidX = false;
            boolean foundValidY = false;
            int i2 = this.shapeFirst;
            while (i2 < this.shapeLast) {
                int j = i2;
                while (j < this.shapeLast) {
                    if (this.vertices[i2][0] != this.vertices[j][0]) {
                        foundValidX = true;
                    }
                    if (this.vertices[i2][1] != this.vertices[j][1]) {
                        foundValidY = true;
                    }
                    ++j;
                }
                ++i2;
            }
            if (foundValidX) {
                d2 = 2;
            } else if (foundValidY) {
                d1 = 1;
                d2 = 2;
            } else {
                return;
            }
            int p2 = this.shapeLast - 1;
            int q2 = this.shapeFirst;
            while (q2 < this.shapeLast) {
                area += this.vertices[q2][d1] * this.vertices[p2][d2] - this.vertices[p2][d1] * this.vertices[q2][d2];
                p2 = q2++;
            }
        }
        if (this.abs((vfirst = this.vertices[this.shapeFirst])[0] - (vlast = this.vertices[this.shapeLast - 1])[0]) < 1.0E-4f && this.abs(vfirst[1] - vlast[1]) < 1.0E-4f && this.abs(vfirst[2] - vlast[2]) < 1.0E-4f) {
            --this.shapeLast;
        }
        int j = 0;
        if (area > 0.0f) {
            i = this.shapeFirst;
            while (i < this.shapeLast) {
                j = i - this.shapeFirst;
                this.vertexOrder[j] = i++;
            }
        } else {
            i = this.shapeFirst;
            while (i < this.shapeLast) {
                j = i - this.shapeFirst;
                this.vertexOrder[j] = this.shapeLast - 1 - j;
                ++i;
            }
        }
        int vc = this.shapeLast - this.shapeFirst;
        int count = 2 * vc;
        int m = 0;
        int v = vc - 1;
        while (vc > 2) {
            double Cx;
            double By;
            double Ay;
            double Cy;
            double Ax;
            double Bx;
            int w;
            boolean snip = true;
            if (count-- <= 0) break;
            int u = v;
            if (vc <= u) {
                u = 0;
            }
            if (vc <= (v = u + 1)) {
                v = 0;
            }
            if (vc <= (w = v + 1)) {
                w = 0;
            }
            if ((double)1.0E-4f > ((Bx = (double)(-10.0f * this.vertices[this.vertexOrder[v]][d1])) - (Ax = (double)(-10.0f * this.vertices[this.vertexOrder[u]][d1]))) * ((Cy = (double)(10.0f * this.vertices[this.vertexOrder[w]][d2])) - (Ay = (double)(10.0f * this.vertices[this.vertexOrder[u]][d2]))) - ((By = (double)(10.0f * this.vertices[this.vertexOrder[v]][d2])) - Ay) * ((Cx = (double)(-10.0f * this.vertices[this.vertexOrder[w]][d1])) - Ax)) continue;
            int p3 = 0;
            while (p3 < vc) {
                if (p3 != u && p3 != v && p3 != w) {
                    double Px = -10.0f * this.vertices[this.vertexOrder[p3]][d1];
                    double Py = 10.0f * this.vertices[this.vertexOrder[p3]][d2];
                    double ax = Cx - Bx;
                    double ay = Cy - By;
                    double bx = Ax - Cx;
                    double by = Ay - Cy;
                    double cx = Bx - Ax;
                    double cy = By - Ay;
                    double apx = Px - Ax;
                    double apy = Py - Ay;
                    double bpx = Px - Bx;
                    double bpy = Py - By;
                    double cpx = Px - Cx;
                    double cpy = Py - Cy;
                    double aCROSSbp = ax * bpy - ay * bpx;
                    double cCROSSap = cx * apy - cy * apx;
                    double bCROSScp = bx * cpy - by * cpx;
                    if (aCROSSbp >= 0.0 && bCROSScp >= 0.0 && cCROSSap >= 0.0) {
                        snip = false;
                    }
                }
                ++p3;
            }
            if (!snip) continue;
            this.addTriangle(this.vertexOrder[u], this.vertexOrder[v], this.vertexOrder[w]);
            ++m;
            int s = v;
            int t = v + 1;
            while (t < vc) {
                this.vertexOrder[s] = this.vertexOrder[t];
                ++s;
                ++t;
            }
            count = 2 * --vc;
        }
    }

    private void toWorldNormal(float nx, float ny, float nz, float[] out) {
        out[0] = this.modelviewInv.m00 * nx + this.modelviewInv.m10 * ny + this.modelviewInv.m20 * nz + this.modelviewInv.m30;
        out[1] = this.modelviewInv.m01 * nx + this.modelviewInv.m11 * ny + this.modelviewInv.m21 * nz + this.modelviewInv.m31;
        out[2] = this.modelviewInv.m02 * nx + this.modelviewInv.m12 * ny + this.modelviewInv.m22 * nz + this.modelviewInv.m32;
        out[3] = this.modelviewInv.m03 * nx + this.modelviewInv.m13 * ny + this.modelviewInv.m23 * nz + this.modelviewInv.m33;
        if (out[3] != 0.0f && out[3] != 1.0f) {
            out[0] = out[0] / out[3];
            out[1] = out[1] / out[3];
            out[2] = out[2] / out[3];
        }
        out[3] = 1.0f;
        float nlen = this.mag(out[0], out[1], out[2]);
        if (nlen != 0.0f && nlen != 1.0f) {
            out[0] = out[0] / nlen;
            out[1] = out[1] / nlen;
            out[2] = out[2] / nlen;
        }
    }

    private void calcLightingContribution(int vIndex, float[] contribution) {
        this.calcLightingContribution(vIndex, contribution, false);
    }

    private void calcLightingContribution(int vIndex, float[] contribution, boolean normalIsWorld) {
        float[] v = this.vertices[vIndex];
        float sr = v[28];
        float sg = v[29];
        float sb = v[30];
        float wx = v[21];
        float wy = v[22];
        float wz = v[23];
        float shine = v[31];
        float nx = v[9];
        float ny = v[10];
        float nz = v[11];
        if (!normalIsWorld) {
            this.toWorldNormal(v[9], v[10], v[11], this.worldNormal);
            nx = this.worldNormal[0];
            ny = this.worldNormal[1];
            nz = this.worldNormal[2];
        } else {
            nx = v[9];
            ny = v[10];
            nz = v[11];
        }
        float dir = this.dot(nx, ny, nz, -wx, -wy, -wz);
        if (dir < 0.0f) {
            nx = -nx;
            ny = -ny;
            nz = -nz;
        }
        contribution[0] = 0.0f;
        contribution[1] = 0.0f;
        contribution[2] = 0.0f;
        contribution[3] = 0.0f;
        contribution[4] = 0.0f;
        contribution[5] = 0.0f;
        contribution[6] = 0.0f;
        contribution[7] = 0.0f;
        contribution[8] = 0.0f;
        int i = 0;
        while (i < this.lightCount) {
            block17: {
                float liz;
                float liy;
                float lix;
                float n_dot_li;
                float spotTerm;
                float denom;
                block19: {
                    float distSq;
                    block20: {
                        float lightDir_dot_li;
                        block18: {
                            block16: {
                                denom = this.lightFalloffConstant[i];
                                spotTerm = 1.0f;
                                if (this.lightType[i] != 0) break block16;
                                if (this.lightFalloffQuadratic[i] != 0.0f || this.lightFalloffLinear[i] != 0.0f) {
                                    float distSq2 = this.mag(this.lightPosition[i].x - wx, this.lightPosition[i].y - wy, this.lightPosition[i].z - wz);
                                    denom += this.lightFalloffQuadratic[i] * distSq2 + this.lightFalloffLinear[i] * this.sqrt(distSq2);
                                }
                                if (denom == 0.0f) {
                                    denom = 1.0f;
                                }
                                contribution[0] = contribution[0] + this.lightDiffuse[i][0] / denom;
                                contribution[1] = contribution[1] + this.lightDiffuse[i][1] / denom;
                                contribution[2] = contribution[2] + this.lightDiffuse[i][2] / denom;
                                break block17;
                            }
                            lightDir_dot_li = 0.0f;
                            n_dot_li = 0.0f;
                            if (this.lightType[i] != 1) break block18;
                            lix = -this.lightNormal[i].x;
                            liy = -this.lightNormal[i].y;
                            liz = -this.lightNormal[i].z;
                            denom = 1.0f;
                            n_dot_li = nx * lix + ny * liy + nz * liz;
                            if (!(n_dot_li <= 0.0f)) break block19;
                            break block17;
                        }
                        lix = this.lightPosition[i].x - wx;
                        liy = this.lightPosition[i].y - wy;
                        liz = this.lightPosition[i].z - wz;
                        distSq = this.mag(lix, liy, liz);
                        if (distSq != 0.0f) {
                            lix /= distSq;
                            liy /= distSq;
                            liz /= distSq;
                        }
                        if ((n_dot_li = nx * lix + ny * liy + nz * liz) <= 0.0f) break block17;
                        if (this.lightType[i] != 3) break block20;
                        lightDir_dot_li = -(this.lightNormal[i].x * lix + this.lightNormal[i].y * liy + this.lightNormal[i].z * liz);
                        if (lightDir_dot_li <= this.lightSpotAngleCos[i]) break block17;
                        spotTerm = (float)Math.pow(lightDir_dot_li, this.lightSpotConcentration[i]);
                    }
                    if (this.lightFalloffQuadratic[i] != 0.0f || this.lightFalloffLinear[i] != 0.0f) {
                        denom += this.lightFalloffQuadratic[i] * distSq + this.lightFalloffLinear[i] * this.sqrt(distSq);
                    }
                }
                if (denom == 0.0f) {
                    denom = 1.0f;
                }
                float mul = n_dot_li * spotTerm / denom;
                contribution[3] = contribution[3] + this.lightDiffuse[i][0] * mul;
                contribution[4] = contribution[4] + this.lightDiffuse[i][1] * mul;
                contribution[5] = contribution[5] + this.lightDiffuse[i][2] * mul;
                if ((sr > 0.0f || sg > 0.0f || sb > 0.0f) && (this.lightSpecular[i][0] > 0.0f || this.lightSpecular[i][1] > 0.0f || this.lightSpecular[i][2] > 0.0f)) {
                    float s_dot_n;
                    float sz;
                    float sy;
                    float sx;
                    float vmag = this.mag(wx, wy, wz);
                    if (vmag != 0.0f) {
                        wx /= vmag;
                        wy /= vmag;
                        wz /= vmag;
                    }
                    if ((vmag = this.mag(sx = lix - wx, sy = liy - wy, sz = liz - wz)) != 0.0f) {
                        sx /= vmag;
                        sy /= vmag;
                        sz /= vmag;
                    }
                    if ((s_dot_n = sx * nx + sy * ny + sz * nz) > 0.0f) {
                        s_dot_n = (float)Math.pow(s_dot_n, shine);
                        mul = s_dot_n * spotTerm / denom;
                        contribution[6] = contribution[6] + this.lightSpecular[i][0] * mul;
                        contribution[7] = contribution[7] + this.lightSpecular[i][1] * mul;
                        contribution[8] = contribution[8] + this.lightSpecular[i][2] * mul;
                    }
                }
            }
            ++i;
        }
    }

    private void applyLightingContribution(int vIndex, float[] contribution) {
        float[] v = this.vertices[vIndex];
        v[3] = this.clamp(v[32] + v[25] * contribution[0] + v[3] * contribution[3]);
        v[4] = this.clamp(v[33] + v[26] * contribution[1] + v[4] * contribution[4]);
        v[5] = this.clamp(v[34] + v[27] * contribution[2] + v[5] * contribution[5]);
        v[6] = this.clamp(v[6]);
        v[28] = this.clamp(v[28] * contribution[6]);
        v[29] = this.clamp(v[29] * contribution[7]);
        v[30] = this.clamp(v[30] * contribution[8]);
        v[35] = 1.0f;
    }

    private void lightVertex(int vIndex, float[] contribution) {
        this.calcLightingContribution(vIndex, contribution);
        this.applyLightingContribution(vIndex, contribution);
    }

    private void lightUnlitVertex(int vIndex, float[] contribution) {
        if (this.vertices[vIndex][35] == 0.0f) {
            this.lightVertex(vIndex, contribution);
        }
    }

    private void copyPrelitVertexColor(int triIndex, int index, int colorIndex) {
        float[] triColor = this.triangleColors[triIndex][colorIndex];
        float[] v = this.vertices[index];
        triColor[0] = v[3];
        triColor[1] = v[4];
        triColor[2] = v[5];
        triColor[3] = v[6];
        triColor[4] = v[28];
        triColor[5] = v[29];
        triColor[6] = v[30];
    }

    private void copyVertexColor(int triIndex, int index, int colorIndex, float[] contrib) {
        float[] triColor = this.triangleColors[triIndex][colorIndex];
        float[] v = this.vertices[index];
        triColor[0] = this.clamp(v[32] + v[25] * contrib[0] + v[3] * contrib[3]);
        triColor[1] = this.clamp(v[33] + v[26] * contrib[1] + v[4] * contrib[4]);
        triColor[2] = this.clamp(v[34] + v[27] * contrib[2] + v[5] * contrib[5]);
        triColor[3] = this.clamp(v[6]);
        triColor[4] = this.clamp(v[28] * contrib[6]);
        triColor[5] = this.clamp(v[29] * contrib[7]);
        triColor[6] = this.clamp(v[30] * contrib[8]);
    }

    private void lightTriangle(int triIndex, float[] lightContribution) {
        int vIndex = this.triangles[triIndex][0];
        this.copyVertexColor(triIndex, vIndex, 0, lightContribution);
        vIndex = this.triangles[triIndex][1];
        this.copyVertexColor(triIndex, vIndex, 1, lightContribution);
        vIndex = this.triangles[triIndex][2];
        this.copyVertexColor(triIndex, vIndex, 2, lightContribution);
    }

    private void lightTriangle(int triIndex) {
        if (this.normalMode == 2) {
            int vIndex = this.triangles[triIndex][0];
            this.lightUnlitVertex(vIndex, this.tempLightingContribution);
            this.copyPrelitVertexColor(triIndex, vIndex, 0);
            vIndex = this.triangles[triIndex][1];
            this.lightUnlitVertex(vIndex, this.tempLightingContribution);
            this.copyPrelitVertexColor(triIndex, vIndex, 1);
            vIndex = this.triangles[triIndex][2];
            this.lightUnlitVertex(vIndex, this.tempLightingContribution);
            this.copyPrelitVertexColor(triIndex, vIndex, 2);
        } else if (!this.lightingDependsOnVertexPosition) {
            int vIndex = this.triangles[triIndex][0];
            int vIndex2 = this.triangles[triIndex][1];
            int vIndex3 = this.triangles[triIndex][2];
            this.cross(this.vertices[vIndex2][21] - this.vertices[vIndex][21], this.vertices[vIndex2][22] - this.vertices[vIndex][22], this.vertices[vIndex2][23] - this.vertices[vIndex][23], this.vertices[vIndex3][21] - this.vertices[vIndex][21], this.vertices[vIndex3][22] - this.vertices[vIndex][22], this.vertices[vIndex3][23] - this.vertices[vIndex][23], this.lightTriangleNorm);
            this.lightTriangleNorm.normalize();
            this.vertices[vIndex][9] = this.lightTriangleNorm.x;
            this.vertices[vIndex][10] = this.lightTriangleNorm.y;
            this.vertices[vIndex][11] = this.lightTriangleNorm.z;
            this.calcLightingContribution(vIndex, this.tempLightingContribution, true);
            this.copyVertexColor(triIndex, vIndex, 0, this.tempLightingContribution);
            this.copyVertexColor(triIndex, vIndex2, 1, this.tempLightingContribution);
            this.copyVertexColor(triIndex, vIndex3, 2, this.tempLightingContribution);
        } else if (this.normalMode == 1) {
            int vIndex = this.triangles[triIndex][0];
            this.vertices[vIndex][9] = this.vertices[this.shapeFirst][9];
            this.vertices[vIndex][10] = this.vertices[this.shapeFirst][10];
            this.vertices[vIndex][11] = this.vertices[this.shapeFirst][11];
            this.calcLightingContribution(vIndex, this.tempLightingContribution);
            this.copyVertexColor(triIndex, vIndex, 0, this.tempLightingContribution);
            vIndex = this.triangles[triIndex][1];
            this.vertices[vIndex][9] = this.vertices[this.shapeFirst][9];
            this.vertices[vIndex][10] = this.vertices[this.shapeFirst][10];
            this.vertices[vIndex][11] = this.vertices[this.shapeFirst][11];
            this.calcLightingContribution(vIndex, this.tempLightingContribution);
            this.copyVertexColor(triIndex, vIndex, 1, this.tempLightingContribution);
            vIndex = this.triangles[triIndex][2];
            this.vertices[vIndex][9] = this.vertices[this.shapeFirst][9];
            this.vertices[vIndex][10] = this.vertices[this.shapeFirst][10];
            this.vertices[vIndex][11] = this.vertices[this.shapeFirst][11];
            this.calcLightingContribution(vIndex, this.tempLightingContribution);
            this.copyVertexColor(triIndex, vIndex, 2, this.tempLightingContribution);
        } else {
            int vIndex = this.triangles[triIndex][0];
            int vIndex2 = this.triangles[triIndex][1];
            int vIndex3 = this.triangles[triIndex][2];
            this.cross(this.vertices[vIndex2][21] - this.vertices[vIndex][21], this.vertices[vIndex2][22] - this.vertices[vIndex][22], this.vertices[vIndex2][23] - this.vertices[vIndex][23], this.vertices[vIndex3][21] - this.vertices[vIndex][21], this.vertices[vIndex3][22] - this.vertices[vIndex][22], this.vertices[vIndex3][23] - this.vertices[vIndex][23], this.lightTriangleNorm);
            this.lightTriangleNorm.normalize();
            this.vertices[vIndex][9] = this.lightTriangleNorm.x;
            this.vertices[vIndex][10] = this.lightTriangleNorm.y;
            this.vertices[vIndex][11] = this.lightTriangleNorm.z;
            this.calcLightingContribution(vIndex, this.tempLightingContribution, true);
            this.copyVertexColor(triIndex, vIndex, 0, this.tempLightingContribution);
            this.vertices[vIndex2][9] = this.lightTriangleNorm.x;
            this.vertices[vIndex2][10] = this.lightTriangleNorm.y;
            this.vertices[vIndex2][11] = this.lightTriangleNorm.z;
            this.calcLightingContribution(vIndex2, this.tempLightingContribution, true);
            this.copyVertexColor(triIndex, vIndex2, 1, this.tempLightingContribution);
            this.vertices[vIndex3][9] = this.lightTriangleNorm.x;
            this.vertices[vIndex3][10] = this.lightTriangleNorm.y;
            this.vertices[vIndex3][11] = this.lightTriangleNorm.z;
            this.calcLightingContribution(vIndex3, this.tempLightingContribution, true);
            this.copyVertexColor(triIndex, vIndex3, 2, this.tempLightingContribution);
        }
    }

    protected void renderTriangles(int start, int stop) {
        int i = start;
        while (i < stop) {
            float[] a = this.vertices[this.triangles[i][0]];
            float[] b = this.vertices[this.triangles[i][1]];
            float[] c = this.vertices[this.triangles[i][2]];
            int tex = this.triangles[i][3];
            this.triangle.reset();
            float ar = this.clamp(this.triangleColors[i][0][0] + this.triangleColors[i][0][4]);
            float ag = this.clamp(this.triangleColors[i][0][1] + this.triangleColors[i][0][5]);
            float ab = this.clamp(this.triangleColors[i][0][2] + this.triangleColors[i][0][6]);
            float br = this.clamp(this.triangleColors[i][1][0] + this.triangleColors[i][1][4]);
            float bg = this.clamp(this.triangleColors[i][1][1] + this.triangleColors[i][1][5]);
            float bb = this.clamp(this.triangleColors[i][1][2] + this.triangleColors[i][1][6]);
            float cr = this.clamp(this.triangleColors[i][2][0] + this.triangleColors[i][2][4]);
            float cg = this.clamp(this.triangleColors[i][2][1] + this.triangleColors[i][2][5]);
            float cb = this.clamp(this.triangleColors[i][2][2] + this.triangleColors[i][2][6]);
            boolean failedToPrecalc = false;
            if (s_enableAccurateTextures && this.frustumMode) {
                boolean textured = true;
                this.smoothTriangle.reset(3);
                this.smoothTriangle.smooth = true;
                this.smoothTriangle.interpARGB = true;
                this.smoothTriangle.setIntensities(ar, ag, ab, a[6], br, bg, bb, b[6], cr, cg, cb, c[6]);
                if (tex > -1 && this.textures[tex] != null) {
                    this.smoothTriangle.setCamVertices(a[21], a[22], a[23], b[21], b[22], b[23], c[21], c[22], c[23]);
                    this.smoothTriangle.interpUV = true;
                    this.smoothTriangle.texture(this.textures[tex]);
                    float umult = this.textures[tex].width;
                    float vmult = this.textures[tex].height;
                    this.smoothTriangle.vertices[0][7] = a[7] * umult;
                    this.smoothTriangle.vertices[0][8] = a[8] * vmult;
                    this.smoothTriangle.vertices[1][7] = b[7] * umult;
                    this.smoothTriangle.vertices[1][8] = b[8] * vmult;
                    this.smoothTriangle.vertices[2][7] = c[7] * umult;
                    this.smoothTriangle.vertices[2][8] = c[8] * vmult;
                } else {
                    this.smoothTriangle.interpUV = false;
                    textured = false;
                }
                this.smoothTriangle.setVertices(a[18], a[19], a[20], b[18], b[19], b[20], c[18], c[19], c[20]);
                if (!textured || this.smoothTriangle.precomputeAccurateTexturing()) {
                    this.smoothTriangle.render();
                } else {
                    failedToPrecalc = true;
                }
            }
            if (!s_enableAccurateTextures || failedToPrecalc || !this.frustumMode) {
                if (tex > -1 && this.textures[tex] != null) {
                    this.triangle.setTexture(this.textures[tex]);
                    this.triangle.setUV(a[7], a[8], b[7], b[8], c[7], c[8]);
                }
                this.triangle.setIntensities(ar, ag, ab, a[6], br, bg, bb, b[6], cr, cg, cb, c[6]);
                this.triangle.setVertices(a[18], a[19], a[20], b[18], b[19], b[20], c[18], c[19], c[20]);
                this.triangle.render();
            }
            ++i;
        }
    }

    protected void rawTriangles(int start, int stop) {
        this.raw.colorMode(1, 1.0f);
        this.raw.noStroke();
        this.raw.beginShape(9);
        int i = start;
        while (i < stop) {
            PImage texImage;
            float[] a = this.vertices[this.triangles[i][0]];
            float[] b = this.vertices[this.triangles[i][1]];
            float[] c = this.vertices[this.triangles[i][2]];
            float ar = this.clamp(this.triangleColors[i][0][0] + this.triangleColors[i][0][4]);
            float ag = this.clamp(this.triangleColors[i][0][1] + this.triangleColors[i][0][5]);
            float ab = this.clamp(this.triangleColors[i][0][2] + this.triangleColors[i][0][6]);
            float br = this.clamp(this.triangleColors[i][1][0] + this.triangleColors[i][1][4]);
            float bg = this.clamp(this.triangleColors[i][1][1] + this.triangleColors[i][1][5]);
            float bb = this.clamp(this.triangleColors[i][1][2] + this.triangleColors[i][1][6]);
            float cr = this.clamp(this.triangleColors[i][2][0] + this.triangleColors[i][2][4]);
            float cg = this.clamp(this.triangleColors[i][2][1] + this.triangleColors[i][2][5]);
            float cb = this.clamp(this.triangleColors[i][2][2] + this.triangleColors[i][2][6]);
            int tex = this.triangles[i][3];
            PImage pImage = texImage = tex > -1 ? this.textures[tex] : null;
            if (texImage != null) {
                if (this.raw.is3D()) {
                    if (a[24] != 0.0f && b[24] != 0.0f && c[24] != 0.0f) {
                        this.raw.fill(ar, ag, ab, a[6]);
                        this.raw.vertex(a[21] / a[24], a[22] / a[24], a[23] / a[24], a[7], a[8]);
                        this.raw.fill(br, bg, bb, b[6]);
                        this.raw.vertex(b[21] / b[24], b[22] / b[24], b[23] / b[24], b[7], b[8]);
                        this.raw.fill(cr, cg, cb, c[6]);
                        this.raw.vertex(c[21] / c[24], c[22] / c[24], c[23] / c[24], c[7], c[8]);
                    }
                } else if (this.raw.is2D()) {
                    this.raw.fill(ar, ag, ab, a[6]);
                    this.raw.vertex(a[18], a[19], a[7], a[8]);
                    this.raw.fill(br, bg, bb, b[6]);
                    this.raw.vertex(b[18], b[19], b[7], b[8]);
                    this.raw.fill(cr, cg, cb, c[6]);
                    this.raw.vertex(c[18], c[19], c[7], c[8]);
                }
            } else if (this.raw.is3D()) {
                if (a[24] != 0.0f && b[24] != 0.0f && c[24] != 0.0f) {
                    this.raw.fill(ar, ag, ab, a[6]);
                    this.raw.vertex(a[21] / a[24], a[22] / a[24], a[23] / a[24]);
                    this.raw.fill(br, bg, bb, b[6]);
                    this.raw.vertex(b[21] / b[24], b[22] / b[24], b[23] / b[24]);
                    this.raw.fill(cr, cg, cb, c[6]);
                    this.raw.vertex(c[21] / c[24], c[22] / c[24], c[23] / c[24]);
                }
            } else if (this.raw.is2D()) {
                this.raw.fill(ar, ag, ab, a[6]);
                this.raw.vertex(a[18], a[19]);
                this.raw.fill(br, bg, bb, b[6]);
                this.raw.vertex(b[18], b[19]);
                this.raw.fill(cr, cg, cb, c[6]);
                this.raw.vertex(c[18], c[19]);
            }
            ++i;
        }
        this.raw.endShape();
    }

    public void flush() {
        if (this.hints[5]) {
            this.sort();
        }
        this.render();
    }

    protected void render() {
        if (this.pointCount > 0) {
            this.renderPoints(0, this.pointCount);
            if (this.raw != null) {
                this.rawPoints(0, this.pointCount);
            }
            this.pointCount = 0;
        }
        if (this.lineCount > 0) {
            this.renderLines(0, this.lineCount);
            if (this.raw != null) {
                this.rawLines(0, this.lineCount);
            }
            this.lineCount = 0;
            this.pathCount = 0;
        }
        if (this.triangleCount > 0) {
            this.renderTriangles(0, this.triangleCount);
            if (this.raw != null) {
                this.rawTriangles(0, this.triangleCount);
            }
            this.triangleCount = 0;
        }
    }

    protected void sort() {
        if (this.triangleCount > 0) {
            this.sortTrianglesInternal(0, this.triangleCount - 1);
        }
    }

    private void sortTrianglesInternal(int i, int j) {
        int pivotIndex = (i + j) / 2;
        this.sortTrianglesSwap(pivotIndex, j);
        int k = this.sortTrianglesPartition(i - 1, j);
        this.sortTrianglesSwap(k, j);
        if (k - i > 1) {
            this.sortTrianglesInternal(i, k - 1);
        }
        if (j - k > 1) {
            this.sortTrianglesInternal(k + 1, j);
        }
    }

    private int sortTrianglesPartition(int left, int right) {
        int pivot = right;
        while (true) {
            if (this.sortTrianglesCompare(++left, pivot) < 0.0f) {
                continue;
            }
            while (right != 0 && this.sortTrianglesCompare(--right, pivot) > 0.0f) {
            }
            this.sortTrianglesSwap(left, right);
            if (left >= right) break;
        }
        this.sortTrianglesSwap(left, right);
        return left;
    }

    private void sortTrianglesSwap(int a, int b) {
        int[] tempi = this.triangles[a];
        this.triangles[a] = this.triangles[b];
        this.triangles[b] = tempi;
        float[][] tempf = this.triangleColors[a];
        this.triangleColors[a] = this.triangleColors[b];
        this.triangleColors[b] = tempf;
    }

    private float sortTrianglesCompare(int a, int b) {
        return this.vertices[this.triangles[b][0]][20] + this.vertices[this.triangles[b][1]][20] + this.vertices[this.triangles[b][2]][20] - (this.vertices[this.triangles[a][0]][20] + this.vertices[this.triangles[a][1]][20] + this.vertices[this.triangles[a][2]][20]);
    }

    protected void ellipseImpl(float x, float y, float w, float h) {
        float val;
        float inc;
        float radiusH = w / 2.0f;
        float radiusV = h / 2.0f;
        float centerX = x + radiusH;
        float centerY = y + radiusV;
        int rough = (int)(4.0 + Math.sqrt(w + h) * 3.0);
        int accuracy = PApplet.constrain(rough, 6, 100);
        if (this.fill) {
            inc = 720.0f / (float)accuracy;
            val = 0.0f;
            boolean strokeSaved = this.stroke;
            this.stroke = false;
            boolean smoothSaved = this.smooth;
            if (this.smooth && this.stroke) {
                this.smooth = false;
            }
            this.beginShape(11);
            this.normal(0.0f, 0.0f, 1.0f);
            this.vertex(centerX, centerY);
            int i = 0;
            while (i < accuracy) {
                this.vertex(centerX + cosLUT[(int)val] * radiusH, centerY + sinLUT[(int)val] * radiusV);
                val = (val + inc) % 720.0f;
                ++i;
            }
            this.vertex(centerX + cosLUT[0] * radiusH, centerY + sinLUT[0] * radiusV);
            this.endShape();
            this.stroke = strokeSaved;
            this.smooth = smoothSaved;
        }
        if (this.stroke) {
            inc = 720.0f / (float)accuracy;
            val = 0.0f;
            boolean savedFill = this.fill;
            this.fill = false;
            val = 0.0f;
            this.beginShape();
            int i = 0;
            while (i < accuracy) {
                this.vertex(centerX + cosLUT[(int)val] * radiusH, centerY + sinLUT[(int)val] * radiusV);
                val = (val + inc) % 720.0f;
                ++i;
            }
            this.endShape(2);
            this.fill = savedFill;
        }
    }

    protected void arcImpl(float x, float y, float w, float h, float start, float stop) {
        int ii;
        int i;
        int increment;
        int stopLUT;
        int startLUT;
        float hr = w / 2.0f;
        float vr = h / 2.0f;
        float centerX = x + hr;
        float centerY = y + vr;
        if (this.fill) {
            boolean savedStroke = this.stroke;
            this.stroke = false;
            startLUT = (int)(0.5f + start / ((float)Math.PI * 2) * 720.0f);
            stopLUT = (int)(0.5f + stop / ((float)Math.PI * 2) * 720.0f);
            this.beginShape(11);
            this.vertex(centerX, centerY);
            increment = 1;
            i = startLUT;
            while (i < stopLUT) {
                ii = i % 720;
                if (ii < 0) {
                    ii += 720;
                }
                this.vertex(centerX + cosLUT[ii] * hr, centerY + sinLUT[ii] * vr);
                i += increment;
            }
            this.vertex(centerX + cosLUT[stopLUT % 720] * hr, centerY + sinLUT[stopLUT % 720] * vr);
            this.endShape();
            this.stroke = savedStroke;
        }
        if (this.stroke) {
            boolean savedFill = this.fill;
            this.fill = false;
            startLUT = (int)(0.5f + start / ((float)Math.PI * 2) * 720.0f);
            stopLUT = (int)(0.5f + stop / ((float)Math.PI * 2) * 720.0f);
            this.beginShape();
            increment = 1;
            i = startLUT;
            while (i < stopLUT) {
                ii = i % 720;
                if (ii < 0) {
                    ii += 720;
                }
                this.vertex(centerX + cosLUT[ii] * hr, centerY + sinLUT[ii] * vr);
                i += increment;
            }
            this.vertex(centerX + cosLUT[stopLUT % 720] * hr, centerY + sinLUT[stopLUT % 720] * vr);
            this.endShape();
            this.fill = savedFill;
        }
    }

    public void box(float w, float h, float d) {
        if (this.triangle != null) {
            this.triangle.setCulling(true);
        }
        super.box(w, h, d);
        if (this.triangle != null) {
            this.triangle.setCulling(false);
        }
    }

    public void sphere(float r) {
        if (this.triangle != null) {
            this.triangle.setCulling(true);
        }
        super.sphere(r);
        if (this.triangle != null) {
            this.triangle.setCulling(false);
        }
    }

    public void smooth() {
        s_enableAccurateTextures = true;
        this.smooth = true;
    }

    public void noSmooth() {
        s_enableAccurateTextures = false;
        this.smooth = false;
    }

    protected boolean textModeCheck(int mode) {
        return this.textMode == 4 || this.textMode == 256;
    }

    public void pushMatrix() {
        if (this.matrixStackDepth == 32) {
            throw new RuntimeException("Too many calls to pushMatrix().");
        }
        this.modelview.get(this.matrixStack[this.matrixStackDepth]);
        this.modelviewInv.get(this.matrixInvStack[this.matrixStackDepth]);
        ++this.matrixStackDepth;
    }

    public void popMatrix() {
        if (this.matrixStackDepth == 0) {
            throw new RuntimeException("Too many calls to popMatrix(), and not enough to pushMatrix().");
        }
        --this.matrixStackDepth;
        this.modelview.set(this.matrixStack[this.matrixStackDepth]);
        this.modelviewInv.set(this.matrixInvStack[this.matrixStackDepth]);
    }

    public void translate(float tx, float ty) {
        this.translate(tx, ty, 0.0f);
    }

    public void translate(float tx, float ty, float tz) {
        this.forwardTransform.translate(tx, ty, tz);
        this.reverseTransform.invTranslate(tx, ty, tz);
    }

    public void rotate(float angle) {
        this.rotateZ(angle);
    }

    public void rotateX(float angle) {
        this.forwardTransform.rotateX(angle);
        this.reverseTransform.invRotateX(angle);
    }

    public void rotateY(float angle) {
        this.forwardTransform.rotateY(angle);
        this.reverseTransform.invRotateY(angle);
    }

    public void rotateZ(float angle) {
        this.forwardTransform.rotateZ(angle);
        this.reverseTransform.invRotateZ(angle);
    }

    public void rotate(float angle, float v0, float v1, float v2) {
        this.forwardTransform.rotate(angle, v0, v1, v2);
        this.reverseTransform.invRotate(angle, v0, v1, v2);
    }

    public void scale(float s) {
        this.scale(s, s, s);
    }

    public void scale(float sx, float sy) {
        this.scale(sx, sy, 1.0f);
    }

    public void scale(float x, float y, float z) {
        this.forwardTransform.scale(x, y, z);
        this.reverseTransform.invScale(x, y, z);
    }

    public void resetMatrix() {
        this.forwardTransform.reset();
        this.reverseTransform.reset();
    }

    public void applyMatrix(PMatrix2D source) {
        this.applyMatrix(source.m00, source.m01, source.m02, source.m10, source.m11, source.m12);
    }

    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.applyMatrix(n00, n01, n02, 0.0f, n10, n11, n12, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void applyMatrix(PMatrix3D source) {
        this.applyMatrix(source.m00, source.m01, source.m02, source.m03, source.m10, source.m11, source.m12, source.m13, source.m20, source.m21, source.m22, source.m23, source.m30, source.m31, source.m32, source.m33);
    }

    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        this.forwardTransform.apply(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
        this.reverseTransform.invApply(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
    }

    public PMatrix getMatrix() {
        return this.modelview.get();
    }

    public PMatrix3D getMatrix(PMatrix3D target) {
        if (target == null) {
            target = new PMatrix3D();
        }
        target.set(this.modelview);
        return target;
    }

    public void setMatrix(PMatrix2D source) {
        this.resetMatrix();
        this.applyMatrix(source);
    }

    public void setMatrix(PMatrix3D source) {
        this.resetMatrix();
        this.applyMatrix(source);
    }

    public void printMatrix() {
        this.modelview.print();
    }

    public void beginCamera() {
        if (this.manipulatingCamera) {
            throw new RuntimeException("beginCamera() cannot be called again before endCamera()");
        }
        this.manipulatingCamera = true;
        this.forwardTransform = this.cameraInv;
        this.reverseTransform = this.camera;
    }

    public void endCamera() {
        if (!this.manipulatingCamera) {
            throw new RuntimeException("Cannot call endCamera() without first calling beginCamera()");
        }
        this.modelview.set(this.camera);
        this.modelviewInv.set(this.cameraInv);
        this.forwardTransform = this.modelview;
        this.reverseTransform = this.modelviewInv;
        this.manipulatingCamera = false;
    }

    public void camera() {
        this.camera(this.cameraX, this.cameraY, this.cameraZ, this.cameraX, this.cameraY, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    public void camera(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        float z0 = eyeX - centerX;
        float z1 = eyeY - centerY;
        float z2 = eyeZ - centerZ;
        float mag = this.sqrt(z0 * z0 + z1 * z1 + z2 * z2);
        if (mag != 0.0f) {
            z0 /= mag;
            z1 /= mag;
            z2 /= mag;
        }
        float y0 = upX;
        float y1 = upY;
        float y2 = upZ;
        float x0 = y1 * z2 - y2 * z1;
        float x1 = -y0 * z2 + y2 * z0;
        float x2 = y0 * z1 - y1 * z0;
        y0 = z1 * x2 - z2 * x1;
        y1 = -z0 * x2 + z2 * x0;
        y2 = z0 * x1 - z1 * x0;
        mag = this.sqrt(x0 * x0 + x1 * x1 + x2 * x2);
        if (mag != 0.0f) {
            x0 /= mag;
            x1 /= mag;
            x2 /= mag;
        }
        if ((mag = this.sqrt(y0 * y0 + y1 * y1 + y2 * y2)) != 0.0f) {
            y0 /= mag;
            y1 /= mag;
            y2 /= mag;
        }
        this.camera.set(x0, x1, x2, 0.0f, y0, y1, y2, 0.0f, z0, z1, z2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.camera.translate(-eyeX, -eyeY, -eyeZ);
        this.cameraInv.reset();
        this.cameraInv.invApply(x0, x1, x2, 0.0f, y0, y1, y2, 0.0f, z0, z1, z2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.cameraInv.translate(eyeX, eyeY, eyeZ);
        this.modelview.set(this.camera);
        this.modelviewInv.set(this.cameraInv);
    }

    public void printCamera() {
        this.camera.print();
    }

    public void ortho() {
        this.ortho(0.0f, this.width, 0.0f, this.height, -10.0f, 10.0f);
    }

    public void ortho(float left, float right, float bottom, float top, float near, float far) {
        float x = 2.0f / (right - left);
        float y = 2.0f / (top - bottom);
        float z = -2.0f / (far - near);
        float tx = -(right + left) / (right - left);
        float ty = -(top + bottom) / (top - bottom);
        float tz = -(far + near) / (far - near);
        this.projection.set(x, 0.0f, 0.0f, tx, 0.0f, y, 0.0f, ty, 0.0f, 0.0f, z, tz, 0.0f, 0.0f, 0.0f, 1.0f);
        this.updateProjection();
        this.frustumMode = false;
    }

    public void perspective() {
        this.perspective(this.cameraFOV, this.cameraAspect, this.cameraNear, this.cameraFar);
    }

    public void perspective(float fov, float aspect, float zNear, float zFar) {
        float ymax = zNear * (float)Math.tan(fov / 2.0f);
        float ymin = -ymax;
        float xmin = ymin * aspect;
        float xmax = ymax * aspect;
        this.frustum(xmin, xmax, ymin, ymax, zNear, zFar);
    }

    public void frustum(float left, float right, float bottom, float top, float znear, float zfar) {
        this.leftScreen = left;
        this.rightScreen = right;
        this.bottomScreen = bottom;
        this.topScreen = top;
        this.nearPlane = znear;
        this.frustumMode = true;
        this.projection.set(2.0f * znear / (right - left), 0.0f, (right + left) / (right - left), 0.0f, 0.0f, 2.0f * znear / (top - bottom), (top + bottom) / (top - bottom), 0.0f, 0.0f, 0.0f, -(zfar + znear) / (zfar - znear), -(2.0f * zfar * znear) / (zfar - znear), 0.0f, 0.0f, -1.0f, 0.0f);
        this.updateProjection();
    }

    protected void updateProjection() {
    }

    public void printProjection() {
        this.projection.print();
    }

    public float screenX(float x, float y) {
        return this.screenX(x, y, 0.0f);
    }

    public float screenY(float x, float y) {
        return this.screenY(x, y, 0.0f);
    }

    public float screenX(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float ox = this.projection.m00 * ax + this.projection.m01 * ay + this.projection.m02 * az + this.projection.m03 * aw;
        float ow = this.projection.m30 * ax + this.projection.m31 * ay + this.projection.m32 * az + this.projection.m33 * aw;
        if (ow != 0.0f) {
            ox /= ow;
        }
        return (float)this.width * (1.0f + ox) / 2.0f;
    }

    public float screenY(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float oy = this.projection.m10 * ax + this.projection.m11 * ay + this.projection.m12 * az + this.projection.m13 * aw;
        float ow = this.projection.m30 * ax + this.projection.m31 * ay + this.projection.m32 * az + this.projection.m33 * aw;
        if (ow != 0.0f) {
            oy /= ow;
        }
        return (float)this.height * (1.0f + oy) / 2.0f;
    }

    public float screenZ(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float oz = this.projection.m20 * ax + this.projection.m21 * ay + this.projection.m22 * az + this.projection.m23 * aw;
        float ow = this.projection.m30 * ax + this.projection.m31 * ay + this.projection.m32 * az + this.projection.m33 * aw;
        if (ow != 0.0f) {
            oz /= ow;
        }
        return (oz + 1.0f) / 2.0f;
    }

    public float modelX(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float ox = this.cameraInv.m00 * ax + this.cameraInv.m01 * ay + this.cameraInv.m02 * az + this.cameraInv.m03 * aw;
        float ow = this.cameraInv.m30 * ax + this.cameraInv.m31 * ay + this.cameraInv.m32 * az + this.cameraInv.m33 * aw;
        return ow != 0.0f ? ox / ow : ox;
    }

    public float modelY(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float oy = this.cameraInv.m10 * ax + this.cameraInv.m11 * ay + this.cameraInv.m12 * az + this.cameraInv.m13 * aw;
        float ow = this.cameraInv.m30 * ax + this.cameraInv.m31 * ay + this.cameraInv.m32 * az + this.cameraInv.m33 * aw;
        return ow != 0.0f ? oy / ow : oy;
    }

    public float modelZ(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float oz = this.cameraInv.m20 * ax + this.cameraInv.m21 * ay + this.cameraInv.m22 * az + this.cameraInv.m23 * aw;
        float ow = this.cameraInv.m30 * ax + this.cameraInv.m31 * ay + this.cameraInv.m32 * az + this.cameraInv.m33 * aw;
        return ow != 0.0f ? oz / ow : oz;
    }

    public void strokeJoin(int join) {
        if (join != 8) {
            PGraphics3D.showMethodWarning("strokeJoin");
        }
    }

    public void strokeCap(int cap) {
        if (cap != 2) {
            PGraphics3D.showMethodWarning("strokeCap");
        }
    }

    protected void fillFromCalc() {
        super.fillFromCalc();
        this.ambientFromCalc();
    }

    public void lights() {
        int colorModeSaved = this.colorMode;
        this.colorMode = 1;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.ambientLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f);
        this.directionalLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f, 0.0f, 0.0f, -1.0f);
        this.colorMode = colorModeSaved;
        this.lightingDependsOnVertexPosition = false;
    }

    public void noLights() {
        this.flush();
        this.lightCount = 0;
    }

    public void ambientLight(float r, float g, float b) {
        this.ambientLight(r, g, b, 0.0f, 0.0f, 0.0f);
    }

    public void ambientLight(float r, float g, float b, float x, float y, float z) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(r, g, b);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 0;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightPosition(this.lightCount, x, y, z);
        ++this.lightCount;
    }

    public void directionalLight(float r, float g, float b, float nx, float ny, float nz) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(r, g, b);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 1;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightDirection(this.lightCount, nx, ny, nz);
        ++this.lightCount;
    }

    public void pointLight(float r, float g, float b, float x, float y, float z) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(r, g, b);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 2;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightPosition(this.lightCount, x, y, z);
        ++this.lightCount;
        this.lightingDependsOnVertexPosition = true;
    }

    public void spotLight(float r, float g, float b, float x, float y, float z, float nx, float ny, float nz, float angle, float concentration) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(r, g, b);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 3;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightPosition(this.lightCount, x, y, z);
        this.lightDirection(this.lightCount, nx, ny, nz);
        this.lightSpotAngle[this.lightCount] = angle;
        this.lightSpotAngleCos[this.lightCount] = Math.max(0.0f, (float)Math.cos(angle));
        this.lightSpotConcentration[this.lightCount] = concentration;
        ++this.lightCount;
        this.lightingDependsOnVertexPosition = true;
    }

    public void lightFalloff(float constant, float linear, float quadratic) {
        this.currentLightFalloffConstant = constant;
        this.currentLightFalloffLinear = linear;
        this.currentLightFalloffQuadratic = quadratic;
        this.lightingDependsOnVertexPosition = true;
    }

    public void lightSpecular(float x, float y, float z) {
        this.colorCalc(x, y, z);
        this.currentLightSpecular[0] = this.calcR;
        this.currentLightSpecular[1] = this.calcG;
        this.currentLightSpecular[2] = this.calcB;
        this.lightingDependsOnVertexPosition = true;
    }

    protected void lightPosition(int num, float x, float y, float z) {
        this.lightPositionVec.set(x, y, z);
        this.modelview.mult(this.lightPositionVec, this.lightPosition[num]);
    }

    protected void lightDirection(int num, float x, float y, float z) {
        this.lightNormal[num].set(this.modelviewInv.m00 * x + this.modelviewInv.m10 * y + this.modelviewInv.m20 * z + this.modelviewInv.m30, this.modelviewInv.m01 * x + this.modelviewInv.m11 * y + this.modelviewInv.m21 * z + this.modelviewInv.m31, this.modelviewInv.m02 * x + this.modelviewInv.m12 * y + this.modelviewInv.m22 * z + this.modelviewInv.m32);
        this.lightNormal[num].normalize();
    }

    protected void backgroundImpl(PImage image) {
        System.arraycopy(image.pixels, 0, this.pixels, 0, this.pixels.length);
        Arrays.fill(this.zbuffer, Float.MAX_VALUE);
    }

    protected void backgroundImpl() {
        Arrays.fill(this.pixels, this.backgroundColor);
        Arrays.fill(this.zbuffer, Float.MAX_VALUE);
    }

    public boolean is2D() {
        return false;
    }

    public boolean is3D() {
        return true;
    }

    private final float sqrt(float a) {
        return (float)Math.sqrt(a);
    }

    private final float mag(float a, float b, float c) {
        return (float)Math.sqrt(a * a + b * b + c * c);
    }

    private final float clamp(float a) {
        return a < 1.0f ? a : 1.0f;
    }

    private final float abs(float a) {
        return a < 0.0f ? -a : a;
    }

    private float dot(float ax, float ay, float az, float bx, float by, float bz) {
        return ax * bx + ay * by + az * bz;
    }

    private final void cross(float a0, float a1, float a2, float b0, float b1, float b2, PVector out) {
        out.x = a1 * b2 - a2 * b1;
        out.y = a2 * b0 - a0 * b2;
        out.z = a0 * b1 - a1 * b0;
    }
}

