varying vec4 diffuse;
varying vec4 ambient;
varying vec3 halfVector;
varying vec3 lightdirection;
varying vec3 normal;

varying vec2 texcoord;
varying float distanceToLight;

uniform sampler2D tex0;
uniform sampler2D tex1;

void main(void)
{
	vec3 interpolatedNormal;
	float angledot;
	float angledot2;

	//take ambient as base color
	vec4 color = ambient;
	vec4 specular;

	interpolatedNormal = normalize(normal);
	angledot = max(dot(interpolatedNormal, lightdirection), 0.0);
	
	vec4 colortexel = texture2D(tex0, texcoord);
	

	
	if (angledot > 0.0)
	{
		float att = 1.0 / (gl_LightSource[0].constantAttenuation +
				gl_LightSource[0].linearAttenuation * distanceToLight +
				gl_LightSource[0].quadraticAttenuation * distanceToLight * distanceToLight);
		//add diffuse component
		color += att * angledot * diffuse;
		
		color = max(color, vec4(0,0,0,0));

		color.r = pow(color.r, 4.1) * 15.0;
		color.g = pow(color.g, 4.1) * 15.0;
		color.b = pow(color.b, 4.1) * 15.0;
		vec3 halfn = normalize(halfVector);
		angledot2 = max(dot(interpolatedNormal, halfn), 0.0);
		
		//calculate specular component
		specular = att * gl_FrontMaterial.specular * gl_LightSource[0].specular * pow(angledot2, gl_FrontMaterial.shininess);
		color = max(color, vec4(0,0,0,0));
		gl_FragColor = colortexel * color + specular;
		
		//gl_FragColor = vec4(angledot, angledot, angledot, 1);
	}
	else
	{
		gl_FragColor = vec4(0, 0, 0, 1);
	}
}
