uniform vec3 lightposition;
uniform float lightstrength;

varying vec2 texturecoordinate;
varying vec2 envcoordinate;
varying float lighting;
varying float dying;
varying float lightup;

void main(void)
{
	vec4 vertex1 = gl_Vertex;
	vec4 vertex2 = gl_Color;
	vec4 normal = vec4(gl_Normal.xyz, 1);
	vec3 transformedNormal = (gl_ModelViewProjectionMatrix * normal).xyz;
	
	
	float dist = length(vertex1.xyz - lightposition) * 2.5;// / 10.0;
	lightup = 1.0-pow(dist, 6.0);
	lightup = clamp(lightup, 0.0, 1.0) * lightstrength;

	envcoordinate.xy = transformedNormal.xy*1.0;
	texturecoordinate = gl_MultiTexCoord0.st;
	
	vec3 lightdir = normalize(vec3(1.0, 0.3, 0.5));
	lighting = dot(lightdir, transformedNormal);
	dying = 1.0 - gl_MultiTexCoord1.s;
		
	
	vec4 vertex = mix(vertex1, vertex2, dying);
	vertex.x -= (1.0 - dying) * 1.33;
	
	
	gl_Position = gl_ModelViewProjectionMatrix * vertex;
}
