uniform sampler2D colortexture;
uniform sampler2D leafmap;
uniform float movement;
varying vec2 texturecoordinate;
varying vec2 envcoordinate;
varying float lighting;
varying float dying;
varying float lightup;

void main(void)
{
	if (dying < 0.0001)
		discard;
	vec4 colortexel = texture2D(colortexture, envcoordinate + vec2(0.5, 0.5));
	vec4 leaftexel = texture2D(leafmap, texturecoordinate);
	if (leaftexel.r < 0.001)
		discard;

	float shade = 0.75 + 0.25*abs(lighting);
	vec4 finalcolor = colortexel * leaftexel * shade;
	
	finalcolor += vec4(lightup, lightup, lightup, 0.0);//lightup, lightup, 0.0);
	
	float alphadeath = pow(dying, 3.4);
    gl_FragColor = vec4(finalcolor.r, finalcolor.g, finalcolor.b, leaftexel.a * alphadeath);
}
 