varying vec2 texturecoordinate;
varying vec2 envcoordinate;
varying float lighting;

void main(void)
{
	vec4 vertex = gl_Vertex;
	vec4 normal = vec4(gl_Normal.xyz, 1);
	vec3 transformedNormal = (gl_ModelViewProjectionMatrix * normal).xyz;

	envcoordinate.xy = transformedNormal.xy*2.6;
	texturecoordinate = gl_MultiTexCoord0.st;
	
	vec3 lightdir = normalize(vec3(1.0, 0.3, 0.5));
	lighting = dot(lightdir, transformedNormal);
	
	gl_Position = gl_ModelViewProjectionMatrix * vertex;
}
