uniform sampler2D colortexture;
uniform sampler2D leafmap;
uniform sampler2D surfacemap;
uniform float movement;
varying vec2 texturecoordinate;
varying vec2 envcoordinate;
varying float lighting;

void main(void)
{
	vec4 colortexel = texture2D(colortexture, envcoordinate + vec2(0.5, 0.5));
	vec4 leaftexel = texture2D(leafmap, texturecoordinate);
	vec4 surfacetexel = texture2D(surfacemap, texturecoordinate*0.1);
	if (leaftexel.r < 0.001)
		discard;

	surfacetexel.a = 1.0;
	vec4 white = vec4(1.0, 1.0, 1.0, 1.0);
	
	surfacetexel = mix(surfacetexel, white, 0.7);

	float shade = 0.75 + 0.25*abs(lighting);
	vec4 finalcolor = colortexel * leaftexel * shade;// * shade;
    gl_FragColor = vec4(finalcolor.r, finalcolor.g, finalcolor.b, leaftexel.a) * surfacetexel;
}
 