uniform sampler2D colortexture;
uniform sampler2D displacement;
uniform float strength;
uniform float alphavalue;
varying vec2 texturecoordinate;

void main(void)
{
	vec4 displacement_texel = texture2D(displacement, texturecoordinate);
	displacement_texel.y = 0.0;//*= 0.05;
	displacement_texel.x *= 0.15;
	
	displacement_texel *= strength; 
	vec2 offset = texturecoordinate +(displacement_texel.xy);
	
	offset.y = clamp(offset.y, 0.0, 1.0);
	offset.x = clamp(offset.x, 0.0, 1.0);

	vec4 color_texel = texture2D(colortexture, offset);
	gl_FragColor = color_texel * alphavalue * (1.0 + displacement_texel.x);
}