uniform sampler2D tex1;
uniform sampler2D tex2;
uniform float time;
varying vec2 texcoord;
varying float shade;

#define SPEED 0.5
#define DENSITY 1.0

void main(void)
{
	vec4 texcolor1 = texture2D(tex1, texcoord);
	vec4 texcolor2 = texture2D(tex2, texcoord);
	
	float plasmavalue_x = 0.5 + 0.5 * sin(texcoord.x * 9.0 * DENSITY + time * 15.0 * SPEED);
	float plasmavalue_y = 0.5 + 0.5 * cos(texcoord.x * 6.0 * DENSITY + texcoord.y * 6.0 * DENSITY - time * 22.0 * SPEED);
//	float t = 0.5 + 0.5 * sin(time);
	float t = (plasmavalue_x + plasmavalue_y) / 2.0;
	vec4 finalcolor = mix(texcolor1, texcolor2, t);
	 
    gl_FragColor = finalcolor * shade;//vec4(texcolor.r, texcolor.g, texcolor.b, 1.0);
}
 