on *:SIGNAL:dmInit_end: {
    ;;--------- Precalc stuff for all parts ------------
    if ($hget(demor, Part_Count) == $null) {
        DemoPart_Intro_Init
        Demopart_Tunnel_Init
        DemoPart_Greets_Init
        Demopart_Moire_Init
        Demopart_Plasma_Init
        Demopart_End_Init
        hadd demor Part_Count 1
        splay -p $qt($scriptdiretc\no_future.mp3)
    }
    ;;--------- Intro part
    if ($hget(demor, Part_Count) == 1) {
        noop $dmDrawFrame(@dmCanvas, DemoPart_Intro_Start)
    }
    if ($hget(demor, Part_Count) == 2) {
        noop $dmDrawFrame(@dmCanvas, DemoPart_Intro_Main)
    }
    if ($hget(demor, Part_Count) == 3) {
        noop $dmDrawFrame(@dmCanvas, DemoPart_Intro_Exit)
    }
    ;;-------- tunnel part
    if ($hget(demor, Part_Count) == 4) {
        noop $dmDrawFrame(@dmCanvas, Demopart_Tunnel_Start)
    }
    if ($hget(demor, Part_Count) == 5) {
        noop $dmDrawFrame(@dmCanvas, Demopart_Tunnel_Main)
    }
    if ($hget(demor, Part_Count) == 6) {
        noop $dmDrawFrame(@dmCanvas, Demopart_Tunnel_Exit)
    }
    ;;-------- Greets part
    if ($hget(demor, Part_Count) == 7) {
        noop $dmDrawFrame(@dmCanvas, Demopart_Greets_Start)
    }
    if ($hget(demor, Part_Count) == 8) {
        noop $dmDrawFrame(@dmCanvas, Demopart_Greets_Main)
    }
    if ($hget(demor, Part_Count) == 9) {
        noop $dmDrawFrame(@dmCanvas, Demopart_Greets_Exit)
    }
    ;;-------- 'Plasma' part
    if ($hget(demor, Part_Count) == 10) {
        noop $dmDrawFrame(@dmCanvas, Demopart_Plasma_Start)
    }
    if ($hget(demor, Part_Count) == 11) {
        noop $dmDrawFrame(@dmCanvas, Demopart_Plasma_Main)
    }
    if ($hget(demor, Part_Count) == 12) {
        noop $dmDrawFrame(@dmCanvas, Demopart_Plasma_Exit)
    }
    ;;-------- Moire part
    if ($hget(demor, Part_Count) == 13) {
        noop $dmDrawFrame(@dmCanvas, Demopart_Moire_Main)
    }
    if ($hget(demor, Part_Count) == 14) {
        noop $dmDrawFrame(@dmCanvas, Demopart_Moire_Exit)
    }
    ;;-------- End part
    if ($hget(demor, Part_Count) == 15) {
        noop $dmDrawFrame(@dmCanvas, Demopart_End_Main)
    }
}

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Intro
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


alias Demopart_Intro_Init {
    hadd demor Intro_FadeCount_01 -200
    hadd demor Intro_Scroll_Count_01 $hget(demor, CanvasSize_Width)
    var %c red green blue
    var %count 1
    while (%count <= 3) {
        window -dpfh @demor.buffer.intro.0 [ $+ [ %count ] ] 1 1 $hget(demor, CanvasSize_Width) 60
        noop $dmBlankCanvas(@demor.buffer.intro.0 [ $+ [ %count ] ], 0)
        noop $rasterbar(@demor.buffer.intro.0 [ $+ [ %count ] ], 0, $hget(demor, CanvasSize_Width), 20, $gettok(%c, %count, 32))
        inc %count
    }
}

alias Demopart_Intro_Start {
    hinc demor Part_Count
    .signal dmInit_End
    return dmDie
}

alias Demopart_Intro_Main {
    var %fname = fixedsys, %fsize = 48
    var %text1 Welcome to a fresh Digital Sounds System production, presented to you at the 2010 edition of the BreakPoint demoparty. This time, we present you a demo for the popular Windows IRC client mIRC.
    var %text2 How do you like this intro? nice and oldschool eh? Enjoy while you can, this part is replaced in a few seconds for something slightly more intresting :_)
    var %text3 Credits for this demo... Code, Graphics and Music by knoeki... Text by Aegis, Gregg, Knoeki, xiny6581, zerozillion...
    var %count 1
    while (%count <= 3) {
        drawcopy -nt @demor.buffer.intro.0 [ $+ [ %count ] ] 0 0 0 $hget(demor, CanvasSize_Width) 50 @dmCanvas 0 $calc((40 * 2) * %count) $hget(demor, CanvasSize_Width) 60
        drawtext -nrpo @dmCanvas 0 Fixedsys 48 $calc(($cos($hget(demor, Intro_Scroll_Count_01)).deg * (100 * %count)) + $hget(demor, Intro_Scroll_Count_01)) $calc((40 * 2) * %count) %text [ $+ [ %count ] ]
        inc %count
    }
    hdec demor Intro_Scroll_Count_01 4
    if ($insong.pos >= 38406) {
        hadd demor checkpoint 0
        hinc demor Part_Count
        .signal dmInit_End
        return dmDie
    }
}

alias Demopart_Intro_Exit {
    var %count 1
    while (%count <= 3) {
        drawcopy -nt @demor.buffer.intro.0 [ $+ [ %count ] ] 0 0 0 $hget(demor, CanvasSize_Width) 50 @dmCanvas 0 $calc((40 * 2) * %count) $hget(demor, CanvasSize_Width) 60
        inc %count
    }
    drawrect -nrf @dmCanvas 0 1 0 0 $calc(($cos($hget(demor, Intro_Scroll_Count_01)).deg * (50 * %count)) + $hget(demor, Intro_FadeCount_01)) $hget(demor, CanvasSize_Height)
    hinc demor Intro_FadeCount_01 4
    ;;43310
    if ($insong.pos >= 43310) {
        hadd demor checkpoint 0
        hinc demor Part_Count
        .signal dmInit_End
        return dmDie
    }
}

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Tunnel
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


alias Demopart_Tunnel_Init {
    window -dpfoh @demor.buffer.tunnel 1 1 $calc($hget(demor, CanvasSize_Width) / 3) 100
    window -dpfoh @demor.buffer.tunnel2 1 1 $calc($hget(demor, CanvasSize_Width) / 3) 100
    noop $dmBlankCanvas(@demor.buffer.tunnel, 0)
    noop $dmBlankCanvas(@demor.buffer.tunnel2, $rgb(255, 0, 255))
    hadd demor TunnelSinCount_01 100
    hadd demor TunnelSinCount_02 150
    hadd demor TunnelSinCount_03 200
    var %count 1
    while (%count <= 12) {
        noop $dmDrawFrame(@dmCanvas, dmPrecalcAnim)
        hadd demor SpriteSinCount_ [ $+ [ %count ] ] $calc((360 / 12) * %count)
        inc %count
    }
    hadd demor tunnel_sprite_scrollin 360
    hadd demor SpriteCountTable01 $dmGenFadeTable(200)
    hadd demor TunnelFadeOut_01 $hget(demor, CanvasSize_CenterX)
    hadd demor TunnelFadeOut_02 1
}

alias Demopart_Tunnel_Start {
    var %pos $gettok($hget(demor, SpriteCountTable01), $hget(demor, SpriteCount01), 32)
    var %count 1
    while (%count <= 12) {
        var %x $calc(($cos($hget(demor, SpriteSinCount_ [ $+ [ %count ] ])).deg * (%pos + 75)) + ($hget(demor, CanvasSize_CenterX) - 32))
        var %y $calc((($sin($hget(demor, SpriteSinCount_ [ $+ [ %count ] ])).deg * (%pos + 75)) + ($hget(demor, CanvasSize_CenterY) - 32)) + $hget(demor, tunnel_sprite_scrollin))
        var %files 1 2 3 4 5 6 1 2 3 4 5 6
        drawpic -ntc @dmCanvas 16711935 %x %y $qt($+($scriptdirimg\,circle [ $+ [ $gettok(%files, %count, 32) ] ],.bmp))
        hinc demor SpriteSinCount_ [ $+ [ %count ] ] 2
        inc %count
    }
    if ($hget(demor, SpriteCount01) == 398) {
        hadd demor SpriteCount01 0
    }
    hinc demor SpriteCount01
    if ($hget(demor, tunnel_sprite_scrollin) > 0) {
        hdec demor tunnel_sprite_scrollin
    }
    if ($insong.pos >= 49700) {
        hadd demor checkpoint 0
        hinc demor Part_Count
        .signal dmInit_End
        return dmDie
    }
}

alias Demopart_Tunnel_Main {
    var %tunnel.w $calc($hget(demor, CanvasSize_Width) / 3)
    var %c $hget(demor, tunnel_colour_count)
    if (2 // $hget(demor, frame_count)) {
        drawrot -nfb @demor.buffer.tunnel $brgb(%c, %c, %c) 93 0 0 %tunnel.w 100
        hinc demor tunnel_colour_count 15
    }
    var %main.count 1
    while (%main.count <= 5) {
        var %count 1
        while (%count <= 3) {
            var %x $calc(%tunnel.w * (%count - 1))
            var %y $calc(((100 * (%main.count - 1)) + ($sin($hget(demor, TunnelSinCount_0 [ $+ [ %count ] ])).deg * 70)) - 70)
            drawcopy -n @demor.buffer.tunnel 0 0 %tunnel.w 100 @dmCanvas %x %y %tunnel.w 100
            inc %count
        }
        inc %main.count
    }
    hinc demor TunnelSinCount_01 5
    hinc demor TunnelSinCount_02 5
    hinc demor TunnelSinCount_03 5
    var %pos $gettok($hget(demor, SpriteCountTable01), $hget(demor, SpriteCount01), 32)
    var %count 1
    while (%count <= 12) {
        var %x $calc(($cos($hget(demor, SpriteSinCount_ [ $+ [ %count ] ])).deg * (%pos + 75)) + ($hget(demor, CanvasSize_CenterX) - 32))
        var %y $calc(($sin($hget(demor, SpriteSinCount_ [ $+ [ %count ] ])).deg * (%pos + 75)) + ($hget(demor, CanvasSize_CenterY) - 32))
        var %files 1 2 3 4 5 6 1 2 3 4 5 6
        drawpic -ntc @dmCanvas 16711935 %x %y $qt($+($scriptdirimg\,circle [ $+ [ $gettok(%files, %count, 32) ] ],.bmp))
        hinc demor SpriteSinCount_ [ $+ [ %count ] ] 2
        inc %count
    }
    if ($hget(demor, SpriteCount01) == 398) {
        hadd demor SpriteCount01 0
    }
    hinc demor SpriteCount01
    if ($insong.pos >= 64049) {
        hadd demor checkpoint 0
        hinc demor Part_Count
        .signal dmInit_End
        return dmDie
    }
}

alias Demopart_Tunnel_Exit {
    var %tunnel.w $calc($hget(demor, CanvasSize_Width) / 3)
    var %c $hget(demor, tunnel_colour_count)
    if (2 // $hget(demor, frame_count)) {
        drawrot -nfb @demor.buffer.tunnel $brgb(%c, %c, %c) 93 0 0 %tunnel.w 100
        hinc demor tunnel_colour_count 15
    }
    var %main.count 1
    while (%main.count <= 5) {
        var %count 1
        while (%count <= 3) {
            var %x $calc(%tunnel.w * (%count - 1))
            var %y $calc(((100 * (%main.count - 1)) + ($sin($hget(demor, TunnelSinCount_0 [ $+ [ %count ] ])).deg * 70)) - 70)
            drawcopy -n @demor.buffer.tunnel 0 0 %tunnel.w 100 @dmCanvas %x %y %tunnel.w 100
            inc %count
        }
        inc %main.count
    }
    ;;fadeout here
    drawrect -nrf @dmCanvas 0 0 $hget(demor, TunnelFadeOut_01) 0 $hget(demor, TunnelFadeOut_02) $hget(demor, CanvasSize_Height)
    hinc demor TunnelSinCount_01 5
    hinc demor TunnelSinCount_02 5
    hinc demor TunnelSinCount_03 5
    var %pos $gettok($hget(demor, SpriteCountTable01), $hget(demor, SpriteCount01), 32)
    var %count 1
    while (%count <= 12) {
        var %x $calc(($cos($hget(demor, SpriteSinCount_ [ $+ [ %count ] ])).deg * (%pos + 75)) + ($hget(demor, CanvasSize_CenterX) - 32))
        var %y $calc((($sin($hget(demor, SpriteSinCount_ [ $+ [ %count ] ])).deg * (%pos + 75)) + ($hget(demor, CanvasSize_CenterY) - 32)) + $hget(demor, tunnel_sprite_scrollin))
        var %files 1 2 3 4 5 6 1 2 3 4 5 6
        drawpic -ntc @dmCanvas 16711935 %x %y $qt($+($scriptdirimg\,circle [ $+ [ $gettok(%files, %count, 32) ] ],.bmp))
        hinc demor SpriteSinCount_ [ $+ [ %count ] ] 2
        inc %count
    }
    if ($hget(demor, SpriteCount01) == 398) {
        hadd demor SpriteCount01 0
    }
    hdec demor tunnel_sprite_scrollin
    hinc demor SpriteCount01
    hdec demor TunnelFadeOut_01
    hinc demor TunnelFadeOut_02 2
    if ($insong.pos >= 71575) {
        hadd demor checkpoint 0
        hinc demor Part_Count
        .signal dmInit_End
        return dmDie
    }
}


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Greets
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

alias Demopart_Greets_Init {
    var %c2 1
    while (%c2 <= 6) {
        noop $dmDrawFrame(@dmCanvas, dmPrecalcAnim)
        hadd demor Greets_Text_ [ $+ [ %c2 ] ] $addtok($hget(demor, Greets_Text_ [ $+ [ %c2 ] ]), $read($scriptdiretc\greet-scrolls.txt, %c2), 32)
        hadd demor Greets_Text_Sin_ [ $+ [ %c2 ] ] $calc(27.3 * %c2)
        inc %c2
    }
    hadd demor scroll_x_count_01 $calc($hget(demor, CanvasSize_Width) * 2)
    hadd demor scroll_x_count_02 $hget(demor, CanvasSize_Width)
    hadd demor colourcycle_count_01 0
    hadd demor lightsource_pic star1.bmp
    var %count 1
    var %total $lines($scriptdiretc\greetlist.txt)
    hadd demor greets_logo_scrollin -300
    hadd demor greets_lightsource_scrollin 300
    while (%count <= %total) {
        noop $dmDrawFrame(@dmCanvas, dmPrecalcAnim)
        hadd demor Greets_Text_main $addtok($hget(demor, Greets_Text_Main), $read($scriptdiretc\greetlist.txt, %count), 32)
        inc %count
    }
    window -dpfoh @demor.greets.logofade.buffer 1 1 $hget(demor, CanvasSize_Width) 180
    noop $dmBlankCanvas(@demor.greets.logofade.buffer, 16711935)
    hadd demor greets_logofade_count 1
    var %count 1
    while (%count <= 180) {
        hadd demor greets_logofade_order $instok($hget(demor, greets_logofade_order), %count, $rand(1, $numtok($hget(demor, greets_logofade_order), 32)), 32)
        inc %count
    }
}

alias Demopart_Greets_Start {
    drawpic -ncst @dmCanvas 16711935 $calc(($sin($hget(demor, Greets_Text_Sin_1)).deg * 320) - 320) $hget(demor, greets_logo_scrollin) 1280 180 $qt($scriptdirimg\dss-logo2.bmp)
    if ($hget(demor, greets_logo_scrollin) < 0) {
        hinc demor greets_logo_scrollin
    }
    var %count 1
    while (%count <= 6) {
        hinc demor Greets_Text_Sin_ [ $+ [ %count ] ] 2
        inc %count
    }
    var %lightsource.x $calc($sin($hget(demor, Greets_Text_Sin_1)).deg * 3)
    var %lightsource.y $calc(($hget(demor, CanvasSize_CenterY) + 25) + ($cos($hget(demor, Greets_Text_Sin_1)).deg * 3))
    drawpic -nct @dmCanvas 16711935 $calc((%lightsource.x * 100) + ($hget(demor, CanvasSize_CenterX) - 32)) $calc(((%lightsource.y * 16) - 3050) + $hget(demor, greets_lightsource_scrollin)) $qt($+($scriptdirimg\,$hget(demor, lightsource_pic)))
    if (360 // $hget(demor, scroll_x_count_01)) {
        hadd demor lightsource_pic $+(star,$rand(1, 2),.bmp)
    }
    if ($hget(demor, greets_lightsource_scrollin) > 0) {
        hdec demor greets_lightsource_scrollin
    }
    if ($insong.pos >= 77589) {
        hadd demor checkpoint 0
        hinc demor Part_Count
        .signal dmInit_End
        return dmDie
    }
}

alias Demopart_Greets_Main {
    drawpic -ncst @dmCanvas 16711935 $calc(($sin($hget(demor, Greets_Text_Sin_1)).deg * 320) - 320) 0 1280 180 $qt($scriptdirimg\dss-logo2.bmp)
    ;;-------------
    var %lightsource.x $calc($sin($hget(demor, Greets_Text_Sin_1)).deg * 3)
    var %lightsource.y $calc(($hget(demor, CanvasSize_CenterY) + 25) + ($cos($hget(demor, Greets_Text_Sin_1)).deg * 3))
    drawtext -nor @dmCanvas 16777215 fixedsys 160 $calc(%lightsource.x + $hget(demor, scroll_x_count_01)) %lightsource.y $hget(demor, Greets_Text_main)
    drawtext -nor @dmCanvas 0 fixedsys 160 $hget(demor, scroll_x_count_01) $calc($hget(demor, CanvasSize_CenterY) + 25)) $hget(demor, Greets_Text_main)
    ;;-------------
    var %c $hget(demor, Colourcycle_Count_01)
    var %colours $!brgb( %c , 0 , 0 ):$!brgb( 0 , %c , 0 ):$!brgb( 0 , 0 , %c ):$!brgb( %c , %c , 0 ):$!brgb( %c , 0 , %c ):$!brgb( 0 , %c , %c )
    var %count 1
    while (%count <= 6) {
        if ($insong.pos > 88573) {
            drawtext -nr @dmCanvas $($gettok(%colours, %count, 58), 3) fixedsys 24 $hget(demor, scroll_x_count_02) $calc(($sin($hget(demor, Greets_Text_Sin_ [ $+ [ %count ] ])).deg * 80) + ($hget(demor, CanvasSize_CenterY) + 70)) $hget(demor, Greets_Text_ [ $+ [ %count ] ])
        }
        hinc demor Greets_Text_Sin_ [ $+ [ %count ] ] 2
        inc %count
    }
    ;;------------
    drawpic -nct @dmCanvas 16711935 $calc((%lightsource.x * 100) + ($hget(demor, CanvasSize_CenterX) - 32)) $calc((%lightsource.y * 16) - 3050) $qt($+($scriptdirimg\,$hget(demor, lightsource_pic)))
    if (360 // $hget(demor, scroll_x_count_01)) {
        hadd demor lightsource_pic $+(star,$rand(1, 2),.bmp)
    }
    ;;-----------
    hdec demor scroll_x_count_01 11
    if ($insong.pos > 89624) {
        hdec demor scroll_x_count_02 7
    }
    hinc demor Colourcycle_count_01 16
    if ($insong.pos >= 128815) {
        hadd demor checkpoint 0
        hinc demor Part_Count
        .signal dmInit_End
        return dmDie
    }
}

alias Demopart_Greets_Exit {
    drawpic -ncst @dmCanvas 16711935 $calc(($sin($hget(demor, Greets_Text_Sin_1)).deg * 320) - 320) 0 1280 180 $qt($scriptdirimg\dss-logo2.bmp)
    var %y $gettok($hget(demor, greets_logofade_order), $hget(demor, greets_logofade_count), 32)
    drawline -nr @demor.greets.logofade.buffer 0 1 0 %y $hget(demor, CanvasSize_Width) %y
    drawcopy -nt @demor.greets.logofade.buffer 16711935 1 1 $hget(demor, canvasSize_Width) 180 @dmCanvas 1 1 $hget(demor, canvasSize_Width) 180
    hinc demor greets_logofade_count
    hinc demor Greets_Text_Sin_1
    if ($insong.pos >= 134388) {
        hadd demor checkpoint 0
        hinc demor Part_Count
        .signal dmInit_End
        return dmDie
    }
}

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Plasma
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

alias demopart_Plasma_Init {
    var %pattern 256 512 640 720 1024 4096 8192 16384
    hadd demor plasma_pattern $gettok(%pattern, $rand(1, 8), 32)
    var %colours $!brgb( x , 0 , 0 ):$!brgb( 0 , x , 0 ):$!brgb( 0 , 0 , x ):$!brgb( x , x , 0 ):$!brgb( x , 0 , x ):$!brgb( 0 , x , x )
    hadd demor plasma_ActiveColour $gettok(%colours, $rand(1, 5), 58)
    window -dpfoh @demor.buffer.plasma 1 1 48 48
    noop $dmBlankCanvas(@demor.buffer.plasma, 0)
    hadd demor scroll_count_plasma_01 1280
    hadd demor plasma_pattern_count $rand(1, 8)
    hadd demor plasma_part_text $read($scriptdiretc\plasma-scroll.txt, 1)
    hadd demor plasma_fadein_count_01 $hget(demor, CanvasSize_CenterX)
    hadd demor plasma_fadein_count_02 $hget(demor, CanvasSize_CenterX)
    hadd demor plasma_scrollout 1
}

alias Demopart_Plasma_Start {
    if (1000 // $hget(demor, plasma_count)) {
        var %pattern 256 512 640 720 1024 4096 8192 16384
        hadd demor plasma_pattern $gettok(%pattern, $hget(demor, plasma_pattern_count), 32)
        if ($hget(demor, plasma_pattern_count) >= 8) {
            hadd demor plasma_pattern_count 0
        }
        hinc demor plasma_pattern_count
        var %colours $!brgb( x , 0 , 0 ):$!brgb( 0 , x , 0 ):$!brgb( 0 , 0 , x ):$!brgb( x , x , 0 ):$!brgb( x , 0 , x ):$!brgb( 0 , x , x )
        hadd demor plasma_ActiveColour $gettok(%colours, $rand(1, 5), 58)
    }
    var %s 48
    if (2 // $hget(demor, frame_count)) {
        var %p $hget(demor, plasma_pattern)
        var %y 0
        while (%y < %s) {
            var %x 0
            while (%x < %s) {
                var %c $calc(((%p + (%p * $sin(%x).deg)) + (%p + (%p * $sin(%y).deg))) + $hget(demor, plasma_count))
                ;drawrect -nrf @demor.buffer.plasma $($replace($hget(demor, plasma_ActiveColour), x, %c), 3) 1 %x %y 7 7
                drawrect -nrf @demor.buffer.plasma $brgb(0, %c, 0) 1 %x %y 7 7
                inc %x 8
            }
            inc %y 8
            hinc demor Plasma_Count 4
        }
    }
    var %main.count 0
    var %total 14
    while (%main.count < 5) {
        var %count 0
        while (%count < %total) {
            drawcopy -n @demor.buffer.plasma 0 0 %s %s @dmCanvas $calc(%count * %s) 0 %s %s
            inc %count
        }
        drawcopy -n @dmCanvas 0 0 $calc(%s * %total) %s @dmCanvas 0 $calc(%main.count * %s) $calc(%s * %total) %s
        inc %main.count
    }
    drawrect -nrf @dmCanvas 0 1 0 0 $hget(demor, plasma_fadein_count_01) 300
    drawrect -nrf @dmCanvas 0 1 $hget(demor, plasma_fadein_count_02) 0 $hget(demor, plasma_fadein_count_01) 300
    drawtext -nr @dmCanvas 16777215 fixedsys 72 $hget(demor, scroll_count_plasma_01) 250 $hget(demor, plasma_part_text)
    hdec demor scroll_count_plasma_01
    if ($hget(demor, plasma_fadein_count_01) > 0) {
        hdec demor plasma_fadein_count_01
        hinc demor plasma_fadein_count_02
    }
    if ($insong.pos >= 140825) {
        hadd demor checkpoint 0
        hinc demor Part_Count
        .signal dmInit_End
        return dmDie
    }
}

alias Demopart_Plasma_Main {
    if (1000 // $hget(demor, plasma_count)) {
        var %pattern 256 512 640 720 1024 4096 8192 16384
        hadd demor plasma_pattern $gettok(%pattern, $hget(demor, plasma_pattern_count), 32)
        if ($hget(demor, plasma_pattern_count) >= 8) {
            hadd demor plasma_pattern_count 0
        }
        hinc demor plasma_pattern_count
        var %colours $!brgb( x , 0 , 0 ):$!brgb( 0 , x , 0 ):$!brgb( 0 , 0 , x ):$!brgb( x , x , 0 ):$!brgb( x , 0 , x ):$!brgb( 0 , x , x )
        hadd demor plasma_ActiveColour $gettok(%colours, $rand(1, 5), 58)
    }
    var %s 48
    if (2 // $hget(demor, frame_count)) {
        var %p $hget(demor, plasma_pattern)
        var %y 0
        while (%y < %s) {
            var %x 0
            while (%x < %s) {
                var %c $calc(((%p + (%p * $sin(%x).deg)) + (%p + (%p * $sin(%y).deg))) + $hget(demor, plasma_count))
                ;drawrect -nrf @demor.buffer.plasma $($replace($hget(demor, plasma_ActiveColour), x, %c), 3) 1 %x %y 7 7
                drawrect -nrf @demor.buffer.plasma $brgb(0, %c, 0) 1 %x %y 7 7
                inc %x 8
            }
            inc %y 8
            hinc demor Plasma_Count 5
        }
    }
    var %main.count 0
    var %total 14
    while (%main.count < 5) {
        var %count 0
        while (%count < %total) {
            drawcopy -n @demor.buffer.plasma 0 0 %s %s @dmCanvas $calc(%count * %s) 0 %s %s
            inc %count
        }
        drawcopy -n @dmCanvas 0 0 $calc(%s * %total) %s @dmCanvas 0 $calc(%main.count * %s) $calc(%s * %total) %s
        inc %main.count
    }
    drawtext -nr @dmCanvas 16777215 fixedsys 72 $hget(demor, scroll_count_plasma_01) 250 $hget(demor, plasma_part_text)
    hdec demor scroll_count_plasma_01 4
    if ($insong.pos >= 172871) {
        hadd demor checkpoint 0
        hinc demor Part_Count
        .signal dmInit_End
        return dmDie
    }
}

alias Demopart_Plasma_Exit {
    if (1000 // $hget(demor, plasma_count)) {
        var %pattern 256 512 640 720 1024 4096 8192 16384
        hadd demor plasma_pattern $gettok(%pattern, $hget(demor, plasma_pattern_count), 32)
        if ($hget(demor, plasma_pattern_count) == 8) {
            hadd demor plasma_pattern_count 0
        }
        hinc demor plasma_pattern_count
        var %colours $!brgb( x , 0 , 0 ):$!brgb( 0 , x , 0 ):$!brgb( 0 , 0 , x ):$!brgb( x , x , 0 ):$!brgb( x , 0 , x ):$!brgb( 0 , x , x )
        hadd demor plasma_ActiveColour $gettok(%colours, $rand(1, 5), 58)
    }
    var %s 48
    if (2 // $hget(demor, frame_count)) {
        var %p $hget(demor, plasma_pattern)
        var %y 0
        while (%y < %s) {
            var %x 0
            while (%x < %s) {
                var %c $calc(((%p + (%p * $sin(%x).deg)) + (%p + (%p * $sin(%y).deg))) + $hget(demor, plasma_count))
                ;drawrect -nrf @demor.buffer.plasma $($replace($hget(demor, plasma_ActiveColour), x, %c), 3) 1 %x %y 7 7
                drawrect -nrf @demor.buffer.plasma $brgb(0, %c, 0) 1 %x %y 7 7
                inc %x 8
            }
            inc %y 8
            hinc demor Plasma_Count 4
        }
    }
    var %main.count 0
    var %total 14
    while (%main.count < 5) {
        var %count 0
        while (%count < %total) {
            drawcopy -n @demor.buffer.plasma 0 0 %s %s @dmCanvas $calc(%count * %s) 0 %s %s
            inc %count
        }
        drawcopy -n @dmCanvas 0 0 $calc(%s * %total) %s @dmCanvas 0 $calc(%main.count * %s) $calc(%s * %total) %s
        inc %main.count
    }
    drawrect -nrf @dmCanvas 0 1 0 0 $hget(demor, plasma_fadein_count_01) 300
    drawrect -nrf @dmCanvas 0 1 $hget(demor, plasma_fadein_count_02) 0 $hget(demor, plasma_fadein_count_01) 300
    drawtext -nr @dmCanvas 16777215 fixedsys 72 $hget(demor, scroll_count_plasma_01) 250 $hget(demor, plasma_part_text)
    hdec demor scroll_count_plasma_01 4
    if ($hget(demor, plasma_fadein_count_01) < $hget(demor, CanvasSize_CenterX)) {
        hinc demor plasma_fadein_count_01
        hdec demor plasma_fadein_count_02
    }
    if ($insong.pos >= 179217) {
        hadd demor checkpoint 0
        hinc demor Part_Count
        .signal dmInit_End
        return dmDie
    }
}

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;; Moire
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

alias Demopart_Moire_Init {
    hadd demor sin_count_01 1
    hadd demor sin_count_02 2
    hadd demor sin_count_03 5
    hadd demor sin_count_04 7
    ;;---------
    hadd demor CanvasSize_Buffer_Width $window(-1).w
    hadd demor CanvasSize_Buffer_Height $window(-1).h
    window -dpfoh @demor.buffer.moire.01 1 1 $hget(demor, CanvasSize_Buffer_Width) $hget(demor, CanvasSize_Buffer_Height)
    window -dpfoh @demor.buffer.moire.02 1 1 $hget(demor, CanvasSize_Buffer_Width) $hget(demor, CanvasSize_Buffer_Height)
    noop $dmBlankCanvas(@demor.buffer.moire.01, 0)
    noop $dmBlankCanvas(@demor.buffer.moire.02, 0)
    moire @demor.buffer.moire.01 $rgb(0, 255, 255) $hget(demor, CanvasSize_Buffer_Width) $hget(demor, CanvasSize_Buffer_Height)
    moire @demor.buffer.moire.02 $rgb(0, 0, 255) $hget(demor, CanvasSize_Buffer_Width) $hget(demor, CanvasSize_Buffer_Height)
    ;;---------
    hadd demor LogoPic1 $qt($scriptdirimg\dss-logo1a.bmp)
    hadd demor moire_logo_scrollin 370
    ;;---------
    return
}

alias Demopart_Moire_Main {
    var %canvas.center.x $hget(demor, CanvasSize_CenterX)
    var %canvas.center.y $hget(demor, CanvasSize_CenterY)
    var %canvas.width $hget(demor, CanvasSize_Width)
    var %canvas.height $hget(demor, CanvasSize_Height)
    ;---------------------------
    var %x $calc((($cos($hget(demor, sin_count_01)).deg * 150) + ($hget(demor, CanvasSize_CenterX) * 2)) - 50)
    var %y $calc(($sin($hget(demor, sin_count_02)).deg * 250) + ($hget(demor, CanvasSize_CenterY) * 2))
    drawcopy -ntri @demor.buffer.moire.01 0 %x %y %canvas.width %canvas.height @dmCanvas 0 0 %canvas.width %canvas.height
    ;;--------------------------
    var %x $calc((($cos($hget(demor, sin_count_04)).deg * 400) + ($hget(demor, CanvasSize_CenterX) * 2)) - 50)
    var %y $calc(($sin($hget(demor, sin_count_03)).deg * (320 / 2)) + ($hget(demor, CanvasSize_CenterY) * 2))
    drawcopy -ntri @demor.buffer.moire.02 0 %x %y %canvas.width %canvas.height @dmCanvas 0 0 %canvas.width %canvas.height
    ;;--------------------------
    hinc demor sin_count_01 1
    hdec demor sin_count_02 2
    hinc demor sin_count_03 3
    hdec demor sin_count_04 2
    ;;--------------------------
    var %x $calc((%canvas.center.x - 60) + ($cos($hget(demor, sin_count_01)).deg * %canvas.center.x))
    drawpic -ntc @dmCanvas 16711935 $calc(0 + %x) -10 $hget(demor, LogoPic1)
    drawreplace -nr @dmCanvas 16711680 65280 0 0 $calc(%x + 60) %canvas.height
    ;;--------------------------
    hinc demor sin_count_01 1
    if ($hget(demor, moire_logo_scrollin) > -10) {
        hdec demor moire_logo_scrollin
    }
    if ($insong.pos >= 204821) {
        hadd demor checkpoint 0
        hinc demor Part_Count
        .signal dmInit_End
        return dmDie
    }
}

alias Demopart_Moire_Exit {
    var %canvas.center.x $hget(demor, CanvasSize_CenterX)
    var %canvas.center.y $hget(demor, CanvasSize_CenterY)
    var %canvas.width $hget(demor, CanvasSize_Width)
    var %canvas.height $hget(demor, CanvasSize_Height)
    ;---------------------------
    var %x $calc((($cos($hget(demor, sin_count_01)).deg * 150) + ($hget(demor, CanvasSize_CenterX) * 2)) - 50)
    var %y $calc(($sin($hget(demor, sin_count_02)).deg * 250) + ($hget(demor, CanvasSize_CenterY) * 2))
    drawcopy -ntri @demor.buffer.moire.01 0 %x %y %canvas.width %canvas.height @dmCanvas 0 $calc($hget(demor, moire_logo_scrollin) + 10) %canvas.width %canvas.height
    ;;--------------------------
    var %x $calc((($cos($hget(demor, sin_count_04)).deg * 400) + ($hget(demor, CanvasSize_CenterX) * 2)) - 50)
    var %y $calc(($sin($hget(demor, sin_count_03)).deg * (320 / 2)) + ($hget(demor, CanvasSize_CenterY) * 2))
    drawcopy -ntri @demor.buffer.moire.02 0 %x %y %canvas.width %canvas.height @dmCanvas 0 $calc($hget(demor, moire_logo_scrollin) + 10) %canvas.width %canvas.height
    ;;--------------------------
    hinc demor sin_count_01 1
    hdec demor sin_count_02 2
    hinc demor sin_count_03 3
    hdec demor sin_count_04 2
    ;;--------------------------
    var %x $calc((%canvas.center.x - 60) + ($cos($hget(demor, sin_count_01)).deg * %canvas.center.x))
    drawpic -ntc @dmCanvas 16711935 $calc(0 + %x) $hget(demor, moire_logo_scrollin) $hget(demor, LogoPic1)
    drawreplace -nr @dmCanvas 16711680 65280 0 0 $calc(%x + 60) %canvas.height
    ;;--------------------------
    hinc demor sin_count_01 1
    if (2 // $hget(demor, frame_count)) {
        if ($hget(demor, moire_logo_scrollin) > -400) {
            hdec demor moire_logo_scrollin
        }
    }
    if ($insong.pos >= 219639) {
        hadd demor checkpoint 0
        hinc demor Part_Count
        .signal dmInit_End
        return dmDie
    }
}


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; End part
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

alias Demopart_End_Init {
    window -dpfoh @demor.buffer.end.pic01 1 1 $calc($hget(demor, CanvasSize_Width) * 2) $calc($hget(demor, CanvasSize_Height) * 2)
    drawpic -ncst @demor.buffer.end.pic01 0 0 0 $qt($scriptdirimg\square-logo1.bmp)
    hadd demor bg_pic_sinX 10
    hadd demor bg_pic_sinY 10
    var %w 256
    var %h 128
    var %total 10
    var %main.count 1
    while (%main.count < 6) {
        var %count 0
        while (%count < %total) {
            noop $dmDrawFrame(@dmCanvas, dmPrecalcAnim)
            drawcopy -t @demor.buffer.end.pic01 0 0 0 %w %h @demor.buffer.end.pic01 $calc(%count * %w) 0 %w %h
            inc %count
        }
        drawcopy -t @demor.buffer.end.pic01 0 0 0 $calc(%w * %total) %h @demor.buffer.end.pic01 0 $calc(%main.count * %h) $calc(%w * %total) %h
        inc %main.count
    }
    var %text Q u o d : E r a t : D e m o n s t r a n d u m
    ;var %text D i g i t a l : S o u n d s : S y s t e m
    var %count 1
    var %total $numtok(%text, 32)
    while (%count <= %total) {
        hadd demor end_sprite_sin_ [ $+ [ %count ] ] $calc(22.5 * %count)
        inc %count
    }
    hadd demor end_fadein_x01 $+(-,$hget(demor, CanvasSize_Width))
    hadd demor end_fadein_x02 $hget(demor, CanvasSize_Width)
}

alias Demopart_End_Main {
    var %x $calc(($cos($hget(demor, bg_pic_sinX)).deg * 325) + 320)
    var %y $calc(($sin($hget(demor, bg_pic_sinY)).deg * 180) + 180)
    drawcopy -nt @demor.buffer.end.pic01 0 %x %y $hget(demor, CanvasSize_Width) $hget(demor, CanvasSize_Height) @dmCanvas $hget(demor, end_fadein_x01) 0 $hget(demor, CanvasSize_Width) $hget(demor, CanvasSize_Height)
    var %x $calc(($cos($calc($hget(demor, bg_pic_sinY) / 1.5)).deg * 500) - 500)
    var %y $calc(($sin($hget(demor, bg_pic_sinY)).deg * 50) + 150)
    var %text Q u o d : E r a t : D e m o n s t r a n d u m
    var %count 1
    var %s 64
    var %total $numtok(%text, 32)
    while (%count <= %total) {
        var %char $gettok(%text, %count, 32)
        if (%char != :) {
            var %x1 $calc((%x + (%s * %count)) + $hget(demor, end_fadein_x02))
            var %y1 $calc(%y + ($cos($hget(demor, end_sprite_sin_ [ $+ [ %count ] ])).deg * 100))
            if (($dmInCanvas(%x1).x == $true) && ($dmInCanvas(%y1).y == $true)) {
                drawpic -ntsc @dmCanvas 0 %x1 %y1 %s %s $qt($+($scriptdirimg\letters\,%char,.bmp))
            }
            hinc demor end_sprite_sin_ [ $+ [ %count ] ] 2
        }
        inc %count
    }
    hinc demor bg_pic_sinX 2
    hinc demor bg_pic_sinY 1
    if ($hget(demor, end_fadein_x01) < 0) {
        hinc demor end_fadein_x01
        hdec demor end_fadein_x02
    }
}

;------- various aliases


alias Rasterbar {
    var %win = $1, %y = $2, %w = $3, %h = $4, %c = $5
    if (%c == red) {
        var %count 0
        var %c 5
        while (%count <= %h) {
            drawline -nr %win $brgb(%c, 0, 0) 4 0 %y %w %y
            inc %c 40
            inc %y 4
            inc %count
            noop $dmDrawFrame(@dmCanvas, dmPrecalcAnim)
        }
    }
    if (%c == green) {
        var %count 0
        var %c 5
        while (%count <= %h) {
            drawline -nr %win $brgb(0, %c, 0) 4 0 %y %w %y
            inc %c 40
            inc %y 4
            inc %count
            noop $dmDrawFrame(@dmCanvas, dmPrecalcAnim)
        }

    }
    if (%c == blue) {
        var %count 0
        var %c 5
        while (%count <= %h) {
            drawline -nr %win $brgb(0, 0, %c) 4 0 %y %w %y
            inc %c 40
            inc %y 4
            inc %count
            noop $dmDrawFrame(@dmCanvas, dmPrecalcAnim)
        }
    }
}


alias moire {
    var %win $1
    var %rgb $2
    var %width $calc($4 * 2)
    var %height $calc($4 * 2)
    var %pos.x $+(-,$calc($3 / 8))
    var %pos.y $+(-,$calc($4 / 2))
    var %count 1
    while (%count <= 54) {
        noop $dmDrawFrame(@dmCanvas, dmPrecalcAnim)
        drawrect -nre %win %rgb 10 %pos.x %pos.y %width %width
        inc %pos.x 20
        inc %pos.y 20
        dec %width 40
        inc %count
        sleep 10
    }
}


alias no_future {
    dmInit
}

on *:LOAD: {
    var %dir $scriptdir
    var %missing 0
    if ($file($+(%dir,demoralization.mrc)) != $null) {
        load -rs $+(%dir,demoralization.mrc)
    }
    else {
        echo @test $+(%dir,demoralization.mrc) not found!
        inc %missing
    }
    if (%missing >= 1) {
        echo @test One or more dependencies not found, please get a fresh copy and try again.
    }
}


on *:KEYDOWN:@dmCanvas:*: {
    if ($keyval == 32) {
        echo @test checkpoint: $insong.pos
        hadd demor checkpoint 1
    }
}


;; thanks BlueThen :_)
alias brgb {
  var %brgb.r, %brgb.g, %brgb.b
  if ($1 > 255) %brgb.r = $calc($iif(. isin $calc($int($calc($1 / 255))/2) ,255 -)($1 - (255 * $int($calc($1 / 255)))))
  else %brgb.r = $1
  if ($2 > 255) %brgb.g = $calc($iif(. isin $calc($int($calc($2 / 255))/2) ,255 -)($2 - (255 * $int($calc($2 / 255)))))
  else %brgb.g = $2
  if ($3 > 255) %brgb.b = $calc($iif(. isin $calc($int($calc($3 / 255))/2) ,255 -)($3 - (255 * $int($calc($3 / 255)))))
  else %brgb.b = $3
  return $rgb(%brgb.r,%brgb.g,%brgb.b)
}